/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor.event;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.wontlost.ckeditor.VaadinCKEditor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FallbackEvent
extends ComponentEvent<VaadinCKEditor> {
    private final FallbackMode mode;
    private final String reason;
    private final String originalError;

    public FallbackEvent(VaadinCKEditor source, boolean fromClient, FallbackMode mode, String reason, String originalError) {
        super((Component)source, fromClient);
        this.mode = mode;
        this.reason = reason;
        this.originalError = originalError;
    }

    public FallbackMode getMode() {
        return this.mode;
    }

    public String getReason() {
        return this.reason;
    }

    public String getOriginalError() {
        return this.originalError;
    }

    public static enum FallbackMode {
        TEXTAREA("textarea"),
        READ_ONLY("readonly"),
        ERROR_MESSAGE("error"),
        HIDDEN("hidden");

        private final String jsName;
        private static final Map<String, FallbackMode> JS_NAME_MAP;

        private FallbackMode(String jsName) {
            this.jsName = jsName;
        }

        public String getJsName() {
            return this.jsName;
        }

        public static FallbackMode fromJsName(String jsName) {
            FallbackMode mode = JS_NAME_MAP.get(jsName);
            return mode != null ? mode : ERROR_MESSAGE;
        }

        static {
            HashMap<String, FallbackMode> map = new HashMap<String, FallbackMode>();
            for (FallbackMode mode : FallbackMode.values()) {
                map.put(mode.jsName, mode);
            }
            JS_NAME_MAP = Collections.unmodifiableMap(map);
        }
    }
}

