/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum CKEditorPlugin {
    ESSENTIALS("Essentials", Category.CORE, new String[0]),
    PARAGRAPH("Paragraph", Category.CORE, new String[0]),
    UNDO("Undo", Category.CORE, "undo", "redo"),
    CLIPBOARD("Clipboard", Category.CORE, new String[0]),
    TYPING("Typing", Category.CORE, new String[0]),
    SELECT_ALL("SelectAll", Category.CORE, "selectAll"),
    BOLD("Bold", Category.BASIC_STYLES, "bold"),
    ITALIC("Italic", Category.BASIC_STYLES, "italic"),
    UNDERLINE("Underline", Category.BASIC_STYLES, "underline"),
    STRIKETHROUGH("Strikethrough", Category.BASIC_STYLES, "strikethrough"),
    CODE("Code", Category.BASIC_STYLES, "code"),
    SUPERSCRIPT("Superscript", Category.BASIC_STYLES, "superscript"),
    SUBSCRIPT("Subscript", Category.BASIC_STYLES, "subscript"),
    FONT_SIZE("FontSize", Category.FONT, "fontSize"),
    FONT_FAMILY("FontFamily", Category.FONT, "fontFamily"),
    FONT_COLOR("FontColor", Category.FONT, "fontColor"),
    FONT_BACKGROUND_COLOR("FontBackgroundColor", Category.FONT, "fontBackgroundColor"),
    HEADING("Heading", Category.PARAGRAPH, "heading"),
    ALIGNMENT("Alignment", Category.PARAGRAPH, "alignment"),
    INDENT("Indent", Category.PARAGRAPH, "indent", "outdent"),
    INDENT_BLOCK("IndentBlock", Category.PARAGRAPH, new String[0]),
    BLOCK_QUOTE("BlockQuote", Category.PARAGRAPH, "blockQuote"),
    LINE_HEIGHT("LineHeight", Category.PARAGRAPH, "lineHeight"),
    LIST("List", Category.LIST, "bulletedList", "numberedList"),
    TODO_LIST("TodoList", Category.LIST, "todoList"),
    LINK("Link", Category.LINK, "link"),
    AUTO_LINK("AutoLink", Category.LINK, new String[0]),
    IMAGE("Image", Category.IMAGE, new String[0]),
    IMAGE_TOOLBAR("ImageToolbar", Category.IMAGE, new String[0]),
    IMAGE_CAPTION("ImageCaption", Category.IMAGE, new String[0]),
    IMAGE_STYLE("ImageStyle", Category.IMAGE, new String[0]),
    IMAGE_RESIZE("ImageResize", Category.IMAGE, new String[0]),
    IMAGE_UPLOAD("ImageUpload", Category.IMAGE, "imageUpload"),
    IMAGE_INSERT("ImageInsert", Category.IMAGE, "insertImage"),
    IMAGE_BLOCK("ImageBlock", Category.IMAGE, new String[0]),
    IMAGE_INLINE("ImageInline", Category.IMAGE, new String[0]),
    LINK_IMAGE("LinkImage", Category.IMAGE, "linkImage"),
    AUTO_IMAGE("AutoImage", Category.IMAGE, new String[0]),
    BASE64_UPLOAD_ADAPTER("Base64UploadAdapter", Category.UPLOAD, new String[0]),
    SIMPLE_UPLOAD_ADAPTER("SimpleUploadAdapter", Category.UPLOAD, new String[0]),
    TABLE("Table", Category.TABLE, "insertTable"),
    TABLE_TOOLBAR("TableToolbar", Category.TABLE, new String[0]),
    TABLE_PROPERTIES("TableProperties", Category.TABLE, new String[0]),
    TABLE_CELL_PROPERTIES("TableCellProperties", Category.TABLE, new String[0]),
    TABLE_CAPTION("TableCaption", Category.TABLE, new String[0]),
    TABLE_COLUMN_RESIZE("TableColumnResize", Category.TABLE, new String[0]),
    MEDIA_EMBED("MediaEmbed", Category.MEDIA, "mediaEmbed"),
    HTML_EMBED("HtmlEmbed", Category.MEDIA, "htmlEmbed"),
    CODE_BLOCK("CodeBlock", Category.CODE, "codeBlock"),
    HORIZONTAL_LINE("HorizontalLine", Category.SPECIAL, "horizontalLine"),
    PAGE_BREAK("PageBreak", Category.SPECIAL, "pageBreak"),
    SPECIAL_CHARACTERS("SpecialCharacters", Category.SPECIAL, "specialCharacters"),
    SPECIAL_CHARACTERS_ESSENTIALS("SpecialCharactersEssentials", Category.SPECIAL, new String[0]),
    AUTOFORMAT("Autoformat", Category.EDITING, new String[0]),
    TEXT_TRANSFORMATION("TextTransformation", Category.EDITING, new String[0]),
    FIND_AND_REPLACE("FindAndReplace", Category.EDITING, "findAndReplace"),
    REMOVE_FORMAT("RemoveFormat", Category.EDITING, "removeFormat"),
    SOURCE_EDITING("SourceEditing", Category.EDITING, "sourceEditing"),
    SHOW_BLOCKS("ShowBlocks", Category.EDITING, "showBlocks"),
    HIGHLIGHT("Highlight", Category.EDITING, "highlight"),
    MENTION("Mention", Category.MENTION, new String[0]),
    AUTOSAVE("Autosave", Category.DOCUMENT, new String[0]),
    WORD_COUNT("WordCount", Category.DOCUMENT, new String[0]),
    TITLE("Title", Category.DOCUMENT, new String[0]),
    PASTE_FROM_OFFICE("PasteFromOffice", Category.DOCUMENT, new String[0]),
    GENERAL_HTML_SUPPORT("GeneralHtmlSupport", Category.HTML, new String[0]),
    HTML_COMMENT("HtmlComment", Category.HTML, new String[0]),
    STYLE("Style", Category.HTML, "style"),
    RESTRICTED_EDITING_MODE("RestrictedEditingMode", Category.RESTRICTED, "restrictedEditing"),
    STANDARD_EDITING_MODE("StandardEditingMode", Category.RESTRICTED, "restrictedEditingException"),
    BOOKMARK("Bookmark", Category.SPECIAL, "bookmark"),
    FULLSCREEN("Fullscreen", Category.EDITING, "fullscreen"),
    MARKDOWN("Markdown", Category.DOCUMENT, new String[0]),
    PASTE_FROM_MARKDOWN_EXPERIMENTAL("PasteFromMarkdownExperimental", Category.DOCUMENT, new String[0]),
    LIST_PROPERTIES("ListProperties", Category.LIST, new String[0]),
    LIST_FORMATTING("ListFormatting", Category.LIST, new String[0]),
    ADJACENT_LISTS_SUPPORT("AdjacentListsSupport", Category.LIST, new String[0]),
    SPECIAL_CHARACTERS_ARROWS("SpecialCharactersArrows", Category.SPECIAL, new String[0]),
    SPECIAL_CHARACTERS_CURRENCY("SpecialCharactersCurrency", Category.SPECIAL, new String[0]),
    SPECIAL_CHARACTERS_LATIN("SpecialCharactersLatin", Category.SPECIAL, new String[0]),
    SPECIAL_CHARACTERS_MATHEMATICAL("SpecialCharactersMathematical", Category.SPECIAL, new String[0]),
    SPECIAL_CHARACTERS_TEXT("SpecialCharactersText", Category.SPECIAL, new String[0]),
    TEXT_PART_LANGUAGE("TextPartLanguage", Category.EDITING, "textPartLanguage"),
    CLOUD_SERVICES("CloudServices", Category.UPLOAD, new String[0]),
    CLOUD_SERVICES_CORE("CloudServicesCore", Category.UPLOAD, new String[0]),
    CLOUD_SERVICES_UPLOAD_ADAPTER("CloudServicesUploadAdapter", Category.UPLOAD, new String[0]),
    EASY_IMAGE("EasyImage", Category.IMAGE, new String[0]),
    MINIMAP("Minimap", Category.EDITING, new String[0]),
    WIDGET("Widget", Category.CORE, new String[0]),
    WIDGET_TOOLBAR_REPOSITORY("WidgetToolbarRepository", Category.CORE, new String[0]),
    WIDGET_RESIZE("WidgetResize", Category.CORE, new String[0]),
    WIDGET_TYPE_AROUND("WidgetTypeAround", Category.CORE, new String[0]),
    EMOJI("Emoji", Category.SPECIAL, "emoji"),
    EMOJI_PICKER("EmojiPicker", Category.SPECIAL, new String[0]);

    private final String jsName;
    private final Category category;
    private final Set<String> toolbarItems;
    private static final Map<String, CKEditorPlugin> JS_NAME_MAP;

    private CKEditorPlugin(String jsName, Category category, String ... toolbarItems) {
        this.jsName = jsName;
        this.category = category;
        this.toolbarItems = toolbarItems.length > 0 ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(toolbarItems))) : Collections.emptySet();
    }

    public String getJsName() {
        return this.jsName;
    }

    public Category getCategory() {
        return this.category;
    }

    public Set<String> getToolbarItems() {
        return this.toolbarItems;
    }

    public boolean isPremium() {
        return false;
    }

    public static Set<CKEditorPlugin> getByCategory(Category category) {
        HashSet<CKEditorPlugin> result = new HashSet<CKEditorPlugin>();
        for (CKEditorPlugin plugin : CKEditorPlugin.values()) {
            if (plugin.category != category) continue;
            result.add(plugin);
        }
        return Collections.unmodifiableSet(result);
    }

    public static CKEditorPlugin fromJsName(String jsName) {
        return JS_NAME_MAP.get(jsName);
    }

    static {
        HashMap<String, CKEditorPlugin> map = new HashMap<String, CKEditorPlugin>();
        for (CKEditorPlugin plugin : CKEditorPlugin.values()) {
            map.put(plugin.jsName, plugin);
        }
        JS_NAME_MAP = Collections.unmodifiableMap(map);
    }

    public static enum Category {
        CORE("Core"),
        BASIC_STYLES("Basic Styles"),
        FONT("Font"),
        PARAGRAPH("Paragraph"),
        LIST("List"),
        LINK("Link"),
        IMAGE("Image"),
        UPLOAD("Upload"),
        TABLE("Table"),
        MEDIA("Media"),
        CODE("Code"),
        SPECIAL("Special Content"),
        EDITING("Editing"),
        MENTION("Mention"),
        DOCUMENT("Document"),
        HTML("HTML Support"),
        RESTRICTED("Restricted Editing"),
        CUSTOM("Custom");

        private final String displayName;

        private Category(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

