/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor.internal;

import com.wontlost.ckeditor.handler.UploadHandler;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UploadManager {
    private static final Logger logger = Logger.getLogger(UploadManager.class.getName());
    private final UploadHandler uploadHandler;
    private final UploadHandler.UploadConfig uploadConfig;
    private final UploadResultCallback resultCallback;
    private final Map<String, UploadTask> activeTasks = new ConcurrentHashMap<String, UploadTask>();
    private final AtomicLong uploadCounter = new AtomicLong(0L);

    public UploadManager(UploadHandler uploadHandler, UploadHandler.UploadConfig uploadConfig, UploadResultCallback resultCallback) {
        this.uploadHandler = uploadHandler;
        this.uploadConfig = uploadConfig != null ? uploadConfig : new UploadHandler.UploadConfig();
        this.resultCallback = resultCallback;
    }

    public void handleUpload(String uploadId, String fileName, String mimeType, String base64Data) {
        byte[] fileData;
        if (this.uploadHandler == null) {
            this.notifyError(uploadId, "No upload handler configured");
            return;
        }
        try {
            fileData = Base64.getDecoder().decode(base64Data);
        }
        catch (IllegalArgumentException e) {
            this.notifyError(uploadId, "Invalid file data: " + e.getMessage());
            return;
        }
        long fileSize = fileData.length;
        UploadHandler.UploadContext context = new UploadHandler.UploadContext(fileName, mimeType, fileSize);
        String validationError = this.uploadConfig.validate(context);
        if (validationError != null) {
            this.notifyError(uploadId, validationError);
            return;
        }
        UploadTask task = new UploadTask(uploadId, fileName, mimeType, fileSize);
        this.activeTasks.put(uploadId, task);
        task.setStatus(UploadStatus.IN_PROGRESS);
        CompletableFuture<UploadHandler.UploadResult> future = this.uploadHandler.handleUpload(context, new ByteArrayInputStream(fileData));
        task.setFuture(future);
        future.handle((result, ex) -> {
            UploadTask uploadTask = task;
            synchronized (uploadTask) {
                if (task.getStatus() == UploadStatus.CANCELLED) {
                    this.activeTasks.remove(uploadId);
                    return null;
                }
                if (ex != null) {
                    Throwable cause = ex instanceof CompletionException && ex.getCause() != null ? ex.getCause() : ex;
                    task.setStatus(UploadStatus.FAILED);
                    Object errorMsg = cause.getMessage();
                    if (errorMsg == null || ((String)errorMsg).isEmpty()) {
                        errorMsg = cause.getClass().getSimpleName() + " occurred during upload";
                    }
                    task.setErrorMessage((String)errorMsg);
                    this.notifyResult(uploadId, null, (String)errorMsg);
                } else if (result != null && result.isSuccess()) {
                    task.setStatus(UploadStatus.COMPLETED);
                    task.setResultUrl(result.getUrl());
                    this.notifyResult(uploadId, result.getUrl(), null);
                } else {
                    task.setStatus(UploadStatus.FAILED);
                    String errorMsg = result != null ? result.getErrorMessage() : "Unknown upload error";
                    task.setErrorMessage(errorMsg);
                    this.notifyResult(uploadId, null, errorMsg);
                }
                this.activeTasks.remove(uploadId);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelUpload(String uploadId) {
        UploadTask task = this.activeTasks.get(uploadId);
        if (task != null) {
            UploadTask uploadTask = task;
            synchronized (uploadTask) {
                if (task.getStatus() == UploadStatus.IN_PROGRESS || task.getStatus() == UploadStatus.PENDING) {
                    task.setStatus(UploadStatus.CANCELLED);
                    task.setErrorMessage("Upload cancelled");
                    CompletableFuture<?> future = task.getFuture();
                    if (future != null) {
                        future.cancel(true);
                    }
                    this.notifyResult(uploadId, null, "Upload cancelled");
                    this.activeTasks.remove(uploadId);
                    return true;
                }
            }
        }
        return false;
    }

    public int getActiveUploadCount() {
        return this.activeTasks.size();
    }

    public boolean hasActiveUploads() {
        return !this.activeTasks.isEmpty();
    }

    public UploadTask getUploadTask(String uploadId) {
        return this.activeTasks.get(uploadId);
    }

    public void cleanup() {
        for (String uploadId : this.activeTasks.keySet()) {
            this.cancelUpload(uploadId);
        }
        this.activeTasks.clear();
    }

    private void notifyError(String uploadId, String error) {
        logger.log(Level.WARNING, "Upload failed for {0}: {1}", new Object[]{uploadId, error});
        this.notifyResult(uploadId, null, error);
    }

    private void notifyResult(String uploadId, String url, String error) {
        if (this.resultCallback != null) {
            try {
                this.resultCallback.onComplete(uploadId, url, error);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in upload result callback", e);
            }
        }
    }

    @FunctionalInterface
    public static interface UploadResultCallback {
        public void onComplete(String var1, String var2, String var3);
    }

    public static class UploadTask {
        private final String uploadId;
        private final String fileName;
        private final String mimeType;
        private final long fileSize;
        private final long startTime;
        private volatile UploadStatus status;
        private volatile String resultUrl;
        private volatile String errorMessage;
        private volatile CompletableFuture<?> future;

        UploadTask(String uploadId, String fileName, String mimeType, long fileSize) {
            this.uploadId = uploadId;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.fileSize = fileSize;
            this.startTime = System.currentTimeMillis();
            this.status = UploadStatus.PENDING;
        }

        public String getUploadId() {
            return this.uploadId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public UploadStatus getStatus() {
            return this.status;
        }

        public String getResultUrl() {
            return this.resultUrl;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        void setStatus(UploadStatus status) {
            this.status = status;
        }

        void setResultUrl(String url) {
            this.resultUrl = url;
        }

        void setErrorMessage(String error) {
            this.errorMessage = error;
        }

        void setFuture(CompletableFuture<?> future) {
            this.future = future;
        }

        CompletableFuture<?> getFuture() {
            return this.future;
        }
    }

    public static enum UploadStatus {
        PENDING,
        IN_PROGRESS,
        COMPLETED,
        FAILED,
        CANCELLED;

    }
}

