/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor.handler;

import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@FunctionalInterface
public interface UploadHandler {
    public CompletableFuture<UploadResult> handleUpload(UploadContext var1, InputStream var2);

    public static class UploadConfig {
        public static final long MIN_FILE_SIZE = 1L;
        public static final long MAX_FILE_SIZE_LIMIT = 0x40000000L;
        public static final long DEFAULT_MAX_FILE_SIZE = 0xA00000L;
        private long maxFileSize = 0xA00000L;
        private Set<String> allowedMimeTypes = new LinkedHashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/gif", "image/webp"));

        public long getMaxFileSize() {
            return this.maxFileSize;
        }

        public UploadConfig setMaxFileSize(long maxFileSize) {
            if (maxFileSize < 1L || maxFileSize > 0x40000000L) {
                throw new IllegalArgumentException(String.format("maxFileSize must be between %d and %d bytes, got %d", 1L, 0x40000000L, maxFileSize));
            }
            this.maxFileSize = maxFileSize;
            return this;
        }

        public String[] getAllowedMimeTypes() {
            return this.allowedMimeTypes.toArray(new String[0]);
        }

        public UploadConfig setAllowedMimeTypes(String ... allowedMimeTypes) {
            if (allowedMimeTypes == null) {
                throw new IllegalArgumentException("allowedMimeTypes cannot be null");
            }
            this.allowedMimeTypes = new LinkedHashSet<String>();
            for (String mimeType : allowedMimeTypes) {
                if (mimeType == null || mimeType.trim().isEmpty()) {
                    throw new IllegalArgumentException("MIME type cannot be null or empty");
                }
                this.allowedMimeTypes.add(mimeType.trim());
            }
            return this;
        }

        public UploadConfig addAllowedMimeTypes(String ... mimeTypes) {
            if (mimeTypes != null) {
                for (String mimeType : mimeTypes) {
                    if (mimeType == null || mimeType.trim().isEmpty()) continue;
                    this.allowedMimeTypes.add(mimeType.trim());
                }
            }
            return this;
        }

        public UploadConfig resetAllowedMimeTypes() {
            this.allowedMimeTypes = new LinkedHashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/gif", "image/webp"));
            return this;
        }

        public String validate(UploadContext context) {
            if (context == null) {
                return "Upload context cannot be null";
            }
            if (context.getFileSize() > this.maxFileSize) {
                return String.format("File size %d exceeds maximum allowed %d bytes", context.getFileSize(), this.maxFileSize);
            }
            if (!this.allowedMimeTypes.isEmpty() && !this.allowedMimeTypes.contains(context.getMimeType())) {
                return String.format("MIME type '%s' is not allowed. Allowed types: %s", context.getMimeType(), String.join((CharSequence)", ", this.allowedMimeTypes));
            }
            return null;
        }
    }

    public static class UploadResult {
        private final String url;
        private final boolean success;
        private final String errorMessage;

        public UploadResult(String url) {
            this.url = url;
            this.success = true;
            this.errorMessage = null;
        }

        public static UploadResult failure(String errorMessage) {
            return new UploadResult(null, false, errorMessage);
        }

        private UploadResult(String url, boolean success, String errorMessage) {
            this.url = url;
            this.success = success;
            this.errorMessage = errorMessage;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static class UploadContext {
        private final String fileName;
        private final String mimeType;
        private final long fileSize;

        public UploadContext(String fileName, String mimeType, long fileSize) {
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.fileSize = fileSize;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public boolean isImage() {
            return this.mimeType != null && this.mimeType.startsWith("image/");
        }
    }
}

