/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor.handler;

import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

@FunctionalInterface
public interface HtmlSanitizer {
    public String sanitize(String var1);

    public static HtmlSanitizer withPolicy(SanitizationPolicy policy) {
        return html -> {
            if (html == null || html.isEmpty()) {
                return "";
            }
            switch (policy.ordinal()) {
                case 0: {
                    return html;
                }
                case 1: {
                    return Jsoup.clean((String)html, (Safelist)Safelist.basic());
                }
                case 2: {
                    return Jsoup.clean((String)html, (Safelist)Safelist.relaxed());
                }
                case 3: {
                    Safelist strict = new Safelist().addTags(new String[]{"p", "br", "b", "i", "u", "strong", "em"}).addTags(new String[]{"h1", "h2", "h3", "h4", "h5", "h6"}).addTags(new String[]{"ul", "ol", "li"}).addTags(new String[]{"blockquote", "pre", "code"});
                    return Jsoup.clean((String)html, (Safelist)strict);
                }
            }
            return Jsoup.clean((String)html, (Safelist)Safelist.basic());
        };
    }

    public static HtmlSanitizer withSafelist(Safelist safelist) {
        return html -> {
            if (html == null || html.isEmpty()) {
                return "";
            }
            return Jsoup.clean((String)html, (Safelist)safelist);
        };
    }

    default public HtmlSanitizer andThen(HtmlSanitizer other) {
        return html -> other.sanitize(this.sanitize(html));
    }

    public static HtmlSanitizer passthrough() {
        return html -> html;
    }

    public static enum SanitizationPolicy {
        NONE,
        BASIC,
        RELAXED,
        STRICT;

    }
}

