/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor.event;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.wontlost.ckeditor.VaadinCKEditor;

public class ContentChangeEvent
extends ComponentEvent<VaadinCKEditor> {
    private final String oldContent;
    private final String newContent;
    private final ChangeSource changeSource;

    public ContentChangeEvent(VaadinCKEditor source, boolean fromClient, String oldContent, String newContent, ChangeSource changeSource) {
        super((Component)source, fromClient);
        this.oldContent = oldContent;
        this.newContent = newContent;
        this.changeSource = changeSource;
    }

    public String getOldContent() {
        return this.oldContent;
    }

    public String getNewContent() {
        return this.newContent;
    }

    public ChangeSource getChangeSource() {
        return this.changeSource;
    }

    public boolean hasChanged() {
        if (this.oldContent == null) {
            return this.newContent != null;
        }
        return !this.oldContent.equals(this.newContent);
    }

    public int getLengthDelta() {
        int oldLen = this.oldContent != null ? this.oldContent.length() : 0;
        int newLen = this.newContent != null ? this.newContent.length() : 0;
        return newLen - oldLen;
    }

    public static enum ChangeSource {
        USER_INPUT,
        API,
        UNDO_REDO,
        PASTE,
        COLLABORATION,
        UNKNOWN;

    }
}

