/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.wontlost.ckeditor.AutosaveAction;
import com.wontlost.ckeditor.Config;
import com.wontlost.ckeditor.Constants;
import com.wontlost.ckeditor.HasConfig;
import com.wontlost.ckeditor.IsAction;
import com.wontlost.ckeditor.VaadinCKEditorAction;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import tools.jackson.databind.node.BaseJsonNode;

@Tag(value="vaadin-ckeditor")
@JsModule.Container(value={@JsModule(value="./vaadin-ckeditor-utils.min.js"), @JsModule(value="./vaadin-ckeditor.min.js"), @JsModule(value="./translations/af.js"), @JsModule(value="./translations/ar.js"), @JsModule(value="./translations/ast.js"), @JsModule(value="./translations/az.js"), @JsModule(value="./translations/bg.js"), @JsModule(value="./translations/bn.js"), @JsModule(value="./translations/bs.js"), @JsModule(value="./translations/ca.js"), @JsModule(value="./translations/cs.js"), @JsModule(value="./translations/da.js"), @JsModule(value="./translations/de.js"), @JsModule(value="./translations/de-ch.js"), @JsModule(value="./translations/el.js"), @JsModule(value="./translations/en-au.js"), @JsModule(value="./translations/en-gb.js"), @JsModule(value="./translations/eo.js"), @JsModule(value="./translations/es.js"), @JsModule(value="./translations/es-co.js"), @JsModule(value="./translations/et.js"), @JsModule(value="./translations/eu.js"), @JsModule(value="./translations/fa.js"), @JsModule(value="./translations/fi.js"), @JsModule(value="./translations/fr.js"), @JsModule(value="./translations/gl.js"), @JsModule(value="./translations/gu.js"), @JsModule(value="./translations/hi.js"), @JsModule(value="./translations/he.js"), @JsModule(value="./translations/hr.js"), @JsModule(value="./translations/hu.js"), @JsModule(value="./translations/id.js"), @JsModule(value="./translations/it.js"), @JsModule(value="./translations/ja.js"), @JsModule(value="./translations/jv.js"), @JsModule(value="./translations/km.js"), @JsModule(value="./translations/kn.js"), @JsModule(value="./translations/ko.js"), @JsModule(value="./translations/ku.js"), @JsModule(value="./translations/lt.js"), @JsModule(value="./translations/lv.js"), @JsModule(value="./translations/ms.js"), @JsModule(value="./translations/nb.js"), @JsModule(value="./translations/ne.js"), @JsModule(value="./translations/nl.js"), @JsModule(value="./translations/no.js"), @JsModule(value="./translations/oc.js"), @JsModule(value="./translations/pl.js"), @JsModule(value="./translations/pt.js"), @JsModule(value="./translations/pt-br.js"), @JsModule(value="./translations/ro.js"), @JsModule(value="./translations/ru.js"), @JsModule(value="./translations/si.js"), @JsModule(value="./translations/sk.js"), @JsModule(value="./translations/sl.js"), @JsModule(value="./translations/sq.js"), @JsModule(value="./translations/sr.js"), @JsModule(value="./translations/sr-latn.js"), @JsModule(value="./translations/sv.js"), @JsModule(value="./translations/th.js"), @JsModule(value="./translations/tk.js"), @JsModule(value="./translations/tr.js"), @JsModule(value="./translations/tt.js"), @JsModule(value="./translations/ug.js"), @JsModule(value="./translations/uz.js"), @JsModule(value="./translations/uk.js"), @JsModule(value="./translations/ur.js"), @JsModule(value="./translations/vi.js"), @JsModule(value="./translations/zh.js"), @JsModule(value="./translations/zh-cn.js")})
@CssImport.Container(value={@CssImport(value="./styles.css"), @CssImport(value="./ckeditor.css")})
@NpmPackage(value="lit", version="^3.2.1")
public class VaadinCKEditor
extends CustomField<String>
implements HasConfig {
    private String editorData;
    private static final Logger vaddinCKEditorLog = Logger.getLogger(VaadinCKEditor.class.getName());

    VaadinCKEditor(String editorData) {
        this.editorData = editorData;
        this.getElement().setProperty("editorData", editorData);
    }

    protected String generateModelValue() {
        return this.editorData;
    }

    protected void setPresentationValue(String newPresentationValue) {
        this.editorData = newPresentationValue;
    }

    public void setId(String id) {
        this.getElement().setProperty("editorId", (String)(id == null ? "editor_" + String.valueOf(UUID.randomUUID()) : id));
    }

    public Optional<String> getId() {
        return Optional.of(this.getElement().getProperty("editorId"));
    }

    public String getValue() {
        return this.editorData;
    }

    public void setValue(String value) {
        super.setValue((Object)value);
        this.editorData = value;
        this.getElement().setProperty("editorData", value);
        this.updateValue(value);
    }

    protected void setModelValue(String value, boolean fromClient) {
        super.setModelValue((Object)value, fromClient);
        String oldEditorData = this.editorData;
        this.editorData = value;
        this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, (Object)oldEditorData, fromClient));
    }

    @ClientCallable
    private void setEditorData(String editorData) {
        this.setModelValue(editorData, true);
    }

    @ClientCallable
    private void saveEditorData(String editorData) {
        IsAction autosaveAction = VaadinCKEditorAction.getActionRegister().get("autosave");
        Optional<Consumer<String>> save = Optional.empty();
        if (autosaveAction instanceof AutosaveAction) {
            save = Optional.of((AutosaveAction)autosaveAction);
        }
        save.orElse(data -> vaddinCKEditorLog.log(Level.SEVERE, "Invalid action provided. You need to imply your own actions of saving editor data.")).accept(editorData);
    }

    private void updateValue(String content) {
        this.getId().ifPresent(id -> this.getElement().executeJs("this.updateData($0, $1)", new Object[]{id, content == null ? "" : content}));
    }

    void setEditorType(Constants.EditorType editorType) {
        this.getElement().setProperty("editorType", editorType.toString());
    }

    public void minimap(Boolean enabled) {
        this.getElement().setProperty("miniMapEnabled", enabled.booleanValue());
    }

    public void setWidth(String editorWidth) {
        super.setWidth(editorWidth);
        this.getElement().setProperty("editorWidth", editorWidth == null ? "auto" : editorWidth);
    }

    public void setHeight(String editorHeight) {
        super.setHeight(editorHeight);
        this.getElement().setProperty("editorHeight", editorHeight == null ? "auto" : editorHeight);
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setProperty("isReadOnly", readOnly);
        this.getId().ifPresent(id -> this.getElement().executeJs("this.fire($0, $1, $2, $3)", new Object[]{id, "change:isReadOnly", "isReadOnly", readOnly}));
    }

    public void enableGHS(boolean enabled) {
        this.getElement().setProperty("ghsEnabled", enabled);
    }

    public void isSynchronizd(boolean sync) {
        this.getElement().setProperty("sync", sync);
    }

    public void setReadOnlyWithToolbarAction(boolean readOnly) {
        this.setReadOnly(readOnly);
        this.setHideToolbar(readOnly);
    }

    public void setHideToolbar(boolean hideToolbar) {
        this.getElement().setProperty("hideToolbar", hideToolbar);
    }

    public boolean isReadOnly() {
        return this.getElement().getProperty("isReadOnly", false);
    }

    void setEditorTheme(Constants.ThemeType theme) {
        this.getElement().setProperty("themeType", theme == null ? Constants.ThemeType.LIGHT.toString() : theme.toString());
    }

    void setEditorMargin(String margin) {
        this.getElement().getStyle().set("margin", margin == null ? "20px" : margin);
    }

    void setAutosave(boolean autosave, int waitingTime) {
        this.getElement().setProperty("autosave", autosave);
        this.getElement().setProperty("waitingTime", (double)waitingTime);
    }

    public void clear() {
        this.updateValue(null);
    }

    @Override
    public void setConfig(Config config) {
        this.getElement().setPropertyJson("config", (BaseJsonNode)(config == null ? new Config().getConfigJson() : config.getConfigJson()));
    }

    public String sanitizeHtml(String editorData, Constants.SanitizeType type) {
        return Jsoup.clean((String)editorData, (Safelist)type.getValue());
    }

    public void insertText(String text) {
        this.getId().ifPresent(id -> this.getElement().executeJs("this.insertText($0, $1)", new Object[]{id, text}));
    }

    public String getContentText() {
        return Jsoup.parse((String)this.editorData).text();
    }

    public void setOverrideCssUrl(String overrideCssUrl) {
        Optional.ofNullable(overrideCssUrl).ifPresent(url -> this.getElement().setProperty("overrideCssUrl", url));
    }
}

