/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import com.wontlost.ckeditor.Constants;
import com.wontlost.ckeditor.mention.MentionConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class Config {
    static final JsonMapper mapper = JsonMapper.builder().build();
    static final String options = "options";
    static final String uploadUrl = "uploadUrl";
    static final String allow = "allow";
    static final String disallow = "disallow";
    static final String[] HEADING_OPTION = new String[]{"model", "view", "title", "class"};
    static final String[] CODEBLOCK_LANGUAGE = new String[]{"language", "label", "class"};
    static final String[] IMAGE_RESIZEOPTION = new String[]{"name", "value", "label"};
    static final Constants.Toolbar[] TOOLBAR = new Constants.Toolbar[]{Constants.Toolbar.textPartLanguage, Constants.Toolbar.pipe, Constants.Toolbar.heading, Constants.Toolbar.fontSize, Constants.Toolbar.fontFamily, Constants.Toolbar.fontColor, Constants.Toolbar.fontBackgroundColor, Constants.Toolbar.pipe, Constants.Toolbar.bold, Constants.Toolbar.italic, Constants.Toolbar.underline, Constants.Toolbar.findAndReplace, Constants.Toolbar.selectAll, Constants.Toolbar.strikethrough, Constants.Toolbar.subscript, Constants.Toolbar.superscript, Constants.Toolbar.highlight, Constants.Toolbar.removeFormat, Constants.Toolbar.pipe, Constants.Toolbar.horizontalLine, Constants.Toolbar.pageBreak, Constants.Toolbar.link, Constants.Toolbar.bulletedList, Constants.Toolbar.numberedList, Constants.Toolbar.alignment, Constants.Toolbar.todoList, Constants.Toolbar.indent, Constants.Toolbar.outdent, Constants.Toolbar.lineHeight, Constants.Toolbar.showBlocks, Constants.Toolbar.code, Constants.Toolbar.sourceEditing, Constants.Toolbar.codeBlock, Constants.Toolbar.pipe, Constants.Toolbar.specialCharacters, Constants.Toolbar.exportPdf, Constants.Toolbar.exportWord, Constants.Toolbar.imageUpload, Constants.Toolbar.blockQuote, Constants.Toolbar.insertTable, Constants.Toolbar.mediaEmbed, Constants.Toolbar.htmlEmbed, Constants.Toolbar.pipe, Constants.Toolbar.undo, Constants.Toolbar.redo};
    List<String> removedPlugins = new ArrayList<String>();
    List<String> extraPlugins = new ArrayList<String>();
    Map<Constants.ConfigType, JsonNode> configs = new HashMap<Constants.ConfigType, JsonNode>();

    private void initPlugins() {
        this.removedPlugins.add(Constants.Plugins.WProofreader.name());
        this.removedPlugins.add(Constants.Plugins.StandardEditingMode.name());
        this.removedPlugins.add(Constants.Plugins.RestrictedEditingMode.name());
        this.removedPlugins.add(Constants.Plugins.Markdown.name());
        this.removedPlugins.add(Constants.Plugins.Pagination.name());
        this.removedPlugins.add(Constants.Plugins.Minimap.name());
        this.configs.put(Constants.ConfigType.removePlugins, (JsonNode)this.toArrayNode(this.removedPlugins));
        this.configs.put(Constants.ConfigType.toolbar, (JsonNode)this.toArrayNode(TOOLBAR));
    }

    public void addExtraPlugin(Constants.Plugins plugin) {
        if (!this.extraPlugins.contains(plugin.name())) {
            this.extraPlugins.add(plugin.name());
        }
        this.configs.put(Constants.ConfigType.extraPlugins, (JsonNode)this.toArrayNode(this.extraPlugins));
    }

    public Config() {
        this.initPlugins();
        this.configs.put(Constants.ConfigType.alignment, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.autosave, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.balloonToolbar, (JsonNode)mapper.createArrayNode());
        this.configs.put(Constants.ConfigType.blockToolbar, (JsonNode)mapper.createArrayNode());
        this.configs.put(Constants.ConfigType.ckfinder, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.cloudServices, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.codeBlock, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.exportPdf, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.exportWord, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.extraPlugins, (JsonNode)mapper.createArrayNode());
        this.configs.put(Constants.ConfigType.fontBackgroundColor, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.fontColor, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.fontFamily, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.fontSize, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.heading, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.highlight, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.image, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.lineHeight, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.indentBlock, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.initialData, (JsonNode)mapper.getNodeFactory().stringNode(""));
        this.configs.put(Constants.ConfigType.language, (JsonNode)mapper.getNodeFactory().stringNode("en"));
        this.configs.put(Constants.ConfigType.link, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.mediaEmbed, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.mention, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.placeholder, (JsonNode)mapper.getNodeFactory().stringNode(""));
        this.configs.put(Constants.ConfigType.restrictedEditing, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.simpleUpload, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.table, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.title, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.typing, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.ui, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.wordCount, (JsonNode)mapper.createObjectNode());
        this.configs.put(Constants.ConfigType.wproofreader, (JsonNode)mapper.createObjectNode());
    }

    Config(ObjectNode jsonObject) {
        this.initPlugins();
        this.configs.put(Constants.ConfigType.alignment, jsonObject.get(Constants.ConfigType.alignment.name()));
        this.configs.put(Constants.ConfigType.autosave, jsonObject.get(Constants.ConfigType.autosave.name()));
        this.configs.put(Constants.ConfigType.balloonToolbar, jsonObject.get(Constants.ConfigType.balloonToolbar.name()));
        this.configs.put(Constants.ConfigType.blockToolbar, jsonObject.get(Constants.ConfigType.blockToolbar.name()));
        this.configs.put(Constants.ConfigType.ckfinder, jsonObject.get(Constants.ConfigType.ckfinder.name()));
        this.configs.put(Constants.ConfigType.cloudServices, jsonObject.get(Constants.ConfigType.cloudServices.name()));
        this.configs.put(Constants.ConfigType.codeBlock, jsonObject.get(Constants.ConfigType.codeBlock.name()));
        this.configs.put(Constants.ConfigType.exportPdf, jsonObject.get(Constants.ConfigType.exportPdf.name()));
        this.configs.put(Constants.ConfigType.exportWord, jsonObject.get(Constants.ConfigType.exportWord.name()));
        this.configs.put(Constants.ConfigType.extraPlugins, jsonObject.get(Constants.ConfigType.extraPlugins.name()));
        this.configs.put(Constants.ConfigType.fontBackgroundColor, jsonObject.get(Constants.ConfigType.fontBackgroundColor.name()));
        this.configs.put(Constants.ConfigType.fontColor, jsonObject.get(Constants.ConfigType.fontColor.name()));
        this.configs.put(Constants.ConfigType.fontFamily, jsonObject.get(Constants.ConfigType.fontFamily.name()));
        this.configs.put(Constants.ConfigType.fontSize, jsonObject.get(Constants.ConfigType.fontSize.name()));
        this.configs.put(Constants.ConfigType.heading, jsonObject.get(Constants.ConfigType.heading.name()));
        this.configs.put(Constants.ConfigType.highlight, jsonObject.get(Constants.ConfigType.highlight.name()));
        this.configs.put(Constants.ConfigType.lineHeight, jsonObject.get(Constants.ConfigType.lineHeight.name()));
        this.configs.put(Constants.ConfigType.image, jsonObject.get(Constants.ConfigType.image.name()));
        this.configs.put(Constants.ConfigType.indentBlock, jsonObject.get(Constants.ConfigType.indentBlock.name()));
        this.configs.put(Constants.ConfigType.initialData, jsonObject.get(Constants.ConfigType.initialData.name()));
        this.configs.put(Constants.ConfigType.language, jsonObject.get(Constants.ConfigType.language.name()));
        this.configs.put(Constants.ConfigType.link, jsonObject.get(Constants.ConfigType.link.name()));
        this.configs.put(Constants.ConfigType.mediaEmbed, jsonObject.get(Constants.ConfigType.mediaEmbed.name()));
        this.configs.put(Constants.ConfigType.mention, jsonObject.get(Constants.ConfigType.mention.name()));
        this.configs.put(Constants.ConfigType.placeholder, jsonObject.get(Constants.ConfigType.placeholder.name()));
        this.configs.put(Constants.ConfigType.removePlugins, (JsonNode)(jsonObject.get(Constants.ConfigType.removePlugins.name()) == null ? this.toArrayNode(this.removedPlugins) : jsonObject.get(Constants.ConfigType.removePlugins.name())));
        this.configs.put(Constants.ConfigType.restrictedEditing, jsonObject.get(Constants.ConfigType.restrictedEditing.name()));
        this.configs.put(Constants.ConfigType.simpleUpload, jsonObject.get(Constants.ConfigType.simpleUpload.name()));
        this.configs.put(Constants.ConfigType.table, jsonObject.get(Constants.ConfigType.table.name()));
        this.configs.put(Constants.ConfigType.title, jsonObject.get(Constants.ConfigType.title.name()));
        this.configs.put(Constants.ConfigType.typing, jsonObject.get(Constants.ConfigType.typing.name()));
        this.configs.put(Constants.ConfigType.wordCount, jsonObject.get(Constants.ConfigType.wordCount.name()));
        this.configs.put(Constants.ConfigType.ui, jsonObject.get(Constants.ConfigType.ui.name()));
        this.configs.put(Constants.ConfigType.wproofreader, jsonObject.get(Constants.ConfigType.wproofreader.name()));
    }

    ObjectNode getConfigJson() {
        ObjectNode configResult = mapper.createObjectNode();
        this.configs.forEach((configType, configJson) -> configResult.set(configType.name(), configJson));
        return configResult;
    }

    public Map<Constants.ConfigType, JsonNode> getConfigs() {
        return this.configs;
    }

    ArrayNode toArrayNode(Constants.Toolbar ... toolbar) {
        ArrayList values = new ArrayList();
        if (toolbar == null || toolbar.length == 0) {
            toolbar = TOOLBAR;
        }
        Arrays.stream(toolbar).forEach(item -> values.add(item.getValue()));
        return (ArrayNode)mapper.valueToTree(values);
    }

    ArrayNode toArrayNode(Constants.TextPartLanguage ... textPartLanguages) {
        ArrayList values = new ArrayList();
        Arrays.stream(textPartLanguages).forEach(item -> values.add(item.toString()));
        return (ArrayNode)mapper.valueToTree(values);
    }

    ObjectNode toJsonObjectArray(String member, String[] names, String[][] values) {
        ArrayList list = new ArrayList();
        for (String[] object : values) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < names.length && i < object.length; ++i) {
                if (object[i] == null) continue;
                map.put(names[i], object[i]);
            }
            list.add(map);
        }
        JsonNode json = mapper.valueToTree(list);
        String jsonObject = "{'" + member + "':" + String.valueOf(json) + "}";
        return (ObjectNode)mapper.valueToTree((Object)jsonObject);
    }

    ArrayNode toJsonObjectArray(String[] names, String[][] values) {
        String member = "temp";
        ObjectNode json = this.toJsonObjectArray(member, names, values);
        return (ArrayNode)json.get(member);
    }

    ArrayNode toArrayNode(List<?> options) {
        return (ArrayNode)mapper.valueToTree(options);
    }

    ArrayNode toArrayNode(String[][] options) {
        return (ArrayNode)mapper.valueToTree((Object)options);
    }

    ArrayNode toArrayNode(String ... list) {
        List<String> values = Arrays.asList(list == null ? new String[]{} : list);
        return (ArrayNode)mapper.valueToTree(values);
    }

    ArrayNode mapToArrayNode(List<Map<String, Object>> mapList) {
        return (ArrayNode)mapper.valueToTree(mapList);
    }

    public void setPlaceHolder(String placeHolder) {
        this.configs.put(Constants.ConfigType.placeholder, (JsonNode)mapper.getNodeFactory().stringNode(Optional.ofNullable(placeHolder).orElse("Type the content here!")));
    }

    public void setEditorToolBar(Constants.Toolbar[] editorToolBar) {
        this.configs.put(Constants.ConfigType.toolbar, (JsonNode)this.toArrayNode(editorToolBar));
    }

    public void setEditorToolBarObject(Constants.Toolbar[] editorToolBar, Boolean shouldNotGroupWhenFull) {
        ObjectNode toolbar = mapper.createObjectNode();
        toolbar.set("items", (JsonNode)this.toArrayNode(editorToolBar));
        toolbar.put("shouldNotGroupWhenFull", shouldNotGroupWhenFull);
        this.configs.put(Constants.ConfigType.toolbar, (JsonNode)toolbar);
    }

    public void setUILanguage(Constants.Language uiLanguage) {
        this.configs.put(Constants.ConfigType.language, (JsonNode)mapper.getNodeFactory().stringNode(uiLanguage == null ? "en" : uiLanguage.getLanguage()));
    }

    public void setLanguage(Constants.Language uiLanguage, Constants.Language contentLanguage, Constants.TextPartLanguage[] textPartLanguages) {
        ObjectNode language = mapper.createObjectNode();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (int i = 0; i < textPartLanguages.length; ++i) {
            ObjectNode langCode = mapper.createObjectNode();
            langCode.put("title", textPartLanguages[i].getTitle());
            langCode.put("languageCode", textPartLanguages[i].getLanguage());
            arrayNode.set(i, (JsonNode)langCode);
        }
        language.put("ui", uiLanguage.getLanguage());
        language.put("content", contentLanguage.getLanguage());
        language.set("textPartLanguage", (JsonNode)arrayNode);
        this.configs.put(Constants.ConfigType.language, (JsonNode)language);
    }

    public void setAlignment(String[] options) {
        ObjectNode alignment = mapper.createObjectNode();
        alignment.set(options, (JsonNode)this.toArrayNode(options));
        this.configs.put(Constants.ConfigType.alignment, (JsonNode)alignment);
    }

    public void setBalloonToolBar(Constants.Toolbar[] balloonToolBar) {
        this.configs.put(Constants.ConfigType.balloonToolbar, (JsonNode)this.toArrayNode(balloonToolBar));
    }

    public void setBlockToolBar(Constants.Toolbar[] blockToolBar) {
        this.configs.put(Constants.ConfigType.blockToolbar, (JsonNode)this.toArrayNode(blockToolBar));
    }

    public void setCKFinder(String openerMethod, String uploadUrl, Map<String, String> options) {
        ObjectNode ckfinder = mapper.createObjectNode();
        ckfinder.set("openerMethod", (JsonNode)mapper.getNodeFactory().stringNode(openerMethod));
        ckfinder.set(uploadUrl, (JsonNode)mapper.getNodeFactory().stringNode(uploadUrl));
        ObjectNode ckfinderOptions = mapper.createObjectNode();
        ckfinderOptions.put("connectorInfo", options.get("connectorInfo"));
        ckfinderOptions.put("connectorPath", options.get("connectorPath"));
        ckfinderOptions.put("height", options.get("height"));
        ckfinderOptions.put("width", options.get("width"));
        ckfinder.set(options, (JsonNode)ckfinderOptions);
        this.configs.put(Constants.ConfigType.ckfinder, (JsonNode)ckfinder);
    }

    public void setCloudServices(String bundleVersion, String tokenUrl, String uploadUrl, String webSocketUrl) {
        ObjectNode cloudServices = mapper.createObjectNode();
        cloudServices.set("bundleVersion", (JsonNode)mapper.getNodeFactory().stringNode(bundleVersion));
        cloudServices.set("tokenUrl", (JsonNode)mapper.getNodeFactory().stringNode(tokenUrl));
        cloudServices.set(uploadUrl, (JsonNode)mapper.getNodeFactory().stringNode(uploadUrl));
        cloudServices.set("webSocketUrl", (JsonNode)mapper.getNodeFactory().stringNode(webSocketUrl));
        this.configs.put(Constants.ConfigType.cloudServices, (JsonNode)cloudServices);
    }

    public void setUiViewportOffset(Double ... viewportOffsets) {
        ObjectNode ui = mapper.createObjectNode();
        ObjectNode viewportOffset = mapper.createObjectNode();
        if (viewportOffsets.length > 0 && viewportOffsets[0] != null) {
            viewportOffset.put("top", viewportOffsets[0]);
        }
        if (viewportOffsets.length > 1 && viewportOffsets[1] != null) {
            viewportOffset.put("right", viewportOffsets[1]);
        }
        if (viewportOffsets.length > 2 && viewportOffsets[2] != null) {
            viewportOffset.put("bottom", viewportOffsets[2]);
        }
        if (viewportOffsets.length > 3 && viewportOffsets[3] != null) {
            viewportOffset.put("left", viewportOffsets[3]);
        }
        ui.set("viewportOffset", (JsonNode)viewportOffset);
        this.configs.put(Constants.ConfigType.ui, (JsonNode)ui);
    }

    public void setCodeBlock(String indentSequence, String[][] languages) {
        ObjectNode codeBlock = mapper.createObjectNode();
        if (indentSequence != null) {
            codeBlock.set("indentSequence", (JsonNode)mapper.getNodeFactory().stringNode(indentSequence));
        }
        if (languages != null && languages.length > 0) {
            codeBlock.set("languages", (JsonNode)this.toJsonObjectArray(CODEBLOCK_LANGUAGE, languages));
        }
        this.configs.put(Constants.ConfigType.codeBlock, (JsonNode)codeBlock);
    }

    public void setExportPdf(String fileName, String converterUrl) {
        ObjectNode exportPdf = mapper.createObjectNode();
        exportPdf.set("fileName", (JsonNode)mapper.getNodeFactory().stringNode(fileName));
        exportPdf.set("converterUrl", (JsonNode)mapper.getNodeFactory().stringNode(converterUrl));
        this.configs.put(Constants.ConfigType.exportPdf, (JsonNode)exportPdf);
    }

    public void setExportWord(String fileName, String converterUrl) {
        ObjectNode exportWord = mapper.createObjectNode();
        exportWord.set("fileName", (JsonNode)mapper.getNodeFactory().stringNode(fileName));
        exportWord.set("converterUrl", (JsonNode)mapper.getNodeFactory().stringNode(converterUrl));
        this.configs.put(Constants.ConfigType.exportWord, (JsonNode)exportWord);
    }

    public void setFontBackgroundColor(int columns, int documentColors, Map<String, String> colors) {
        ObjectNode fontBackgroundColor = mapper.createObjectNode();
        fontBackgroundColor.set("columns", (JsonNode)mapper.getNodeFactory().numberNode(columns));
        fontBackgroundColor.set("documentColors", (JsonNode)mapper.getNodeFactory().numberNode(documentColors));
        fontBackgroundColor.set("colors", (JsonNode)mapper.createArrayNode());
        this.configs.put(Constants.ConfigType.fontBackgroundColor, (JsonNode)fontBackgroundColor);
    }

    public void setFontColor(int columns, int documentColors, Map<String, String> colors) {
        ObjectNode fontBackgroundColor = mapper.createObjectNode();
        fontBackgroundColor.set("columns", (JsonNode)mapper.getNodeFactory().numberNode(columns));
        fontBackgroundColor.set("documentColors", (JsonNode)mapper.getNodeFactory().numberNode(documentColors));
        fontBackgroundColor.set("colors", (JsonNode)mapper.createArrayNode());
        this.configs.put(Constants.ConfigType.fontColor, (JsonNode)fontBackgroundColor);
    }

    public void setFontFamily(boolean supportAllValues, String[] options) {
        ObjectNode fontFamily = mapper.createObjectNode();
        fontFamily.set("supportAllValues", (JsonNode)mapper.getNodeFactory().booleanNode(supportAllValues));
        fontFamily.set(options, (JsonNode)this.toArrayNode(options));
        this.configs.put(Constants.ConfigType.fontFamily, (JsonNode)fontFamily);
    }

    public void setFontSize(boolean supportAllValues, String[] options) {
        ObjectNode fontSize = mapper.createObjectNode();
        fontSize.set("supportAllValues", (JsonNode)mapper.getNodeFactory().booleanNode(supportAllValues));
        fontSize.set(options, (JsonNode)this.toArrayNode(options));
        this.configs.put(Constants.ConfigType.fontSize, (JsonNode)fontSize);
    }

    public void setHeading(String[][] options) {
        ObjectNode heading = mapper.createObjectNode();
        if (options != null && options.length > 0) {
            heading.set(options, (JsonNode)this.toJsonObjectArray(HEADING_OPTION, options));
        }
        this.configs.put(Constants.ConfigType.heading, (JsonNode)heading);
    }

    public void setHighlight(String[][] options) {
        ObjectNode highlight = mapper.createObjectNode();
        highlight.set(options, (JsonNode)this.toArrayNode(options));
        this.configs.put(Constants.ConfigType.highlight, (JsonNode)highlight);
    }

    public void setImage(String[][] resizeOptions, String resizeUnit, String[] styles, String[] toolbar, String[] uploadTypes) {
        ObjectNode image = mapper.createObjectNode();
        if (resizeOptions != null && resizeOptions.length > 0) {
            image.set(options, (JsonNode)this.toJsonObjectArray(IMAGE_RESIZEOPTION, resizeOptions));
        }
        if (resizeUnit != null) {
            image.set("resizeUnit", (JsonNode)mapper.getNodeFactory().stringNode(resizeUnit));
        }
        if (styles.length > 0) {
            image.set("styles", (JsonNode)this.toArrayNode(styles));
        }
        if (toolbar.length > 0) {
            image.set("toolbar", (JsonNode)this.toArrayNode(toolbar));
        }
        if (uploadTypes.length > 0) {
            ObjectNode upload = mapper.createObjectNode();
            upload.set("types", (JsonNode)this.toArrayNode(uploadTypes));
            image.set("upload", (JsonNode)upload);
        }
        this.configs.put(Constants.ConfigType.image, (JsonNode)image);
    }

    public void setIndentBlock(int offset, String unit) {
        ObjectNode indentBlock = mapper.createObjectNode();
        indentBlock.set("offset", (JsonNode)mapper.getNodeFactory().numberNode(offset));
        indentBlock.set("unit", (JsonNode)mapper.getNodeFactory().stringNode(unit));
        this.configs.put(Constants.ConfigType.indentBlock, (JsonNode)indentBlock);
    }

    public void setInitialData(String initialData) {
        this.configs.put(Constants.ConfigType.initialData, (JsonNode)mapper.getNodeFactory().stringNode(initialData));
    }

    public void setLink(String defaultProtocol, Boolean addTargetToExternalLinks) {
        ObjectNode link = mapper.createObjectNode();
        link.set("defaultProtocol", (JsonNode)mapper.getNodeFactory().stringNode(defaultProtocol));
        link.set("addTargetToExternalLinks", (JsonNode)mapper.getNodeFactory().booleanNode(addTargetToExternalLinks.booleanValue()));
        this.configs.put(Constants.ConfigType.link, (JsonNode)link);
    }

    public void setMediaEmbed(Boolean previewsInData, List<String> providers, List<String> extraProviders, List<String> removeProviders, List<String> toolbar) {
        ObjectNode mediaEmbed = mapper.createObjectNode();
        mediaEmbed.set("previewsInData", (JsonNode)mapper.getNodeFactory().booleanNode(previewsInData.booleanValue()));
        mediaEmbed.set("providers", (JsonNode)this.toArrayNode(providers));
        mediaEmbed.set("extraProviders", (JsonNode)this.toArrayNode(extraProviders));
        mediaEmbed.set("removeProviders", (JsonNode)this.toArrayNode(removeProviders));
        mediaEmbed.set("toolbar", (JsonNode)this.toArrayNode(toolbar));
        this.configs.put(Constants.ConfigType.mediaEmbed, (JsonNode)mediaEmbed);
    }

    public void setMention(MentionConfig mentionConfig) {
        JsonNode mentionNode = mapper.valueToTree((Object)mentionConfig);
        this.configs.put(Constants.ConfigType.mention, mentionNode);
    }

    public void setRemovePlugins(List<Constants.Plugins> plugins) {
        ArrayList toBeRemoved = new ArrayList();
        plugins.forEach(plugin -> toBeRemoved.add(plugin.name()));
        this.configs.put(Constants.ConfigType.removePlugins, (JsonNode)this.toArrayNode(toBeRemoved));
    }

    public void setRestrictedEditing(List<String> allowedAttributes, List<String> allowedCommands) {
        ObjectNode restrictedEditing = mapper.createObjectNode();
        restrictedEditing.set("allowedAttributes", (JsonNode)this.toArrayNode(allowedAttributes));
        restrictedEditing.set("allowedCommands", (JsonNode)this.toArrayNode(allowedCommands));
        this.configs.put(Constants.ConfigType.restrictedEditing, (JsonNode)restrictedEditing);
    }

    public void setSimpleUpload(String uploadUrl, Boolean withCredentials, List<String> headers) {
        ObjectNode simpleUpload = mapper.createObjectNode();
        simpleUpload.set(uploadUrl, (JsonNode)mapper.getNodeFactory().stringNode(uploadUrl));
        simpleUpload.set("withCredentials", (JsonNode)mapper.getNodeFactory().booleanNode(withCredentials.booleanValue()));
        simpleUpload.set("headers", (JsonNode)this.toArrayNode(headers));
        this.configs.put(Constants.ConfigType.simpleUpload, (JsonNode)simpleUpload);
    }

    public void setTable(List<String> contentToolbar, List<String> tableToolbar, ObjectNode tableCellProperties, ObjectNode tableProperties) {
        ObjectNode table = mapper.createObjectNode();
        table.set("contentToolbar", (JsonNode)this.toArrayNode(contentToolbar));
        table.set("tableToolbar", (JsonNode)this.toArrayNode(tableToolbar));
        table.set("tableCellProperties", (JsonNode)tableCellProperties);
        table.set("tableProperties", (JsonNode)tableCellProperties);
        this.configs.put(Constants.ConfigType.table, (JsonNode)table);
    }

    public void setLineHeight(List<Integer> options) {
        ObjectNode lineHeight = mapper.createObjectNode();
        lineHeight.set(options, (JsonNode)this.toArrayNode(options));
        this.configs.put(Constants.ConfigType.lineHeight, (JsonNode)lineHeight);
    }

    public void setTitle(String placeholder) {
        ObjectNode title = mapper.createObjectNode();
        title.set("placeholder", (JsonNode)mapper.getNodeFactory().stringNode(placeholder));
        this.configs.put(Constants.ConfigType.title, (JsonNode)title);
    }

    public void setTyping(int undo, ObjectNode transformations) {
        ObjectNode typing = mapper.createObjectNode();
        typing.set("undo", (JsonNode)mapper.getNodeFactory().numberNode(undo));
        typing.set("transformations", (JsonNode)transformations);
        this.configs.put(Constants.ConfigType.typing, (JsonNode)typing);
    }

    public void setWproofReaderCloud(String serviceId, String srcUrl) {
        ObjectNode wproofReaderCloud = mapper.createObjectNode();
        String defaultSrcUrl = "https://svc.webspellchecker.net/spellcheck31/wscbundle/wscbundle.js";
        wproofReaderCloud.set("serviceId", (JsonNode)mapper.getNodeFactory().stringNode(serviceId));
        wproofReaderCloud.set("srcUrl", (JsonNode)mapper.getNodeFactory().stringNode(Optional.ofNullable(srcUrl).orElse(defaultSrcUrl)));
        this.configs.put(Constants.ConfigType.wproofreader, (JsonNode)wproofReaderCloud);
        this.setPluginStatus(Constants.Plugins.WProofreader, true);
    }

    public void setWproofReaderServer(String serviceProtocol, String serviceHost, Integer servicePort, String servicePath, String srcUrl) {
        ObjectNode wproofReaderServer = mapper.createObjectNode();
        wproofReaderServer.set("serviceProtocol", (JsonNode)mapper.getNodeFactory().stringNode(Optional.ofNullable(serviceProtocol).orElse("https")));
        wproofReaderServer.set("serviceHost", (JsonNode)mapper.getNodeFactory().stringNode(Optional.ofNullable(serviceHost).orElse("localhost")));
        wproofReaderServer.set("servicePort", (JsonNode)mapper.getNodeFactory().numberNode(Optional.ofNullable(servicePort).orElse(8080)));
        wproofReaderServer.set("servicePath", (JsonNode)mapper.getNodeFactory().stringNode(Optional.ofNullable(servicePath).orElse("/")));
        wproofReaderServer.set("srcUrl", (JsonNode)mapper.getNodeFactory().stringNode(Optional.ofNullable(srcUrl).orElse("/wscbundle/wscbundle.js")));
        this.configs.put(Constants.ConfigType.wproofreader, (JsonNode)wproofReaderServer);
        this.setPluginStatus(Constants.Plugins.WProofreader, true);
    }

    public void setPluginStatus(Constants.Plugins plugin, boolean active) {
        ArrayNode removePluginArray = (ArrayNode)this.configs.get((Object)Constants.ConfigType.removePlugins);
        this.updateArrayNode(active, removePluginArray, plugin.name());
    }

    @Deprecated
    public void enableStandardMode() {
        this.setPluginStatus(Constants.Plugins.StandardEditingMode, true);
        this.setPluginStatus(Constants.Plugins.RestrictedEditingMode, false);
        this.updateToolbar();
    }

    public void enablePagination() {
        this.setPluginStatus(Constants.Plugins.Pagination, true);
        this.updateToolbar();
    }

    public void enableMinimap() {
        this.setPluginStatus(Constants.Plugins.Minimap, true);
    }

    public void setEditingMode(Constants.EditingMode editingMode) {
        if (Constants.EditingMode.Restricted.equals((Object)editingMode)) {
            this.setPluginStatus(Constants.Plugins.StandardEditingMode, false);
            this.setPluginStatus(Constants.Plugins.RestrictedEditingMode, true);
        } else {
            this.setPluginStatus(Constants.Plugins.StandardEditingMode, true);
            this.setPluginStatus(Constants.Plugins.RestrictedEditingMode, false);
        }
        this.updateToolbar();
    }

    @Deprecated
    public void enableRestrictedMode() {
        this.setPluginStatus(Constants.Plugins.StandardEditingMode, false);
        this.setPluginStatus(Constants.Plugins.RestrictedEditingMode, true);
        this.updateToolbar();
    }

    private void updateArrayNode(boolean active, ArrayNode arrayNode, String name) {
        int index = -1;
        for (int i = 0; i < arrayNode.size(); ++i) {
            if (!name.equals(arrayNode.get(i).asString())) continue;
            index = i;
        }
        if (index >= 0) {
            if (active) {
                arrayNode.remove(index);
            } else {
                arrayNode.set(index, name);
            }
        } else if (!active) {
            arrayNode.set(arrayNode.size(), name);
        }
    }

    private void updateToolbar() {
        ArrayNode removePluginArray = (ArrayNode)this.configs.get((Object)Constants.ConfigType.removePlugins);
        boolean paginationEnabled = true;
        if (removePluginArray != null) {
            for (int i = 0; i < removePluginArray.size(); ++i) {
                if (Constants.Plugins.RestrictedEditingMode.name().equals(removePluginArray.get(i).asString())) {
                    this.changeToolbarItem(Constants.Toolbar.restrictedEditing, true);
                    this.changeToolbarItem(Constants.Toolbar.restrictedEditingException, false);
                    continue;
                }
                if (Constants.Plugins.StandardEditingMode.name().equals(removePluginArray.get(i).asString())) {
                    this.changeToolbarItem(Constants.Toolbar.restrictedEditing, false);
                    this.changeToolbarItem(Constants.Toolbar.restrictedEditingException, true);
                    continue;
                }
                if (!Constants.Plugins.Pagination.name().equals(removePluginArray.get(i).asString())) continue;
                paginationEnabled = false;
            }
        }
        if (paginationEnabled) {
            this.changeToolbarItem(Constants.Toolbar.previousPage, false);
            this.changeToolbarItem(Constants.Toolbar.nextPage, false);
            this.changeToolbarItem(Constants.Toolbar.pageNavigation, false);
        }
    }

    private void changeToolbarItem(Constants.Toolbar toolbar, boolean remove) {
        ArrayNode toolbarArray = (ArrayNode)this.configs.get((Object)Constants.ConfigType.toolbar);
        this.updateArrayNode(remove, toolbarArray, toolbar.getValue());
    }

    public void setWordCount(String container, Boolean displayCharacters, Boolean displayWords, ObjectNode onUpdate) {
        ObjectNode wordCount = mapper.createObjectNode();
        wordCount.set("container", (JsonNode)mapper.getNodeFactory().stringNode(container));
        wordCount.set("displayCharacters", (JsonNode)mapper.getNodeFactory().booleanNode(displayCharacters.booleanValue()));
        wordCount.set("displayWords", (JsonNode)mapper.getNodeFactory().booleanNode(displayWords.booleanValue()));
        wordCount.set("onUpdate", (JsonNode)onUpdate);
        this.configs.put(Constants.ConfigType.wordCount, (JsonNode)wordCount);
    }

    public void setPagination(String pageWidth, String pageHeight, String top, String left, String bottom, String right) {
        ObjectNode pagination = mapper.createObjectNode();
        pagination.put("pageWidth", pageWidth);
        pagination.put("pageHeight", pageHeight);
        ObjectNode pageMargins = mapper.createObjectNode();
        pageMargins.put("top", top);
        pageMargins.put("bottom", bottom);
        pageMargins.put("right", right);
        pageMargins.put("left", left);
        pagination.set("pageMargins", (JsonNode)pageMargins);
        this.configs.put(Constants.ConfigType.pagination, (JsonNode)pagination);
    }

    public void setPaginationA4() {
        this.setPagination("21cm", "29.7cm", "20mm", "12mm", "20mm", "12mm");
    }

    public void setLicenseKey(String license) {
        if (license != null && !license.trim().isEmpty()) {
            this.configs.put(Constants.ConfigType.licenseKey, (JsonNode)mapper.getNodeFactory().stringNode(license));
        }
    }
}

