/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.screenshot;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;

public class ReferenceNameGenerator {
    public String generateName(String referenceId, Capabilities browserCapabilities) {
        Platform platform = browserCapabilities.getPlatformName();
        String platformString = platform != null ? platform.name().toLowerCase() : "unknown";
        return String.format("%s_%s_%s_%s", referenceId, platformString, browserCapabilities.getBrowserName(), ReferenceNameGenerator.getMajorVersion(browserCapabilities));
    }

    public static String getMajorVersion(Capabilities browserCapabilities) {
        Object browserVersion;
        String versionString = browserCapabilities.getBrowserVersion();
        if (versionString.equals("") && (browserVersion = browserCapabilities.getCapability("browserVersion")) != null) {
            versionString = browserVersion.toString();
        }
        if (versionString.contains(".")) {
            String major = versionString.substring(0, versionString.indexOf(46));
            if (major.contains("-")) {
                major = major.substring(major.indexOf("-") + 1);
            }
            return major;
        }
        return versionString;
    }
}

