/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.TestBenchBrowserFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariOptions;

public class DefaultBrowserFactory
implements TestBenchBrowserFactory {
    @Override
    public DesiredCapabilities create(Browser browser) {
        return this.create(browser, "", Platform.ANY);
    }

    @Override
    public DesiredCapabilities create(Browser browser, String version) {
        return this.create(browser, version, Platform.ANY);
    }

    @Override
    public DesiredCapabilities create(Browser browser, String version, Platform platform) {
        ChromeOptions desiredCapabilities;
        switch (browser) {
            case CHROME: {
                desiredCapabilities = new ChromeOptions();
                break;
            }
            case SAFARI: {
                desiredCapabilities = new SafariOptions();
                break;
            }
            case IE8: {
                desiredCapabilities = new InternetExplorerOptions();
                version = "8";
                break;
            }
            case IE9: {
                desiredCapabilities = new InternetExplorerOptions();
                version = "9";
                break;
            }
            case IE10: {
                desiredCapabilities = new InternetExplorerOptions();
                version = "10";
                break;
            }
            case IE11: {
                desiredCapabilities = new InternetExplorerOptions();
                desiredCapabilities.setCapability("ie.ensureCleanSession", true);
                break;
            }
            case EDGE: {
                desiredCapabilities = new EdgeOptions();
                break;
            }
            default: {
                desiredCapabilities = new FirefoxOptions();
            }
        }
        desiredCapabilities.setCapability("browserVersion", version);
        desiredCapabilities.setCapability("platformName", platform);
        return new DesiredCapabilities((Capabilities)desiredCapabilities);
    }
}

