/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.DefaultBrowserFactory;
import com.vaadin.testbench.parallel.TestBenchBrowserFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserUtil {
    private static TestBenchBrowserFactory browserFactory = new DefaultBrowserFactory();

    public static DesiredCapabilities safari() {
        DesiredCapabilities c = browserFactory.create(Browser.SAFARI);
        return c;
    }

    public static DesiredCapabilities chrome() {
        DesiredCapabilities c = browserFactory.create(Browser.CHROME);
        return c;
    }

    public static DesiredCapabilities firefox() {
        DesiredCapabilities c = browserFactory.create(Browser.FIREFOX);
        return c;
    }

    public static DesiredCapabilities ie8() {
        DesiredCapabilities c = browserFactory.create(Browser.IE8);
        return c;
    }

    public static DesiredCapabilities ie9() {
        DesiredCapabilities c = browserFactory.create(Browser.IE9);
        return c;
    }

    public static DesiredCapabilities ie10() {
        DesiredCapabilities c = browserFactory.create(Browser.IE10);
        return c;
    }

    public static DesiredCapabilities ie11() {
        DesiredCapabilities c = browserFactory.create(Browser.IE11);
        return c;
    }

    public static DesiredCapabilities edge() {
        DesiredCapabilities c = browserFactory.create(Browser.EDGE);
        return c;
    }

    public static boolean isIE8(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return BrowserUtil.isIE(capabilities, 8);
    }

    public static boolean isIE(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return org.openqa.selenium.remote.Browser.IE.browserName().equals(capabilities.getBrowserName());
    }

    public static boolean isIE(Capabilities capabilities, int version) {
        if (capabilities == null) {
            return false;
        }
        return BrowserUtil.isIE(capabilities) && ("" + version).equals(capabilities.getBrowserVersion());
    }

    public static boolean isEdge(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return org.openqa.selenium.remote.Browser.EDGE.browserName().equals(capabilities.getBrowserName());
    }

    public static boolean isChrome(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return capabilities.getBrowserName().startsWith(org.openqa.selenium.remote.Browser.CHROME.browserName());
    }

    public static boolean isSafari(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return org.openqa.selenium.remote.Browser.SAFARI.browserName().equals(capabilities.getBrowserName());
    }

    public static boolean isFirefox(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return org.openqa.selenium.remote.Browser.FIREFOX.browserName().equals(capabilities.getBrowserName());
    }

    public static String getBrowserIdentifier(Capabilities capabilities) {
        if (BrowserUtil.isIE(capabilities)) {
            return "InternetExplorer";
        }
        if (BrowserUtil.isFirefox(capabilities)) {
            return "Firefox";
        }
        if (BrowserUtil.isChrome(capabilities)) {
            return "Chrome";
        }
        if (BrowserUtil.isSafari(capabilities)) {
            return "Safari";
        }
        if (BrowserUtil.isEdge(capabilities)) {
            return "Edge";
        }
        if (capabilities == null) {
            return "Unknown";
        }
        return capabilities.getBrowserName();
    }

    public static String getPlatform(Capabilities capabilities) {
        if (capabilities == null) {
            return "Unknown";
        }
        try {
            Platform family;
            Platform p = capabilities.getPlatformName();
            Platform platform = family = p != null ? p.family() : null;
            if (family == Platform.WINDOWS || p == Platform.WINDOWS) {
                return "Windows";
            }
            if (family == Platform.MAC || p == Platform.MAC) {
                return "Mac";
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        Object rawPlatform = capabilities.getCapability("platformName");
        if (rawPlatform == null) {
            return "Unknown";
        }
        if (rawPlatform instanceof Platform) {
            return ((Platform)rawPlatform).name();
        }
        return rawPlatform.toString();
    }

    static void setBrowserFactory(TestBenchBrowserFactory browserFactory) {
        BrowserUtil.browserFactory = browserFactory;
    }

    public static TestBenchBrowserFactory getBrowserFactory() {
        return browserFactory;
    }
}

