/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.commands;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.ScreenshotComparator;
import com.vaadin.testbench.commands.TestBenchCommands;
import com.vaadin.testbench.screenshot.ImageComparison;
import com.vaadin.testbench.screenshot.ReferenceNameGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;

public class TestBenchCommandExecutor
implements TestBenchCommands,
JavascriptExecutor {
    private static Logger logger = Logger.getLogger(TestBenchCommandExecutor.class.getName());
    private final WebDriver actualDriver;
    private final ImageComparison imageComparison;
    private ReferenceNameGenerator referenceNameGenerator;
    private boolean enableWaitForVaadin = true;
    private boolean autoScrollIntoView = true;

    private static Logger getLogger() {
        return logger;
    }

    public TestBenchCommandExecutor(WebDriver actualDriver, ImageComparison imageComparison, ReferenceNameGenerator referenceNameGenerator) {
        this.actualDriver = actualDriver;
        this.imageComparison = imageComparison;
        this.referenceNameGenerator = referenceNameGenerator;
    }

    @Override
    public String getRemoteControlName() {
        InetAddress ia = null;
        try {
            if (this.actualDriver instanceof RemoteWebDriver) {
                RemoteWebDriver rwd = (RemoteWebDriver)this.actualDriver;
                if (rwd.getCommandExecutor() instanceof HttpCommandExecutor) {
                    ia = InetAddress.getByName(((HttpCommandExecutor)rwd.getCommandExecutor()).getAddressOfRemoteServer().getHost());
                }
            } else {
                ia = InetAddress.getLocalHost();
            }
        }
        catch (UnknownHostException e) {
            TestBenchCommandExecutor.getLogger().log(Level.WARNING, "Could not find name of remote control", e);
            return "unknown";
        }
        if (ia != null) {
            return String.format("%s (%s)", ia.getCanonicalHostName(), ia.getHostAddress());
        }
        return null;
    }

    @Override
    public void waitForVaadin() {
        if (!this.enableWaitForVaadin || !(this.actualDriver instanceof JavascriptExecutor)) {
            return;
        }
        String isVaadinFinished = "if (document.readyState != 'complete') {  return false;}if (window.vaadin == null) {  return true;}var clients = window.vaadin.clients;if (clients) {  for (var client in clients) {    if (clients[client].isActive()) {      return false;    }  }  return true;} else {  return false;}";
        JavascriptExecutor js = (JavascriptExecutor)this.actualDriver;
        long timeoutTime = System.currentTimeMillis() + 20000L;
        Boolean finished = false;
        while (System.currentTimeMillis() < timeoutTime && !finished.booleanValue()) {
            finished = (Boolean)js.executeScript(isVaadinFinished, new Object[0]);
            if (finished != null) continue;
            TestBenchCommandExecutor.getLogger().fine("waitForVaadin returned null, this should never happen");
            finished = false;
        }
    }

    @Override
    public boolean compareScreen(String referenceId) throws IOException {
        WebDriver driver = this.getDriver();
        return ScreenshotComparator.compareScreen(referenceId, this.referenceNameGenerator, this.imageComparison, (TakesScreenshot)driver, (HasCapabilities)driver);
    }

    @Override
    public boolean compareScreen(File reference) throws IOException {
        WebDriver driver = this.getWrappedDriver();
        return ScreenshotComparator.compareScreen(reference, this.imageComparison, (TakesScreenshot)driver, (HasCapabilities)driver);
    }

    @Override
    public boolean compareScreen(BufferedImage reference, String referenceName) throws IOException {
        WebDriver driver = this.getWrappedDriver();
        return ScreenshotComparator.compareScreen(reference, referenceName, this.imageComparison, (TakesScreenshot)driver, (HasCapabilities)driver);
    }

    @Override
    public long timeSpentRenderingLastRequest() {
        List<Long> timingValues = this.getTimingValues(false);
        if (timingValues == null) {
            return -1L;
        }
        return timingValues.get(0);
    }

    @Override
    public long totalTimeSpentRendering() {
        List<Long> timingValues = this.getTimingValues(false);
        if (timingValues == null) {
            return -1L;
        }
        return timingValues.get(1);
    }

    @Override
    public long timeSpentServicingLastRequest() {
        List<Long> timingValues = this.getTimingValues(true);
        if (timingValues == null) {
            return -1L;
        }
        return timingValues.get(3);
    }

    @Override
    public long totalTimeSpentServicingRequests() {
        List<Long> timingValues = this.getTimingValues(true);
        if (timingValues == null) {
            return -1L;
        }
        return timingValues.get(2);
    }

    private List<Long> getTimingValues(boolean forceSync) {
        String getProfilingData = "var pd = [0,0,0,0];\nfor (client in window.vaadin.clients) {\n  var p = window.vaadin.clients[client].getProfilingData();\n  pd[0] += p[0];\n  pd[1] += p[1];\n  pd[2] += p[2];\n  pd[3] += p[3];\n}\nreturn pd;\n";
        if (this.actualDriver instanceof JavascriptExecutor) {
            try {
                JavascriptExecutor jse = (JavascriptExecutor)this.actualDriver;
                if (forceSync) {
                    jse.executeScript("window.vaadin.forceSync()", new Object[0]);
                }
                return (List)jse.executeScript(getProfilingData, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void disableWaitForVaadin() {
        this.enableWaitForVaadin = false;
    }

    @Override
    public void enableWaitForVaadin() {
        this.enableWaitForVaadin = true;
    }

    @Override
    public boolean isAutoScrollIntoView() {
        return this.autoScrollIntoView;
    }

    @Override
    public void setAutoScrollIntoView(boolean autoScrollIntoView) {
        this.autoScrollIntoView = autoScrollIntoView;
    }

    public Object executeScript(String script, Object ... args) {
        if (this.actualDriver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.actualDriver).executeScript(script, args);
        }
        throw new RuntimeException("The driver is not a JavascriptExecutor");
    }

    public Object executeAsyncScript(String script, Object ... args) {
        if (this.actualDriver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.actualDriver).executeAsyncScript(script, args);
        }
        throw new RuntimeException("The driver is not a JavascriptExecutor");
    }

    public WebDriver getWrappedDriver() {
        return this.actualDriver;
    }

    public WebDriver getDriver() {
        return this.actualDriver;
    }

    @Override
    public void resizeViewPortTo(int desiredWidth, int desiredHeight) throws UnsupportedOperationException {
        try {
            this.actualDriver.manage().window().setPosition(new Point(0, 0));
            int extrah = 106;
            int extraw = 0;
            this.actualDriver.manage().window().setSize(new Dimension(desiredWidth + extraw, desiredHeight + extrah));
            int actualWidth = this.detectViewportWidth();
            int actualHeight = this.detectViewportHeight();
            int diffW = desiredWidth - actualWidth;
            int diffH = desiredHeight - actualHeight;
            if (diffH != 0 || diffW != 0) {
                this.actualDriver.manage().window().setSize(new Dimension(desiredWidth + extraw + diffW, desiredHeight + extrah + diffH));
            }
            actualWidth = this.detectViewportWidth();
            actualHeight = this.detectViewportHeight();
            if (desiredWidth != actualWidth || desiredHeight != actualHeight) {
                throw new Exception("Viewport size couldn't be set to desired.");
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Viewport couldn't be adjusted.", e);
        }
    }

    private int detectViewportHeight() {
        int height = ((Number)((JavascriptExecutor)this.actualDriver).executeScript("function f() { if(typeof window.innerHeight != 'undefined') { return window.innerHeight; } if(document.documentElement && document.documentElement.offsetHeight) { return document.documentElement.offsetHeight; } w = document.body.clientHeight; if(navigator.userAgent.indexOf('Trident/5') != -1 && document.documentMode < 9) { w += 4; } return w;} return f();", new Object[0])).intValue();
        return height;
    }

    private int detectViewportWidth() {
        int width = ((Number)((JavascriptExecutor)this.actualDriver).executeScript("function f() { if(typeof window.innerWidth != 'undefined') { return window.innerWidth; } if(document.documentElement && document.documentElement.offsetWidth) { return document.documentElement.offsetWidth; } w = document.body.clientWidth; if(navigator.userAgent.indexOf('Trident/5') != -1 && document.documentMode < 9) { w += 4; } return w;} return f();", new Object[0])).intValue();
        return width;
    }

    public void focusElement(TestBenchElement testBenchElement) {
        JavascriptExecutor jse = (JavascriptExecutor)this.actualDriver;
        Object ret = jse.executeScript("try { arguments[0].focus() } catch(e) {}; return null;", new Object[]{testBenchElement});
        assert (ret == null);
    }

    @Override
    public ReferenceNameGenerator getReferenceNameGenerator() {
        return this.referenceNameGenerator;
    }

    @Override
    public void setReferenceNameGenerator(ReferenceNameGenerator nameGenerator) {
        Objects.requireNonNull(nameGenerator, "ReferenceNameGenerator can not be null");
        this.referenceNameGenerator = nameGenerator;
    }

    public ImageComparison getImageComparison() {
        return this.imageComparison;
    }
}

