/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.testbench.AbstractHasTestBenchCommandExecutor;
import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.HasTestBenchCommandExecutor;
import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.RetryRule;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.commands.TestBenchCommands;
import com.vaadin.testbench.commands.TestBenchElementCommands;
import com.vaadin.testbench.elementsbase.AbstractElement;
import java.time.Duration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Rule;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class TestBenchTestCase
extends AbstractHasTestBenchCommandExecutor
implements HasDriver {
    @Rule
    public RetryRule maxAttempts = new RetryRule(Parameters.getMaxAttempts());
    protected WebDriver driver;

    public static TestBenchCommands testBench(WebDriver webDriver) {
        return (TestBenchCommands)webDriver;
    }

    public TestBenchCommands testBench() {
        return (TestBenchCommands)this.getDriver();
    }

    public TestBenchElementCommands testBenchElement(WebElement webElement) {
        return (TestBenchElementCommands)webElement;
    }

    protected String concatUrl(String baseUrl, String uri) {
        if (baseUrl.endsWith("/") && uri.startsWith("/")) {
            return baseUrl + uri.substring(1);
        }
        return baseUrl + uri;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        if (driver != null && !(driver instanceof TestBenchDriverProxy)) {
            driver = TestBench.createDriver(driver);
        }
        this.driver = driver;
    }

    @Override
    public SearchContext getContext() {
        return this.getDriver();
    }

    @Override
    public TestBenchCommandExecutor getCommandExecutor() {
        return ((HasTestBenchCommandExecutor)this.getDriver()).getCommandExecutor();
    }

    public WebElement findElement(By by) {
        return this.getContext().findElement(by);
    }

    public List<WebElement> findElements(By by) {
        return this.getContext().findElements(by);
    }

    public <T extends AbstractElement> T wrap(Class<T> elementType, WebElement element) {
        return ((TestBenchElement)element).wrap(elementType);
    }

    protected Object executeScript(String script, Object ... args) {
        WebDriver driver = this.getDriver();
        if (driver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.getDriver()).executeScript(script, args);
        }
        throw new UnsupportedOperationException("The web driver does not support JavaScript execution");
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition, Duration duration) {
        return (T)new WebDriverWait(this.getDriver(), duration).until(condition);
    }

    @Deprecated
    protected <T> T waitUntil(ExpectedCondition<T> condition, long timeoutInSeconds) {
        return this.waitUntil(condition, Duration.ofSeconds(timeoutInSeconds));
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition) {
        return this.waitUntil(condition, Duration.ofSeconds(10L));
    }

    static {
        LicenseChecker.checkLicenseFromStaticBlock((String)"vaadin-testbench", (String)"5.2", null);
        try {
            String seleniumVersion = new BuildInfo().getReleaseLabel();
            Properties properties = new Properties();
            properties.load(TestBenchTestCase.class.getResourceAsStream("testbench.properties"));
            String expectedVersion = properties.getProperty("selenium.version");
            if (seleniumVersion == null || !seleniumVersion.equals(expectedVersion)) {
                Logger.getLogger(TestBenchTestCase.class.getName()).warning("This version of TestBench depends on Selenium version " + expectedVersion + " but version " + seleniumVersion + " was found. Make sure you do not have multiple versions of Selenium on the classpath.");
            }
        }
        catch (Exception e) {
            Logger.getLogger(TestBenchTestCase.class.getName()).log(Level.WARNING, "Unable to validate that the correct Selenium version is in use", e);
        }
    }
}

