/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.AbstractHasTestBenchCommandExecutor;
import com.vaadin.testbench.By;
import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.commands.CanCompareScreenshots;
import com.vaadin.testbench.commands.CanWaitForVaadin;
import com.vaadin.testbench.commands.ScreenshotComparator;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.commands.TestBenchElementCommands;
import com.vaadin.testbench.elementsbase.AbstractElement;
import com.vaadin.testbench.parallel.BrowserUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class TestBenchElement
extends AbstractHasTestBenchCommandExecutor
implements WrapsElement,
WebElement,
TestBenchElementCommands,
CanWaitForVaadin,
HasDriver,
CanCompareScreenshots {
    private WebElement actualElement = null;
    private TestBenchCommandExecutor tbCommandExecutor = null;

    protected TestBenchElement() {
    }

    protected TestBenchElement(WebElement webElement, TestBenchCommandExecutor tbCommandExecutor) {
        this.init(webElement, tbCommandExecutor);
    }

    protected void init(WebElement element, TestBenchCommandExecutor tbCommandExecutor) {
        if (null == this.tbCommandExecutor) {
            this.tbCommandExecutor = tbCommandExecutor;
            this.actualElement = element;
            this.init();
        }
    }

    protected boolean isChrome() {
        return BrowserUtil.isChrome(this.getCapabilities());
    }

    protected boolean isFirefox() {
        return BrowserUtil.isFirefox(this.getCapabilities());
    }

    protected Capabilities getCapabilities() {
        WebDriver driver = this.getDriver() instanceof TestBenchDriverProxy ? ((TestBenchDriverProxy)this.getDriver()).getWrappedDriver() : this.getDriver();
        if (driver instanceof HasCapabilities) {
            return ((HasCapabilities)driver).getCapabilities();
        }
        return null;
    }

    protected void init() {
    }

    public WebElement getWrappedElement() {
        return this.actualElement;
    }

    @Override
    public void waitForVaadin() {
        if (this.getCommandExecutor() != null) {
            this.getCommandExecutor().waitForVaadin();
        }
    }

    @Override
    public void showTooltip() {
        this.waitForVaadin();
        new Actions(this.getDriver()).moveToElement(this.actualElement).perform();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getId() {
        return this.getAttribute("id");
    }

    @Override
    public void scroll(int scrollTop) {
        TestBenchCommandExecutor js = this.getCommandExecutor();
        js.executeScript("arguments[0].scrollTop = " + scrollTop, new Object[]{this.actualElement});
    }

    @Override
    public void scrollLeft(int scrollLeft) {
        TestBenchCommandExecutor js = this.getCommandExecutor();
        js.executeScript("arguments[0].scrollLeft = " + scrollLeft, new Object[]{this.actualElement});
    }

    public boolean isFocused() {
        return this.getWrappedElement().equals(this.getDriver().switchTo().activeElement());
    }

    public void click() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        this.actualElement.click();
    }

    public void submit() {
        this.click();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.autoScrollIntoView();
        this.waitForVaadin();
        this.actualElement.sendKeys(keysToSend);
    }

    public void clear() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        this.actualElement.clear();
    }

    public String getTagName() {
        this.waitForVaadin();
        return this.actualElement.getTagName();
    }

    public String getDomAttribute(String name) {
        this.waitForVaadin();
        return this.actualElement.getDomAttribute(name);
    }

    public String getAttribute(String name) {
        this.waitForVaadin();
        return this.actualElement.getAttribute(name);
    }

    public boolean hasAttribute(String attribute) {
        return this.getAttribute(attribute) != null;
    }

    public String getAriaRole() {
        this.waitForVaadin();
        return this.actualElement.getAriaRole();
    }

    public String getAccessibleName() {
        this.waitForVaadin();
        return this.actualElement.getAccessibleName();
    }

    public boolean isSelected() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        return this.actualElement.isSelected();
    }

    public boolean isEnabled() {
        this.waitForVaadin();
        return !this.hasClassName("v-disabled") && this.actualElement.isEnabled();
    }

    public boolean isReadOnly() {
        this.waitForVaadin();
        return this.hasAttribute("readonly");
    }

    public String getText() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        return this.actualElement.getText();
    }

    public List<WebElement> findElements(By by) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        if (by instanceof By.ByVaadin) {
            elements.addAll(TestBenchElement.wrapElements(by.findElements((SearchContext)this), this.getCommandExecutor()));
        } else {
            elements.addAll(TestBenchElement.wrapElements(this.actualElement.findElements(by), this.getCommandExecutor()));
        }
        return elements;
    }

    public WebElement findElement(By by) {
        this.waitForVaadin();
        if (by instanceof By.ByVaadin) {
            return TestBenchElement.wrapElement(by.findElement((SearchContext)this), this.getCommandExecutor());
        }
        return TestBenchElement.wrapElement(this.actualElement.findElement(by), this.getCommandExecutor());
    }

    public SearchContext getShadowRoot() {
        this.waitForVaadin();
        return this.actualElement.getShadowRoot();
    }

    public void clickHiddenElement() {
        this.getCommandExecutor().executeScript("arguments[0].click()", this.actualElement);
    }

    public boolean isDisplayed() {
        this.waitForVaadin();
        return this.actualElement.isDisplayed();
    }

    public Point getLocation() {
        this.waitForVaadin();
        return this.actualElement.getLocation();
    }

    public Dimension getSize() {
        this.waitForVaadin();
        return this.actualElement.getSize();
    }

    public String getCssValue(String propertyName) {
        this.waitForVaadin();
        return this.actualElement.getCssValue(propertyName);
    }

    @Override
    public void click(int x, int y, Keys ... modifiers) {
        this.autoScrollIntoView();
        this.waitForVaadin();
        Actions actions = new Actions(this.getDriver());
        actions.moveToElement(this.actualElement, x, y);
        for (Keys modifier : modifiers) {
            actions.keyDown((CharSequence)modifier);
        }
        actions.click();
        for (Keys modifier : modifiers) {
            actions.keyUp((CharSequence)modifier);
        }
        actions.build().perform();
    }

    public void doubleClick() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        new Actions(this.getDriver()).doubleClick(this.actualElement).build().perform();
    }

    public void contextClick() {
        this.autoScrollIntoView();
        this.waitForVaadin();
        new Actions(this.getDriver()).contextClick(this.actualElement).build().perform();
    }

    @Override
    public <T extends AbstractElement> T wrap(Class<T> elementType) {
        return (T)((AbstractElement)TestBench.createElement(elementType, this.getWrappedElement(), this.getCommandExecutor()));
    }

    @Override
    public TestBenchCommandExecutor getCommandExecutor() {
        return this.tbCommandExecutor;
    }

    @Override
    public WebDriver getDriver() {
        return this.getCommandExecutor().getDriver();
    }

    @Override
    public SearchContext getContext() {
        return this;
    }

    @Override
    public void focus() {
        this.waitForVaadin();
        this.getCommandExecutor().focusElement(this);
    }

    protected static List<TestBenchElement> wrapElements(List<WebElement> elements, TestBenchCommandExecutor tbCommandExecutor) {
        ArrayList<TestBenchElement> wrappedList = new ArrayList<TestBenchElement>();
        for (WebElement e : elements) {
            wrappedList.add(TestBenchElement.wrapElement(e, tbCommandExecutor));
        }
        return wrappedList;
    }

    protected static TestBenchElement wrapElement(WebElement element, TestBenchCommandExecutor tbCommandExecutor) {
        if (element instanceof TestBenchElement) {
            return (TestBenchElement)element;
        }
        return TestBench.createElement(element, tbCommandExecutor);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        this.waitForVaadin();
        return (X)this.actualElement.getScreenshotAs(target);
    }

    public Rectangle getRect() {
        this.waitForVaadin();
        return this.actualElement.getRect();
    }

    public Set<String> getClassNames() {
        String classAttribute = this.getAttribute("class");
        HashSet<String> classes = new HashSet<String>();
        if (classAttribute == null) {
            return classes;
        }
        if ((classAttribute = classAttribute.trim()).isEmpty()) {
            return classes;
        }
        Collections.addAll(classes, classAttribute.split("[ ]+"));
        return classes;
    }

    public boolean hasClassName(String className) {
        if (className == null || className.isEmpty()) {
            return false;
        }
        return this.getClassNames().contains(className);
    }

    public boolean equals(Object obj) {
        if (this.actualElement == null) {
            return false;
        }
        return this.actualElement.equals(obj);
    }

    public int hashCode() {
        if (this.actualElement == null) {
            return 32;
        }
        return this.actualElement.hashCode();
    }

    @Override
    public boolean compareScreen(String referenceId) throws IOException {
        return ScreenshotComparator.compareScreen(referenceId, this.getCommandExecutor().getReferenceNameGenerator(), this.getCommandExecutor().getImageComparison(), (TakesScreenshot)this, (HasCapabilities)this.getDriver());
    }

    @Override
    public boolean compareScreen(File reference) throws IOException {
        return ScreenshotComparator.compareScreen(reference, this.getCommandExecutor().getImageComparison(), (TakesScreenshot)this, (HasCapabilities)this.getDriver());
    }

    @Override
    public boolean compareScreen(BufferedImage reference, String referenceName) throws IOException {
        return ScreenshotComparator.compareScreen(reference, referenceName, this.getCommandExecutor().getImageComparison(), (TakesScreenshot)this, (HasCapabilities)this.getDriver());
    }

    public void scrollIntoView() {
        this.getCommandExecutor().executeScript("arguments[0].scrollIntoView()", this.actualElement);
    }

    private void autoScrollIntoView() {
        if (this.getCommandExecutor().isAutoScrollIntoView() && !this.actualElement.isDisplayed()) {
            this.scrollIntoView();
        }
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition, long timeoutInSeconds) {
        return (T)new WebDriverWait(this.getDriver(), Duration.ofSeconds(timeoutInSeconds)).until(condition);
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition) {
        return this.waitUntil(condition, 10L);
    }
}

