/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.By;
import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.HasTestBenchCommandExecutor;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.screenshot.ImageComparison;
import com.vaadin.testbench.screenshot.ReferenceNameGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;

public class TestBenchDriverProxy
extends TestBenchCommandExecutor
implements WebDriver,
WrapsDriver,
HasTestBenchCommandExecutor,
HasDriver {
    private final WebDriver actualDriver;

    protected TestBenchDriverProxy(WebDriver webDriver) {
        super(webDriver, new ImageComparison(), new ReferenceNameGenerator());
        this.actualDriver = webDriver;
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.actualDriver;
    }

    public WebDriver getActualDriver() {
        return this.actualDriver;
    }

    public void close() {
        this.actualDriver.close();
    }

    public WebElement findElement(By arg0) {
        if (arg0 instanceof By.ByVaadin) {
            return TestBenchElement.wrapElement(arg0.findElement((SearchContext)this), this);
        }
        return TestBenchElement.wrapElement(this.actualDriver.findElement(arg0), this);
    }

    public List<WebElement> findElements(By arg0) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        if (arg0 instanceof By.ByVaadin) {
            elements.addAll(TestBenchElement.wrapElements(arg0.findElements((SearchContext)this), this));
        } else {
            elements.addAll(TestBenchElement.wrapElements(this.actualDriver.findElements(arg0), this));
        }
        return elements;
    }

    protected static WebElement findElementByVaadinSelector(String selector, SearchContext context) {
        List<WebElement> elements = TestBenchDriverProxy.executeSearch(selector, context, "getElementByPath");
        if (elements.isEmpty()) {
            String errorString = "Vaadin could not find elements with the selector " + selector;
            throw new NoSuchElementException(errorString, (Throwable)new Exception("Client could not identify elements with the provided selector"));
        }
        return elements.get(0);
    }

    protected static List<WebElement> findElementsByVaadinSelector(String selector, SearchContext context) {
        return TestBenchDriverProxy.executeSearch(selector, context, "getElementsByPath");
    }

    private static List<WebElement> executeSearch(String selector, SearchContext context, String jsFunction) {
        String errorString = "Vaadin could not find elements with the selector " + selector;
        String elementSelectionString = "var element = clients[client]." + jsFunction;
        elementSelectionString = context instanceof WebDriver ? elementSelectionString + "(arguments[0]);" : elementSelectionString + "StartingAt(arguments[0], arguments[1]);";
        String findByVaadinScript = "var clients = window.vaadin.clients;var elements = [];for (client in clients) {" + elementSelectionString + "  if (element) { elements = elements.concat(element);  }}return elements;";
        WebDriver driver = ((HasDriver)context).getDriver();
        JavascriptExecutor jse = (JavascriptExecutor)driver;
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        if (selector.contains("::")) {
            String client = selector.substring(0, selector.indexOf("::"));
            String path = selector.substring(selector.indexOf("::") + 2);
            try {
                Object output = jse.executeScript("return window.vaadin.clients." + client + "." + jsFunction + "(\"" + path + "\");", new Object[0]);
                elements.addAll(TestBenchDriverProxy.extractWebElements(output));
            }
            catch (Exception e) {
                throw new NoSuchElementException(errorString, (Throwable)e);
            }
        }
        try {
            if (context instanceof WebDriver) {
                Object output = jse.executeScript(findByVaadinScript, new Object[]{selector});
                elements.addAll(TestBenchDriverProxy.extractWebElements(output));
            } else {
                Object output = jse.executeScript(findByVaadinScript, new Object[]{selector, context});
                elements.addAll(TestBenchDriverProxy.extractWebElements(output));
            }
        }
        catch (Exception e) {
            throw new NoSuchElementException(errorString, (Throwable)e);
        }
        return elements;
    }

    private static List<WebElement> extractWebElements(Object elementList) {
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        if (elementList instanceof WebElement) {
            result.add((WebElement)elementList);
        } else if (elementList instanceof List) {
            for (Object o : (List)elementList) {
                if (null == o || !(o instanceof WebElement)) continue;
                result.add((WebElement)o);
            }
        }
        return result;
    }

    public void get(String arg0) {
        this.actualDriver.get(arg0);
    }

    public String getCurrentUrl() {
        return this.actualDriver.getCurrentUrl();
    }

    public String getPageSource() {
        return this.actualDriver.getPageSource();
    }

    public String getTitle() {
        return this.actualDriver.getTitle();
    }

    public String getWindowHandle() {
        return this.actualDriver.getWindowHandle();
    }

    public Set<String> getWindowHandles() {
        return this.actualDriver.getWindowHandles();
    }

    public WebDriver.Options manage() {
        return this.actualDriver.manage();
    }

    public WebDriver.Navigation navigate() {
        return this.actualDriver.navigate();
    }

    public void quit() {
        this.actualDriver.quit();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.actualDriver.switchTo();
    }

    @Override
    public SearchContext getContext() {
        return this;
    }

    @Override
    public TestBenchCommandExecutor getCommandExecutor() {
        return this;
    }

    @Override
    public WebDriver getDriver() {
        return this;
    }
}

