/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.testbench.DriverInvocationHandler;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class TestBench {
    private static final Map<Class<?>, MethodFilter> methodFilters;

    public static WebDriver createDriver(WebDriver driver) {
        Object proxy;
        Set<Class<?>> allInterfaces = TestBench.extractInterfaces(driver);
        Class<TestBenchDriverProxy> driverClass = TestBenchDriverProxy.class;
        allInterfaces.addAll(TestBench.extractInterfaces(driverClass));
        Class[] allInterfacesArray = allInterfaces.toArray(new Class[allInterfaces.size()]);
        ProxyFactory pFactory = new ProxyFactory();
        pFactory.setInterfaces(allInterfacesArray);
        pFactory.setSuperclass(driverClass);
        try {
            proxy = pFactory.create(new Class[]{WebDriver.class}, new Object[]{driver}, (MethodHandler)new DriverInvocationHandler(driver));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return (WebDriver)proxy;
    }

    public static TestBenchElement createElement(WebElement webElement, TestBenchCommandExecutor tbCommandExecutor) {
        return TestBench.createElement(TestBenchElement.class, webElement, tbCommandExecutor);
    }

    public static <T extends TestBenchElement> T createElement(Class<T> clazz, WebElement webElement, TestBenchCommandExecutor tbCommandExecutor) {
        Object proxyObject;
        if (webElement == null) {
            return null;
        }
        Set<Class<?>> allInterfaces = TestBench.extractInterfaces(webElement);
        Class[] allInterfacesArray = allInterfaces.toArray(new Class[allInterfaces.size()]);
        ProxyFactory pFactory = new ProxyFactory();
        pFactory.setSuperclass(clazz);
        pFactory.setInterfaces(allInterfacesArray);
        pFactory.setFilter(TestBench.getMethodFilter(clazz));
        try {
            proxyObject = pFactory.create(new Class[0], new Object[0], (MethodHandler)new ElementInvocationHandler(webElement));
        }
        catch (Exception e) {
            return null;
        }
        TestBenchElement proxy = (TestBenchElement)proxyObject;
        proxy.init(webElement, tbCommandExecutor);
        return (T)proxy;
    }

    private static MethodFilter getMethodFilter(Class<? extends TestBenchElement> clazz) {
        if (!methodFilters.containsKey(clazz)) {
            methodFilters.put(clazz, new ElementMethodFilter(clazz));
        }
        return methodFilters.get(clazz);
    }

    private static Set<Class<?>> extractInterfaces(Object object) {
        return TestBench.extractInterfaces(object.getClass());
    }

    private static Set<Class<?>> extractInterfaces(Class<?> clazz) {
        HashSet allInterfaces = new HashSet();
        TestBench.extractInterfaces(allInterfaces, clazz);
        return allInterfaces;
    }

    private static void extractInterfaces(Set<Class<?>> addTo, Class<?> clazz) {
        Class<?>[] classes;
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        for (Class<?> interfaceClass : classes = clazz.getInterfaces()) {
            addTo.add(interfaceClass);
            for (Class<?> superInterface : interfaceClass.getInterfaces()) {
                addTo.add(superInterface);
                TestBench.extractInterfaces(addTo, superInterface);
            }
        }
        TestBench.extractInterfaces(addTo, clazz.getSuperclass());
    }

    static {
        LicenseChecker.checkLicenseFromStaticBlock((String)"vaadin-testbench", (String)"5.2", null);
        methodFilters = new ConcurrentHashMap();
    }

    private static final class ElementInvocationHandler
    implements MethodHandler {
        private Object actualElement;

        public ElementInvocationHandler(Object actualElement) {
            this.actualElement = actualElement;
        }

        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            if (null != proceed) {
                return proceed.invoke(self, args);
            }
            return thisMethod.invoke(this.actualElement, args);
        }
    }

    private static final class ElementMethodFilter
    implements MethodFilter {
        private Class<?> proxyClass;
        private Map<Method, Boolean> invocationNeeded;

        public ElementMethodFilter(Class<?> clazz) {
            this.proxyClass = clazz;
            this.invocationNeeded = new ConcurrentHashMap<Method, Boolean>();
        }

        public boolean isHandled(Method method) {
            if (!this.invocationNeeded.containsKey(method)) {
                try {
                    this.proxyClass.getMethod(method.getName(), method.getParameterTypes());
                    this.invocationNeeded.put(method, false);
                }
                catch (Exception e) {
                    this.invocationNeeded.put(method, true);
                }
            }
            return this.invocationNeeded.get(method);
        }
    }
}

