/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

public class Parameters {
    private static boolean isDebug;
    private static boolean isScreenshotComparisonCursorDetection;
    private static String screenshotReferenceDirectory;
    private static String screenshotErrorDirectory;
    private static double screenshotComparisonTolerance;
    private static int maxScreenshotRetries;
    private static int screenshotRetryDelay;
    private static int testsInParallel;
    private static int testSuitesInParallel;
    private static int maxAttempts;

    public static void setDebug(boolean isDebug) {
        Parameters.isDebug = isDebug;
    }

    private static boolean hasSystemProperty(String unqualifiedName) {
        return System.getProperty(Parameters.getQualifiedParameter(unqualifiedName)) != null;
    }

    private static String getSystemPropertyString(String unqualifiedName, String defaultValue) {
        if (Parameters.hasSystemProperty(unqualifiedName)) {
            return System.getProperty(Parameters.getQualifiedParameter(unqualifiedName));
        }
        return defaultValue;
    }

    private static boolean getSystemPropertyBoolean(String unqualifiedName, boolean defaultValue) {
        if (Parameters.hasSystemProperty(unqualifiedName)) {
            String str = System.getProperty(Parameters.getQualifiedParameter(unqualifiedName));
            return str != null && str.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    private static int getSystemPropertyInt(String unqualifiedName, int defaultValue) {
        if (Parameters.hasSystemProperty(unqualifiedName)) {
            String str = System.getProperty(Parameters.getQualifiedParameter(unqualifiedName));
            try {
                return Integer.parseInt(str);
            }
            catch (Exception e) {
                System.err.println("Unable to parse parameter '" + Parameters.getQualifiedParameter(unqualifiedName) + "' value " + str + " to an integer");
            }
        }
        return defaultValue;
    }

    private static double getSystemPropertyDouble(String unqualifiedName, double defaultValue) {
        if (Parameters.hasSystemProperty(unqualifiedName)) {
            String str = System.getProperty(Parameters.getQualifiedParameter(unqualifiedName));
            try {
                return Double.parseDouble(str);
            }
            catch (Exception e) {
                System.err.println("Unable to parse parameter '" + Parameters.getQualifiedParameter(unqualifiedName) + "' value " + str + " to a double");
            }
        }
        return defaultValue;
    }

    private static String getQualifiedParameter(String unqualifiedName) {
        return Parameters.class.getName() + "." + unqualifiedName;
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static void setScreenshotComparisonCursorDetection(boolean isScreenshotComparisonCursorDetection) {
        Parameters.isScreenshotComparisonCursorDetection = isScreenshotComparisonCursorDetection;
    }

    public static boolean isScreenshotComparisonCursorDetection() {
        return isScreenshotComparisonCursorDetection;
    }

    public static void setScreenshotReferenceDirectory(String screenshotReferenceDirectory) {
        Parameters.screenshotReferenceDirectory = screenshotReferenceDirectory;
    }

    public static String getScreenshotReferenceDirectory() {
        return screenshotReferenceDirectory;
    }

    public static void setScreenshotErrorDirectory(String screenshotErrorDirectory) {
        Parameters.screenshotErrorDirectory = screenshotErrorDirectory;
    }

    public static String getScreenshotErrorDirectory() {
        return screenshotErrorDirectory;
    }

    public static void setScreenshotComparisonTolerance(double tolerance) {
        screenshotComparisonTolerance = tolerance;
    }

    public static double getScreenshotComparisonTolerance() {
        return screenshotComparisonTolerance;
    }

    @Deprecated
    public static void setCaptureScreenshotOnFailure(boolean isCaptureScreenshotOnFailure) {
        throw new UnsupportedOperationException("Deprecated, this method no longer does anything.");
    }

    @Deprecated
    public static boolean isCaptureScreenshotOnFailure() {
        throw new UnsupportedOperationException("Deprecated, this method no longer does anything.");
    }

    public static void setMaxScreenshotRetries(int maxRetries) {
        maxScreenshotRetries = maxRetries;
    }

    public static int getMaxScreenshotRetries() {
        return maxScreenshotRetries;
    }

    public static void setScreenshotRetryDelay(int retryDelay) {
        screenshotRetryDelay = retryDelay;
    }

    public static int getScreenshotRetryDelay() {
        return screenshotRetryDelay;
    }

    @Deprecated
    public static int getMaxThreads() {
        return Parameters.getTestsInParallel();
    }

    @Deprecated
    public static void setMaxThreads(int maxThreads) {
        Parameters.setTestsInParallel(maxThreads);
    }

    public static void setTestsInParallel(int testsInParallel) {
        Parameters.testsInParallel = testsInParallel;
    }

    public static int getTestsInParallel() {
        return testsInParallel;
    }

    public static void setTestSuitesInParallel(int testSuitesInParallel) {
        Parameters.testSuitesInParallel = testSuitesInParallel;
    }

    public static int getTestSuitesInParallel() {
        return testSuitesInParallel;
    }

    public static String getHubHostname() {
        return Parameters.getSystemPropertyString("hubHostname", null);
    }

    public static String getRunLocallyBrowserName() {
        String browserAndVersion = Parameters.getSystemPropertyString("runLocally", null);
        if (browserAndVersion == null) {
            return null;
        }
        return Parameters.parseRunLocally(browserAndVersion)[0];
    }

    public static String getRunLocallyBrowserVersion() {
        String browserAndVersion = Parameters.getSystemPropertyString("runLocally", null);
        if (browserAndVersion == null) {
            return null;
        }
        return Parameters.parseRunLocally(browserAndVersion)[1];
    }

    static String[] parseRunLocally(String browserAndVersion) {
        if (browserAndVersion.contains("-")) {
            return browserAndVersion.split("-", 2);
        }
        return new String[]{browserAndVersion, ""};
    }

    public static boolean isLocalWebDriverUsed() {
        String useLocalWebDriver = System.getProperty("useLocalWebDriver");
        return useLocalWebDriver != null && useLocalWebDriver.toLowerCase().equals("true");
    }

    public static int getMaxAttempts() {
        return maxAttempts;
    }

    public static void setMaxAttempts(int maxAttempts) {
        Parameters.maxAttempts = maxAttempts;
    }

    static {
        screenshotRetryDelay = 500;
        isDebug = Parameters.getSystemPropertyBoolean("debug", false);
        isScreenshotComparisonCursorDetection = Parameters.getSystemPropertyBoolean("screenshotComparisonCursorDetection", false);
        screenshotReferenceDirectory = Parameters.getSystemPropertyString("screenshotReferenceDirectory", "reference-screenshots");
        screenshotErrorDirectory = Parameters.getSystemPropertyString("screenshotErrorDirectory", "error-screenshots");
        screenshotComparisonTolerance = Parameters.getSystemPropertyDouble("screenshotComparisonTolerance", 0.01);
        maxScreenshotRetries = Parameters.getSystemPropertyInt("maxScreenshotRetries", 2);
        screenshotRetryDelay = Parameters.getSystemPropertyInt("screenshotRetryDelay", 500);
        testSuitesInParallel = Parameters.getSystemPropertyInt("testSuitesInParallel", 20);
        maxAttempts = Parameters.getSystemPropertyInt("maxAttempts", 1);
        testsInParallel = Parameters.hasSystemProperty("testsInParallel") ? Parameters.getSystemPropertyInt("testsInParallel", 1) : (Parameters.isLocalWebDriverUsed() ? 10 : 50);
    }
}

