/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.By;
import com.vaadin.testbench.HasTestBenchCommandExecutor;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elementsbase.AbstractElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ElementQuery<T extends AbstractElement> {
    private static Logger logger = Logger.getLogger(ElementQuery.class.getName());
    private Map<String, Set<String>> statevars = new LinkedHashMap<String, Set<String>>();
    private int idx = -1;
    private SearchContext searchContext;
    private boolean recursive = true;
    Class<T> elementClass;
    private Stack<ElementQuery<?>> queryStack = new Stack();

    public ElementQuery(Class<T> elementClass) {
        this.elementClass = elementClass;
    }

    public ElementQuery<T> recursive(boolean recursion) {
        this.recursive = recursion;
        return this;
    }

    public <E extends AbstractElement> ElementQuery<E> $(Class<E> cls) {
        ElementQuery<E> newQuery = new ElementQuery<E>(cls).context(this.getContext());
        newQuery.queryStack.push(this);
        return newQuery;
    }

    public <E extends AbstractElement> ElementQuery<E> $$(Class<E> cls) {
        ElementQuery<E> newQuery = new ElementQuery<E>(cls).context(this.getContext());
        newQuery.recursive(false);
        newQuery.queryStack.push(this);
        return newQuery;
    }

    public <E extends AbstractElement> ElementQuery<T> in(ElementQuery<E> query) {
        this.queryStack.push(query);
        return this;
    }

    public <E extends AbstractElement> ElementQuery<T> child(ElementQuery<E> query) {
        if (this.queryStack.isEmpty()) {
            this.recursive(false);
        } else {
            this.queryStack.peek().recursive(false);
        }
        return this.in(query);
    }

    public T id(String id) {
        return this.state("id", id).first();
    }

    public ElementQuery<T> caption(String caption) {
        return this.state("caption", caption);
    }

    public ElementQuery<T> state(String varname, String value) {
        boolean isValid;
        Pattern p = Pattern.compile("[0-9]+");
        Matcher m = p.matcher(varname);
        boolean bl = isValid = !m.matches();
        if (isValid) {
            if (!this.statevars.containsKey(varname)) {
                this.statevars.put(varname, new LinkedHashSet());
            }
            this.statevars.get(varname).add(value);
            return this;
        }
        logger.warning("State variable is invalid! State variable name cannot be an integer.");
        return null;
    }

    public ElementQuery<T> index(int index) {
        this.idx = index;
        return this;
    }

    public ElementQuery<T> context(SearchContext searchContext) {
        this.searchContext = searchContext;
        return this;
    }

    protected SearchContext getContext() {
        return this.searchContext;
    }

    public T first() {
        return this.get(0);
    }

    public T last() {
        List<T> all = this.all();
        return (T)((AbstractElement)all.get(all.size() - 1));
    }

    public T get(int index) {
        String query;
        try {
            query = "(" + this.generateQuery() + ")[" + index + "]";
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create locator query", e);
        }
        List<T> elements = this.executeSearch(query);
        if (elements.isEmpty()) {
            String errorString = "Vaadin could not find elements with selector " + query;
            throw new NoSuchElementException(errorString);
        }
        return (T)((AbstractElement)elements.get(0));
    }

    public boolean exists() {
        try {
            return !this.all().isEmpty();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public List<T> all() {
        String query;
        try {
            query = this.generateQuery();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create locator query", e);
        }
        return this.executeSearch(query);
    }

    private List<T> executeSearch(String query) {
        List results = null;
        ArrayList<AbstractElement> elements = new ArrayList<AbstractElement>();
        results = By.vaadin(query).findElements(this.getContext());
        TestBenchCommandExecutor tbCommandExecutor = ((HasTestBenchCommandExecutor)this.getContext()).getCommandExecutor();
        for (WebElement webElement : results) {
            AbstractElement element = (AbstractElement)TestBench.createElement(this.elementClass, webElement, tbCommandExecutor);
            if (null == element) continue;
            elements.add(element);
        }
        return elements;
    }

    protected String generateQuery() {
        String output = "";
        Stack tmpStack = (Stack)this.queryStack.clone();
        while (!tmpStack.isEmpty()) {
            ElementQuery current = (ElementQuery)tmpStack.pop();
            output = output + current.generateQuery();
        }
        output = output + (this.recursive ? "//" : "/");
        output = output + this.elementClass.getAnnotation(ServerClass.class).value();
        if (this.statevars.size() > 0 || this.idx >= 0) {
            output = output + "[";
            boolean first = true;
            for (Map.Entry<String, Set<String>> entry : this.statevars.entrySet()) {
                String key = entry.getKey();
                for (String value : entry.getValue()) {
                    if (!first) {
                        output = output + ",";
                    } else {
                        first = false;
                    }
                    value = null == value ? "?" : "\"" + value + "\"";
                    output = output + key + "=" + value;
                }
            }
            if (this.idx >= 0) {
                if (this.statevars.size() > 0) {
                    output = output + ",";
                }
                output = output + this.idx;
            }
            output = output + "]";
        }
        return output;
    }
}

