/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.commands.CanWaitForVaadin;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.util.proxy.MethodHandler;

public class DriverInvocationHandler
implements MethodHandler {
    private Map<Method, Boolean> proxyMethod = new HashMap<Method, Boolean>();
    private final Object actualObject;
    private static final List<String> methodsNotNeedingWaitForVaadin = Arrays.asList("close", "get", "getRemoteControlName", "manage", "getWrappedDriver", "navigate", "quit", "setTestName", "switchTo", "waitForVaadin", "enableWaitForVaadin", "disableWaitForVaadin");

    public DriverInvocationHandler(Object actualObject) {
        this.actualObject = actualObject;
    }

    public Object invoke(Object proxy, Method method, Method proceed, Object[] args) throws Throwable {
        try {
            this.waitForVaadinIfNecessary(proxy, method.getName());
            if (!this.proxyMethod.containsKey(method)) {
                try {
                    TestBenchDriverProxy.class.getMethod(method.getName(), method.getParameterTypes());
                    this.proxyMethod.put(method, true);
                }
                catch (NoSuchMethodException e) {
                    this.actualObject.getClass().getMethod(method.getName(), method.getParameterTypes());
                    this.proxyMethod.put(method, false);
                }
            }
            if (this.proxyMethod.get(method).booleanValue()) {
                return proceed.invoke(proxy, args);
            }
            return method.invoke(this.actualObject, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private void waitForVaadinIfNecessary(Object proxyObject, String methodName) {
        if (this.shouldWaitForVaadin(methodName) && proxyObject instanceof CanWaitForVaadin) {
            ((CanWaitForVaadin)proxyObject).waitForVaadin();
        }
    }

    private boolean shouldWaitForVaadin(String methodName) {
        return !methodsNotNeedingWaitForVaadin.contains(methodName);
    }
}

