/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.spreadsheet.elements;

import com.vaadin.addon.spreadsheet.elements.SpreadsheetElement;
import com.vaadin.testbench.By;
import com.vaadin.testbench.elementsbase.AbstractElement;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class SheetCellElement
extends AbstractElement {
    private SpreadsheetElement parent;

    public void setValue(String newValue) {
        if (this.isNormalCell()) {
            this.doubleClick();
            WebElement cellValueInput = this.parent.getCellValueInput();
            cellValueInput.clear();
            cellValueInput.sendKeys(new CharSequence[]{newValue});
            cellValueInput.sendKeys(new CharSequence[]{Keys.TAB});
            this.getCommandExecutor().waitForVaadin();
        }
    }

    public String getValue() {
        return this.getText();
    }

    public boolean isCellSelected() {
        return this.parent.isElementSelected((WebElement)this);
    }

    public boolean isNormalCell() {
        List children = this.findElements(By.xpath((String)".//*"));
        return this.noneOfTheElementsIsWidget(children);
    }

    private boolean noneOfTheElementsIsWidget(List<WebElement> children) {
        for (WebElement e : children) {
            if (!e.getAttribute("class").contains("v-widget")) continue;
            return false;
        }
        return true;
    }

    public boolean hasPopupButton() {
        List buttons = this.findElements(By.className((String)"popupbutton"));
        return !buttons.isEmpty();
    }

    public void popupButtonClick() {
        if (!this.hasPopupButton()) {
            throw new IllegalStateException("This cell doesn't have a PopupuButton");
        }
        this.findElement(By.className((String)"popupbutton")).click();
    }

    void setParent(SpreadsheetElement parent) {
        this.parent = parent;
    }

    public boolean hasInvalidFormulaIndicator() {
        List indicators = this.findElements(By.className((String)"cell-invalidformula-triangle"));
        return !indicators.isEmpty();
    }

    public boolean hasCommentIndicator() {
        List indicators = this.findElements(By.className((String)"cell-comment-triangle"));
        return !indicators.isEmpty();
    }
}

