/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.testers;

import com.vaadin.data.ValidationException;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.GridSortOrder;
import com.vaadin.event.EventRouter;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.shared.ui.grid.ColumnState;
import com.vaadin.testbench.uiunittest.Utils;
import com.vaadin.testbench.uiunittest.testers.Tester;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.components.grid.EditorCancelEvent;
import com.vaadin.ui.components.grid.EditorImpl;
import com.vaadin.ui.components.grid.EditorOpenEvent;
import com.vaadin.ui.components.grid.EditorSaveEvent;
import com.vaadin.ui.components.grid.MultiSelectionModel;
import com.vaadin.ui.components.grid.MultiSelectionModelImpl;
import com.vaadin.ui.components.grid.SingleSelectionModel;
import com.vaadin.ui.components.grid.SingleSelectionModelImpl;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GridTester<T>
extends Tester<Grid<T>> {
    private static final String GRID_IS_NOT_IN_MULTISELECT_MODE = "Grid is not in multiselect mode";
    private static final String THE_COLUMN_IS_HIDDEN = "The column is hidden";
    private static final String EDITOR_IS_DISABLED = "Editor is disabled";
    private static final String EDITOR_IS_CLOSED = "Editor is closed";
    private static final String ROW_OUT_OF_BOUNDS = "Row out of bounds";
    private static final String INTERACTABLE_ERROR = "Can't interact with disabled or invisible Grid";

    public GridTester(Grid<T> grid) {
        super(grid);
    }

    public Object cell(int column, int row) {
        assert (column > -1 && column < this.getComponent().getColumns().size()) : "Column out of bounds";
        assert (row > -1 && row < this.size()) : "Row out of bounds";
        assert (!((Grid.Column)this.getComponent().getColumns().get(column)).isHidden()) : "The column is hidden";
        T cat = this.item(row);
        ValueProvider vp = ((Grid.Column)this.getComponent().getColumns().get(column)).getValueProvider();
        Object content = vp.apply(cat);
        if (content instanceof Component) {
            Component c = (Component)content;
            Grid<T> grid = this.getComponent();
            assert (grid != null) : "Grid is null";
            try {
                Method addExtensionComponentMethod = Grid.class.getDeclaredMethod("addExtensionComponent", Component.class);
                addExtensionComponentMethod.setAccessible(true);
                addExtensionComponentMethod.invoke(grid, c);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke Grid.addExtensionComponent reflectively", e);
            }
            this.fireSimulatedEvent((EventObject)new HasComponents.ComponentAttachEvent(grid, c));
            grid.getUI().getConnectorTracker().markDirty(grid);
        }
        return content;
    }

    public String description(int row) {
        assert (row > -1 && row < this.size()) : "Row out of bounds";
        assert (this.getComponent().getDescriptionGenerator() != null) : "No description generator set for the row";
        return (String)this.getComponent().getDescriptionGenerator().apply(this.item(row));
    }

    public String description(int column, int row) {
        assert (column > -1 && column < this.getComponent().getColumns().size()) : "Column out of bounds";
        assert (row > -1 && row < this.size()) : "Row out of bounds";
        Grid.Column col = (Grid.Column)this.getComponent().getColumns().get(column);
        assert (!col.isHidden()) : "The column is hidden";
        assert (col.getDescriptionGenerator() != null) : "No description generator set for the column";
        return (String)col.getDescriptionGenerator().apply(this.item(row));
    }

    public String styleName(int row) {
        assert (row > -1 && row < this.size()) : "Row out of bounds";
        return this.getComponent().getStyleGenerator().apply(this.item(row));
    }

    public T item(int row) {
        assert (row > -1 && row < this.size()) : "Row out of bounds";
        return (T)this.getComponent().getDataCommunicator().fetchItemsWithRange(row, 1).get(0);
    }

    public int size() {
        return this.getComponent().getDataCommunicator().getDataProviderSize();
    }

    public void click(int column, int row) {
        assert (this.isInteractable()) : "Can't interact with disabled or invisible Grid";
        assert (column > -1 && column < this.getComponent().getColumns().size()) : "Column out of bounds";
        assert (row > -1 && row < this.size()) : "Row out of bounds";
        assert (!((Grid.Column)this.getComponent().getColumns().get(column)).isHidden()) : "The column is hidden";
        T item = this.item(row);
        MouseEventDetails details = new MouseEventDetails();
        details.setButton(MouseEventDetails.MouseButton.LEFT);
        Grid.ItemClick event = new Grid.ItemClick(this.getComponent(), (Grid.Column)this.getComponent().getColumns().get(column), item, details, row);
        this.getComponent().focus();
        this.fireSimulatedEvent((EventObject)event);
        if (this.getComponent().getSelectionModel() instanceof SingleSelectionModel) {
            if (this.getComponent().getSelectedItems().contains(item)) {
                this.deselect(item);
            } else {
                this.select(item);
            }
        }
    }

    public void clickToSelect(int row) {
        assert (this.isInteractable()) : "Can't interact with disabled or invisible Grid";
        assert (this.getComponent().getSelectionModel() instanceof MultiSelectionModel) : "Grid is not in multiselect mode";
        T item = this.item(row);
        this.getComponent().focus();
        this.clickToSelect(item);
    }

    public void clickToSelect(T item) {
        assert (this.isInteractable()) : "Can't interact with disabled or invisible Grid";
        assert (this.getComponent().getSelectionModel() instanceof MultiSelectionModel) : "Grid is not in multiselect mode";
        this.getComponent().focus();
        if (this.getComponent().getSelectedItems().contains(item)) {
            this.deselect((T)Utils.setOfItems(item));
        } else {
            this.select((T)Utils.setOfItems(item));
        }
    }

    public void edit(int row) {
        Grid<T> grid = this.getComponent();
        assert (this.isInteractable()) : "Can't interact with disabled or invisible Grid";
        assert (this.getComponent().getEditor().isEnabled()) : "Editor is disabled";
        T editing = this.item(row);
        if (grid.getEditor().isBuffered()) {
            grid.getEditor().editRow(row);
            grid.getEditor().getBinder().readBean(editing);
        } else {
            grid.getEditor().getBinder().setBean(editing);
        }
        this.fireEditorEvent((EventObject)new EditorOpenEvent(grid.getEditor(), editing));
        this.setEdited(editing);
    }

    private void setEdited(T edited) {
        Grid<T> grid = this.getComponent();
        EditorImpl editor = (EditorImpl)grid.getEditor();
        Class<?> clazz = editor.getClass();
        try {
            Field editedField = clazz.getDeclaredField("edited");
            editedField.setAccessible(true);
            editedField.set(editor, edited);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    private T getEdited() {
        Grid<T> grid = this.getComponent();
        EditorImpl editor = (EditorImpl)grid.getEditor();
        Class<?> clazz = editor.getClass();
        try {
            Field editedField = clazz.getDeclaredField("edited");
            editedField.setAccessible(true);
            return (T)editedField.get(editor);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean editorOpen() {
        return this.getComponent().getEditor().isOpen();
    }

    public void save() {
        Grid<T> grid = this.getComponent();
        assert (this.isInteractable()) : "Can't interact with disabled or invisible Grid";
        assert (this.getComponent().getEditor().isEnabled()) : "Editor is disabled";
        assert (this.editorOpen()) : "Editor is closed";
        T editing = this.getEdited();
        if (grid.getEditor().isBuffered()) {
            try {
                grid.getEditor().getBinder().writeBean(editing);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
        this.fireEditorEvent((EventObject)new EditorSaveEvent(grid.getEditor(), editing));
        grid.getDataProvider().refreshItem(editing);
        this.setEdited(null);
    }

    public void cancel() {
        Grid<T> grid = this.getComponent();
        assert (this.isInteractable()) : "Can't interact with disabled or invisible Grid";
        assert (this.getComponent().getEditor().isEnabled()) : "Editor is disabled";
        assert (this.editorOpen()) : "Editor is closed";
        assert (this.editorOpen()) : "Editor is closed";
        T editing = this.getEdited();
        this.fireEditorEvent((EventObject)new EditorCancelEvent(grid.getEditor(), editing));
        this.setEdited(null);
    }

    public void toggleColumnVisibility(int columnIndex) {
        assert (this.isInteractable()) : "Can't interact with disabled or invisible Grid";
        Grid<T> grid = this.getComponent();
        assert (columnIndex < grid.getColumns().size() && columnIndex > -1) : "Column index out of bounds";
        Grid.Column column = (Grid.Column)grid.getColumns().get(columnIndex);
        assert (column.isHidable()) : "Column hiding is not enabled for this column";
        boolean hidden = column.isHidden();
        Class<?> clazz = column.getClass();
        try {
            Method getStateMethod = clazz.getDeclaredMethod("getState", new Class[0]);
            getStateMethod.setAccessible(true);
            ColumnState state = (ColumnState)getStateMethod.invoke((Object)column, new Object[0]);
            state.hidden = !hidden;
            grid.fireColumnVisibilityChangeEvent(column, !hidden, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void toggleColumnVisibility(String caption) {
        assert (this.isInteractable()) : "Can't interact with disabled or invisible Grid";
        Grid<T> grid = this.getComponent();
        for (int i = 0; i < grid.getColumns().size(); ++i) {
            String hidingCaption;
            Grid.Column column = (Grid.Column)grid.getColumns().get(i);
            String string = hidingCaption = column.getHidingToggleCaption() == null ? column.getCaption() : column.getHidingToggleCaption();
            if (!hidingCaption.equals(caption)) continue;
            this.toggleColumnVisibility(i);
            return;
        }
        assert (false) : "No match for the given caption";
    }

    public void toggleColumnSorting(int columnIndex) {
        assert (this.isInteractable()) : "Can't interact with disabled or invisible Grid";
        Grid<T> grid = this.getComponent();
        assert (columnIndex < grid.getColumns().size() && columnIndex > -1) : "Column index out of bounds";
        assert (!((Grid.Column)grid.getColumns().get(columnIndex)).isHidden()) : "The column is hidden";
        Grid.Column column = (Grid.Column)grid.getColumns().get(columnIndex);
        assert (column.isSortable()) : "Column sorting is not enabled for this column";
        ArrayList<GridSortOrder> newOrders = new ArrayList<GridSortOrder>();
        boolean changed = false;
        for (int i = 0; i < grid.getSortOrder().size(); ++i) {
            GridSortOrder newOrder;
            GridSortOrder order = (GridSortOrder)grid.getSortOrder().get(i);
            if (order.getSorted().equals((Object)column)) {
                SortDirection newDirection = order.getDirection().getOpposite();
                newOrder = new GridSortOrder(order.getSorted(), newDirection);
                changed = true;
            } else {
                newOrder = new GridSortOrder(order.getSorted(), order.getDirection());
            }
            newOrders.add(newOrder);
        }
        if (!changed) {
            newOrders.add(new GridSortOrder(column, SortDirection.ASCENDING));
        }
        Class<?> clazz = this.getComponent().getClass();
        while (!clazz.equals(Grid.class)) {
            clazz = clazz.getSuperclass();
        }
        try {
            Method setSortOrderMethod = clazz.getDeclaredMethod("setSortOrder", List.class, Boolean.TYPE);
            setSortOrderMethod.setAccessible(true);
            setSortOrderMethod.invoke(this.getComponent(), newOrders, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Component details(int row) {
        assert (row > -1 && row < this.size()) : "Row out of bounds";
        Grid<T> grid = this.getComponent();
        T item = this.item(row);
        assert (grid.isDetailsVisible(item)) : "Details are not visible for row " + row;
        try {
            Component details;
            Field detailsManagerField = Grid.class.getDeclaredField("detailsManager");
            detailsManagerField.setAccessible(true);
            Grid.DetailsManager detailsManager = (Grid.DetailsManager)detailsManagerField.get(grid);
            assert (detailsManager != null) : "Details manager is not available";
            Field generatorField = detailsManager.getClass().getDeclaredField("generator");
            generatorField.setAccessible(true);
            Object generator = generatorField.get(detailsManager);
            assert (generator != null) : "No details generator set";
            JsonObject dummy = Json.createObject();
            detailsManager.generateData(item, dummy);
            Field componentsField = detailsManager.getClass().getDeclaredField("components");
            componentsField.setAccessible(true);
            Map components = (Map)componentsField.get(detailsManager);
            Component component = details = components != null ? (Component)components.get(item) : null;
            if (details == null && components != null) {
                for (Map.Entry entry : components.entrySet()) {
                    if (!Objects.equals(entry.getKey(), item)) continue;
                    details = (Component)entry.getValue();
                    break;
                }
            }
            assert (details != null) : "Details component is not available for row " + row;
            return details;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new AssertionError("Failed to access Grid details internals via reflection", e);
        }
    }

    private void fireEditorEvent(EventObject event) {
        Grid<T> grid = this.getComponent();
        Class clazz = grid.getEditor().getClass();
        try {
            Field field = clazz.getDeclaredField("eventRouter");
            field.setAccessible(true);
            EventRouter eventRouter = (EventRouter)field.get(grid.getEditor());
            eventRouter.fireEvent(event);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    protected void select(Set<T> items) {
        assert (this.getComponent().getSelectionModel() instanceof MultiSelectionModel) : "Grid is not multiselect";
        assert (items != null) : "Items can't be null";
        Set copy = this.getComponent().getSelectedItems().stream().map(Objects::requireNonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        copy.addAll(items);
        LinkedHashSet removed = new LinkedHashSet(this.getComponent().getSelectedItems());
        this.updateSelection(copy, removed);
    }

    protected void deselect(Set<T> items) {
        assert (this.getComponent().getSelectionModel() instanceof MultiSelectionModel) : "Grid is not multiselect";
        assert (items != null) : "Items can't be null";
        Set copy = this.getComponent().getSelectedItems().stream().map(Objects::requireNonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        copy.removeAll(items);
        LinkedHashSet removed = new LinkedHashSet(this.getComponent().getSelectedItems());
        this.updateSelection(copy, removed);
    }

    private void updateSelection(Set<T> copy, Set<T> removed) {
        MultiSelectionModelImpl model = (MultiSelectionModelImpl)this.getComponent().getSelectionModel();
        Class<?> clazz = model.getClass();
        try {
            Method updateSelectionMethod = clazz.getDeclaredMethod("updateSelection", Set.class, Set.class, Boolean.TYPE);
            updateSelectionMethod.setAccessible(true);
            updateSelectionMethod.invoke((Object)model, copy, removed, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected void select(T item) {
        assert (this.getComponent().getSelectionModel() instanceof SingleSelectionModel) : "Grid is not singleselect";
        String key = this.getComponent().getDataCommunicator().getKeyMapper().key(item);
        SingleSelectionModelImpl model = (SingleSelectionModelImpl)this.getComponent().getSelectionModel();
        Class<?> clazz = model.getClass();
        try {
            Method setSelectedFromClientMethod = clazz.getDeclaredMethod("setSelectedFromClient", String.class);
            setSelectedFromClientMethod.setAccessible(true);
            setSelectedFromClientMethod.invoke((Object)model, key);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected void deselect(T item) {
        item = null;
        this.select(item);
    }

    @Override
    protected Grid<T> getComponent() {
        return (Grid)super.getComponent();
    }
}

