/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.mocks;

import com.vaadin.testbench.uiunittest.Utils;
import com.vaadin.testbench.uiunittest.mocks.MockHttpSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class MockServletRequest
implements HttpServletRequest {
    private List<Part> partsInt;
    private Cookie[] cookiesInt;
    private MockHttpSession session;
    private Map<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>();
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private Map<String, String[]> parameters = new ConcurrentHashMap<String, String[]>();
    private String characterEncodingInt;
    private Set<Locale> locales = Utils.setOfItems(Locale.UK);

    public MockServletRequest(MockHttpSession session) {
        this.session = session;
        String[] loc = new String[]{""};
        this.parameters.put("v-loc", loc);
        String[] cw = new String[]{"1280"};
        this.parameters.put("v-cw", cw);
        String[] ch = new String[]{"800"};
        this.parameters.put("v-ch", ch);
        String[] wn = new String[]{"window"};
        this.parameters.put("v-wn", wn);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncodingInt;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.characterEncodingInt = env;
    }

    public int getContentLength() {
        return -1;
    }

    public long getContentLengthLong() {
        return -1L;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getParameter(String name) {
        return this.parameters.get(name) != null ? this.parameters.get(name)[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return "127.0.0.1";
    }

    public int getServerPort() {
        return 8080;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    public String getRemoteHost() {
        return "127.0.0.1";
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return this.locales.iterator().next();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException("not implemented");
    }

    public int getRemotePort() {
        return 8080;
    }

    public String getLocalName() {
        return "localhost";
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public int getLocalPort() {
        return 8080;
    }

    public ServletContext getServletContext() {
        return this.getSession().getServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException("not implemented");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException("not implemented");
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return this.cookiesInt;
    }

    public long getDateHeader(String name) {
        return -1L;
    }

    public String getHeader(String name) {
        return this.headers.get(name) != null && this.headers.get(name).size() == 1 ? this.headers.get(name).get(0) : null;
    }

    public Enumeration<String> getHeaders(String name) {
        return this.headers.get(name) != null ? Collections.enumeration((Collection)this.headers.get(name)) : null;
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        return Integer.valueOf(this.getHeader(name));
    }

    public String getMethod() {
        return "GET";
    }

    public String getPathInfo() {
        return "";
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getContextPath() {
        return "";
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getRequestedSessionId() {
        return this.session.getId();
    }

    public String getRequestURI() {
        return "/";
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer("http://localhost:8080/");
    }

    public String getServletPath() {
        return "";
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        String id = UUID.randomUUID().toString();
        this.session.setId(id);
        return id;
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.partsInt != null) {
            return this.partsInt;
        }
        throw new IllegalStateException("Unable to process parts as no multi-part configuration has been provided");
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this.partsInt == null) {
            throw new IllegalStateException("Unable to process parts as no multi-part configuration has been provided");
        }
        return this.partsInt.get(0);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException("not implemented");
    }
}

