/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest;

import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinSession;
import com.vaadin.testbench.uiunittest.Utils;
import com.vaadin.testbench.uiunittest.testers.AbstractDateFieldTester;
import com.vaadin.testbench.uiunittest.testers.AbstractFieldTester;
import com.vaadin.testbench.uiunittest.testers.AbstractMultiSelectTester;
import com.vaadin.testbench.uiunittest.testers.AbstractSingleSelectTester;
import com.vaadin.testbench.uiunittest.testers.ButtonTester;
import com.vaadin.testbench.uiunittest.testers.ComboBoxTester;
import com.vaadin.testbench.uiunittest.testers.ComponentTester;
import com.vaadin.testbench.uiunittest.testers.GridTester;
import com.vaadin.testbench.uiunittest.testers.MenuBarTester;
import com.vaadin.testbench.uiunittest.testers.TabSheetTester;
import com.vaadin.testbench.uiunittest.testers.TreeGridTester;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractDateField;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.AbstractMultiSelect;
import com.vaadin.ui.AbstractSingleSelect;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.TreeGrid;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractUIUnitTest {
    public abstract UI mockVaadin() throws ServiceException;

    public abstract void mockVaadin(UI var1) throws ServiceException;

    public abstract void tearDown();

    public <T> T navigate(String name, Class<T> clazz) {
        assert (name != null);
        assert (clazz != null);
        assert (UI.getCurrent() != null) : "UI has not been setup";
        Navigator nav = UI.getCurrent().getNavigator();
        assert (nav != null) : "Navigator does not exists";
        nav.navigateTo(name);
        View view = nav.getCurrentView();
        assert (view.getClass().equals(clazz));
        return (T)view;
    }

    public <T extends ClientConnector> QueryResult<T> $(Class<T> clazz) {
        assert (clazz != null);
        assert (UI.getCurrent() != null) : "UI has not been setup";
        if (clazz.isAssignableFrom(Window.class)) {
            return new QueryResult(UI.getCurrent().getWindows());
        }
        if (clazz.equals(Notification.class)) {
            return new QueryResult(UI.getCurrent().getExtensions().stream().filter(ext -> ext.getClass().equals(Notification.class)).collect(Collectors.toList()));
        }
        return this.$((HasComponents)UI.getCurrent(), clazz);
    }

    public <T extends ClientConnector> QueryResult<T> $(HasComponents container, Class<T> clazz) {
        Grid grid;
        assert (container != null && clazz != null);
        QueryResult result = new QueryResult();
        Iterator iter = container.iterator();
        if (container instanceof Grid && (grid = (Grid)container).getEditor().getBinder() != null) {
            List fields = grid.getEditor().getBinder().getFields().filter(field -> clazz.isAssignableFrom(field.getClass())).collect(Collectors.toList());
            result.addAll(fields);
        }
        while (iter.hasNext()) {
            Component component = (Component)iter.next();
            if (clazz.isAssignableFrom(component.getClass())) {
                result.add(component);
            }
            if (!(component instanceof HasComponents)) continue;
            result.addAll(this.$((HasComponents)component, clazz));
        }
        return result;
    }

    public ButtonTester test(Button component) {
        return new ButtonTester(component);
    }

    public <T> ComboBoxTester<T> test(ComboBox<T> component) {
        return new ComboBoxTester<T>(component);
    }

    public <T extends Temporal & TemporalAdjuster & Comparable<? super T>, R extends Enum<R>> AbstractDateFieldTester<T, R> test(AbstractDateField<T, R> component) {
        return new AbstractDateFieldTester<T, R>(component);
    }

    public TabSheetTester test(TabSheet component) {
        return new TabSheetTester(component);
    }

    public <T> GridTester<T> test(Grid<T> component) {
        return new GridTester<T>(component);
    }

    public <T> TreeGridTester<T> test(TreeGrid<T> component) {
        return new TreeGridTester<T>(component);
    }

    public <T> AbstractFieldTester<T> test(AbstractField<T> component) {
        return new AbstractFieldTester<T>(component);
    }

    public <T> AbstractSingleSelectTester<T> test(AbstractSingleSelect<T> component) {
        return new AbstractSingleSelectTester<T>(component);
    }

    public <T> AbstractMultiSelectTester<T> test(AbstractMultiSelect<T> component) {
        return new AbstractMultiSelectTester<T>(component);
    }

    public MenuBarTester test(MenuBar component) {
        return new MenuBarTester(component);
    }

    public ComponentTester test(AbstractComponent component) {
        return new ComponentTester(component);
    }

    public void printComponentTree() {
        Utils.printComponentTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void waitWhile(T param, Predicate<T> condition, int timeout) {
        assert (param != null);
        assert (condition != null);
        assert (VaadinSession.getCurrent().hasLock());
        timeout *= 10;
        VaadinSession.getCurrent().unlock();
        try {
            int i = 0;
            do {
                try {
                    Thread.sleep(100L);
                    ++i;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.testWaitCondition(param, condition) && i < timeout);
        }
        finally {
            VaadinSession.getCurrent().lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean testWaitCondition(T param, Predicate<T> condition) {
        boolean result;
        VaadinSession.getCurrent().lock();
        try {
            result = condition.test(param);
        }
        finally {
            VaadinSession.getCurrent().unlock();
        }
        return result;
    }

    static {
        LicenseChecker.checkLicenseFromStaticBlock((String)"vaadin-testbench", (String)"5.2", null);
    }

    public static class QueryResult<T extends ClientConnector>
    extends ArrayList<T> {
        private static final String NO_CLASS_MATCHES = "No class matches";

        public QueryResult(Collection<T> list) {
            super(list);
        }

        public QueryResult() {
        }

        public T id(String id) {
            if (this.isEmpty()) {
                Utils.printComponentTree();
                throw new AssertionError((Object)NO_CLASS_MATCHES);
            }
            List matching = this.stream().filter(c -> ((Component)c).getId() != null && ((Component)c).getId().equals(id)).collect(Collectors.toList());
            if (matching.size() > 1) {
                Utils.printComponentTree();
                throw new AssertionError((Object)("There are more than one component with id " + id));
            }
            return (T)(matching.isEmpty() ? null : (ClientConnector)matching.get(0));
        }

        public QueryResult<T> styleName(String styleName) {
            if (this.isEmpty()) {
                Utils.printComponentTree();
                throw new AssertionError((Object)NO_CLASS_MATCHES);
            }
            return new QueryResult<T>(this.stream().filter(c -> ((Component)c).getStyleName() == null ? false : ((Component)c).getStyleName().contains(styleName)).collect(Collectors.toList()));
        }

        public QueryResult<T> caption(String caption) {
            if (this.isEmpty()) {
                Utils.printComponentTree();
                throw new AssertionError((Object)NO_CLASS_MATCHES);
            }
            return new QueryResult<T>(this.stream().filter(c -> ((Component)c).getCaption() == null ? false : ((Component)c).getCaption().contains(caption)).collect(Collectors.toList()));
        }

        public T first() {
            if (this.isEmpty()) {
                return null;
            }
            return (T)((ClientConnector)this.get(0));
        }

        public T last() {
            if (this.isEmpty()) {
                return null;
            }
            return (T)((ClientConnector)this.get(this.size() - 1));
        }

        public T single() {
            if (this.isEmpty()) {
                Utils.printComponentTree();
                throw new AssertionError((Object)"There are were no matches");
            }
            if (this.size() > 1) {
                Utils.printComponentTree();
                throw new AssertionError((Object)"There are more than one components");
            }
            return (T)((ClientConnector)this.get(0));
        }
    }
}

