/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.testers;

import com.vaadin.data.provider.HierarchicalDataCommunicator;
import com.vaadin.event.CollapseEvent;
import com.vaadin.event.ExpandEvent;
import com.vaadin.testbench.uiunittest.testers.GridTester;
import com.vaadin.ui.TreeGrid;
import java.util.EventObject;

public class TreeGridTester<T>
extends GridTester<T> {
    public TreeGridTester(TreeGrid<T> grid) {
        super(grid);
    }

    public void clickToggle(T item) {
        assert (this.isInteractable()) : "Can't interact with disabled or invisible TreeGrid";
        if (this.getComponent().isExpanded(item)) {
            assert (this.isCollapseAllowed(item)) : "TreeGrid Collapse not allowed";
            this.collapse(item);
        } else {
            this.expand(item);
        }
    }

    private void expand(T item) {
        HierarchicalDataCommunicator communicator = this.getComponent().getDataCommunicator();
        if (!communicator.isExpanded(item) && communicator.hasChildren(item)) {
            communicator.expand(item);
            this.fireExpandEvent(item);
        }
    }

    private void fireExpandEvent(T item) {
        this.fireSimulatedEvent((EventObject)new ExpandEvent(this.getComponent(), item, true));
    }

    private void collapse(T item) {
        assert (this.isCollapseAllowed(item)) : "TreeGrid Collapse not allowed";
        HierarchicalDataCommunicator communicator = this.getComponent().getDataCommunicator();
        if (communicator.isExpanded(item)) {
            communicator.collapse(item);
            this.fireCollapseEvent(item);
        }
    }

    private boolean isCollapseAllowed(T item) {
        if (this.getComponent().getItemCollapseAllowedProvider() == null) {
            return true;
        }
        return this.getComponent().getItemCollapseAllowedProvider().test(item);
    }

    private void fireCollapseEvent(T item) {
        this.fireSimulatedEvent((EventObject)new CollapseEvent(this.getComponent(), item, true));
    }

    @Override
    protected TreeGrid<T> getComponent() {
        return (TreeGrid)super.getComponent();
    }
}

