/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.testers;

import com.vaadin.testbench.uiunittest.testers.Tester;
import com.vaadin.ui.AbstractSingleSelect;
import com.vaadin.ui.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AbstractSingleSelectTester<T>
extends Tester<AbstractSingleSelect<T>> {
    public AbstractSingleSelectTester(AbstractSingleSelect<T> field) {
        super(field);
    }

    public void clickItem(T item) {
        assert (this.isInteractable()) : "Can't set value to readonly, hidden or disabled field";
        this.setValue(item);
    }

    protected void setValue(T value) {
        if (this.getComponent() instanceof Component.Focusable) {
            this.focus();
        }
        Class<?> clazz = this.getComponent().getClass();
        while (!clazz.equals(AbstractSingleSelect.class)) {
            clazz = clazz.getSuperclass();
        }
        try {
            Method setSelectedItemMethod = clazz.getDeclaredMethod("setSelectedItem", Object.class, Boolean.TYPE);
            setSelectedItemMethod.setAccessible(true);
            setSelectedItemMethod.invoke(this.getComponent(), value, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Failed to invoke AbstractSingleSelect.setSelectedItem reflectively", e);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Override
    public boolean isInteractable() {
        return super.isInteractable() && !this.getComponent().isReadOnly();
    }

    @Override
    protected AbstractSingleSelect<T> getComponent() {
        return (AbstractSingleSelect)super.getComponent();
    }
}

