/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.testers;

import com.vaadin.testbench.uiunittest.testers.HasValue;
import com.vaadin.testbench.uiunittest.testers.Tester;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AbstractFieldTester<T>
extends Tester<AbstractField<T>>
implements HasValue<T> {
    public AbstractFieldTester(AbstractField<T> field) {
        super(field);
    }

    @Override
    public void setValue(T value) {
        assert (this.isInteractable()) : "Can't set value to readonly, hidden or disabled field";
        if (this.getComponent() instanceof Component.Focusable) {
            this.focus();
        }
        Class<?> clazz = this.getComponent().getClass();
        while (!clazz.equals(AbstractField.class)) {
            clazz = clazz.getSuperclass();
        }
        try {
            Method setValueMethod = clazz.getDeclaredMethod("setValue", Object.class, Boolean.TYPE);
            setValueMethod.setAccessible(true);
            setValueMethod.invoke(this.getComponent(), value, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Failed to invoke AbstractField.setValue reflectively", e);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Override
    public boolean isInteractable() {
        return super.isInteractable() && !this.getComponent().isReadOnly();
    }

    @Override
    protected AbstractField<T> getComponent() {
        return (AbstractField)super.getComponent();
    }
}

