/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.mocks;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class MockHttpSession
implements HttpSession,
Serializable {
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private String sessionId = UUID.randomUUID().toString();
    private AtomicBoolean valid = new AtomicBoolean(true);
    private long creationTime = System.currentTimeMillis();
    private int maxInactiveInterval = 1800;
    private ServletContext servletConect;

    public MockHttpSession(ServletContext servletContext) {
        this.servletConect = servletContext;
    }

    public long getCreationTime() {
        this.checkValid();
        return this.creationTime;
    }

    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public ServletContext getServletContext() {
        return this.servletConect;
    }

    public void setMaxInactiveInterval(int interval) {
        this.checkValid();
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        this.checkValid();
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        this.checkValid();
        return this.attributes.get(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        return Collections.enumeration(this.attributes.keySet());
    }

    public String[] getValueNames() {
        this.checkValid();
        Set<String> keySet = this.attributes.keySet();
        String[] keys = new String[keySet.size()];
        return keySet.toArray(keys);
    }

    public void setAttribute(String name, Object value) {
        this.checkValid();
        this.attributes.put(name, value);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkValid();
        this.attributes.remove(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.valid.set(false);
    }

    public boolean isNew() {
        this.checkValid();
        return false;
    }

    private void checkValid() {
        if (!this.valid.get()) {
            throw new IllegalStateException("Invalidated");
        }
    }

    void setId(String id) {
        this.sessionId = id;
    }
}

