/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.testers;

import com.vaadin.event.Action;
import com.vaadin.event.ActionManager;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.ShortcutAction;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashSet;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public abstract class Tester<T extends AbstractComponent> {
    private T component;

    protected Tester(T component) {
        this.component = component;
    }

    public boolean isInteractable() {
        try {
            VaadinSession.getCurrent().unlock();
        }
        finally {
            VaadinSession.getCurrent().lock();
        }
        return this.isEnabled() && this.isVisible();
    }

    private boolean isEnabled() {
        Object currentComponent = this.getComponent();
        if (!currentComponent.isEnabled()) {
            return false;
        }
        while (currentComponent.getParent() != null) {
            if ((currentComponent = currentComponent.getParent()).isEnabled()) continue;
            return false;
        }
        return currentComponent.isEnabled();
    }

    private boolean isVisible() {
        Object currentComponent = this.getComponent();
        if (!currentComponent.isVisible()) {
            return false;
        }
        while (currentComponent.getParent() != null) {
            if ((currentComponent = currentComponent.getParent()).isVisible()) continue;
            return false;
        }
        return currentComponent.isVisible();
    }

    public boolean isInvalid() {
        return this.getComponent().getComponentError() != null;
    }

    public String errorMessage() {
        if (this.getComponent().getComponentError() == null || this.getComponent().getComponentError().getFormattedHtmlMessage() == null) {
            return null;
        }
        Document doc = Jsoup.parse((String)this.getComponent().getComponentError().getFormattedHtmlMessage());
        doc.outputSettings().prettyPrint(false);
        return this.isInvalid() ? doc.text() : null;
    }

    protected void fireSimulatedEvent(EventObject event) {
        this.fireSimulatedEvent((Component)this.component, event);
    }

    private void fireSimulatedEvent(Component component, EventObject event) {
        Class clazz = component.getClass();
        while (!clazz.equals(AbstractClientConnector.class)) {
            clazz = clazz.getSuperclass();
        }
        try {
            Method fireEventMethod = clazz.getDeclaredMethod("fireEvent", EventObject.class);
            fireEventMethod.setAccessible(true);
            fireEventMethod.invoke((Object)component, event);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void focus() {
        assert (this.isInteractable()) : "Cannot focus non-interactable component";
        if (this.getComponent() instanceof Component.Focusable) {
            UI ui = UI.getCurrent();
            Component.Focusable focused = null;
            Component.Focusable focusable = (Component.Focusable)this.getComponent();
            Class<?> clazz = ui.getClass();
            while (!clazz.equals(UI.class)) {
                clazz = clazz.getSuperclass();
            }
            try {
                Field field = clazz.getDeclaredField("pendingFocus");
                field.setAccessible(true);
                focused = (Component.Focusable)field.get(ui);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            if (focused != null && focused.equals((Object)focusable)) {
                return;
            }
            if (focused != null) {
                this.fireSimulatedEvent((Component)focused, (EventObject)new FieldEvents.BlurEvent((Component)focused));
            }
            ((Component.Focusable)this.getComponent()).focus();
            this.fireSimulatedEvent((EventObject)new FieldEvents.FocusEvent((Component)focusable));
        }
    }

    public boolean isFocused() {
        if (this.getComponent() instanceof Component.Focusable) {
            UI ui = UI.getCurrent();
            Component.Focusable focused = null;
            Class<?> clazz = ui.getClass();
            while (!clazz.equals(UI.class)) {
                clazz = clazz.getSuperclass();
            }
            try {
                Field field = clazz.getDeclaredField("pendingFocus");
                field.setAccessible(true);
                focused = (Component.Focusable)field.get(ui);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            return focused == this.getComponent();
        }
        return false;
    }

    public void shortcut(int key) {
        Action[] actions;
        assert (this.isInteractable()) : "Can't send shortcut to non-interactable component";
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("There is no current UI to send the shortcut event to");
        }
        ActionManager am = this.getActionManager();
        for (Action action : actions = am.getActions(this.getComponent(), this.getComponent())) {
            ShortcutAction shortcutAction;
            if (!(action instanceof ShortcutAction) || (shortcutAction = (ShortcutAction)action).getKeyCode() != key || shortcutAction.getModifiers().length != 0) continue;
            am.handleAction((Action)shortcutAction, this.getComponent(), this.getComponent());
        }
    }

    public void shortcut(int key, int ... modifierKeys) {
        Action[] actions;
        assert (this.isInteractable()) : "Can't send shortcut to non-interactable component";
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("There is no current UI to send the shortcut event to");
        }
        ActionManager am = this.getActionManager();
        for (Action action : actions = am.getActions(this.getComponent(), this.getComponent())) {
            ShortcutAction shortcutAction;
            if (!(action instanceof ShortcutAction) || (shortcutAction = (ShortcutAction)action).getKeyCode() != key) continue;
            int[] required = shortcutAction.getModifiers();
            HashSet<Integer> requiredSet = new HashSet<Integer>();
            for (int mod : required) {
                requiredSet.add(mod);
            }
            HashSet<Integer> modifierKeysSet = new HashSet<Integer>();
            for (int mod : modifierKeys) {
                modifierKeysSet.add(mod);
            }
            if (!modifierKeysSet.containsAll(requiredSet)) continue;
            am.handleAction((Action)shortcutAction, this.getComponent(), this.getComponent());
        }
    }

    private ActionManager getActionManager() {
        ActionManager am = null;
        Class<?> clazz = this.getComponent().getClass();
        while (!clazz.equals(AbstractComponent.class)) {
            clazz = clazz.getSuperclass();
        }
        try {
            Method getActionManagerMethod = clazz.getDeclaredMethod("getActionManager", new Class[0]);
            getActionManagerMethod.setAccessible(true);
            am = (ActionManager)getActionManagerMethod.invoke(this.getComponent(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Failed to get ActionManager from component", e);
        }
        return am;
    }

    protected T getComponent() {
        return this.component;
    }
}

