/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.testers;

import com.vaadin.testbench.uiunittest.testers.Tester;
import com.vaadin.ui.Component;
import com.vaadin.ui.TabSheet;
import java.util.Iterator;

public class TabSheetTester
extends Tester<TabSheet> {
    public TabSheetTester(TabSheet tabSheet) {
        super(tabSheet);
    }

    public TabSheet.Tab tab(String caption) {
        for (int i = 0; i < this.getComponent().getComponentCount(); ++i) {
            TabSheet.Tab tab = this.getComponent().getTab(i);
            if (!tab.getCaption().contains(caption)) continue;
            return tab;
        }
        return null;
    }

    public void click(TabSheet.Tab tab) {
        assert (this.isInteractable()) : "Can't interact with disabled or invisible TabSheet";
        assert (tab.isEnabled() && tab.isVisible()) : "Can't interact with disabled or invisible Tab";
        int index = 0;
        for (int i = 0; i < this.getComponent().getComponentCount(); ++i) {
            TabSheet.Tab t = this.getComponent().getTab(i);
            if (!t.equals((Object)tab)) continue;
            index = i;
            break;
        }
        this.click(index);
    }

    public void click(int index) {
        Iterator iter = this.getComponent().iterator();
        Component comp = null;
        int i = 0;
        while (iter.hasNext()) {
            Component c = (Component)iter.next();
            if (i == index) {
                comp = c;
                break;
            }
            ++i;
        }
        this.getComponent().setSelectedTab(comp, true);
    }

    public Component current() {
        return this.getComponent().getSelectedTab();
    }

    @Override
    protected TabSheet getComponent() {
        return (TabSheet)super.getComponent();
    }
}

