/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.testers;

import com.vaadin.shared.ui.datefield.AbstractDateFieldServerRpc;
import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.testbench.uiunittest.testers.AbstractFieldTester;
import com.vaadin.ui.AbstractDateField;
import com.vaadin.ui.UI;
import java.lang.reflect.Field;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.util.HashMap;
import java.util.Locale;

public class AbstractDateFieldTester<T extends Temporal & TemporalAdjuster & Comparable<? super T>, R extends Enum<R>>
extends AbstractFieldTester<T> {
    public AbstractDateFieldTester(AbstractDateField<T, R> field) {
        super(field);
    }

    public void setInput(String value) {
        AbstractDateField<T, R> dateField = this.getComponent();
        assert (this.isInteractable()) : "Can't set value to readonly, hidden or disabled field";
        dateField.focus();
        HashMap<String, Integer> resolutions = new HashMap<String, Integer>();
        String format = dateField.getDateFormat();
        DateTimeFormatter formatter = format == null ? DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(UI.getCurrent().getLocale()) : DateTimeFormatter.ofPattern("yyyy-MM-dd[ HH:mm:ss]", Locale.ENGLISH);
        try {
            TemporalAccessor temporal = formatter.parse(value);
            try {
                LocalDateTime date = LocalDateTime.from(temporal);
                resolutions.put(DateTimeResolution.HOUR.name(), date.getHour());
                resolutions.put(DateTimeResolution.MINUTE.name(), date.getMinute());
                resolutions.put(DateTimeResolution.SECOND.name(), date.getSecond());
                resolutions.put(DateTimeResolution.MONTH.name(), date.getMonthValue());
                resolutions.put(DateTimeResolution.DAY.name(), date.getDayOfMonth());
                resolutions.put(DateTimeResolution.YEAR.name(), date.getYear());
            }
            catch (DateTimeException e) {
                LocalDate date = LocalDate.from(temporal);
                resolutions.put(DateTimeResolution.MONTH.name(), date.getMonthValue());
                resolutions.put(DateTimeResolution.DAY.name(), date.getDayOfMonth());
                resolutions.put(DateTimeResolution.YEAR.name(), date.getYear());
            }
        }
        catch (DateTimeParseException temporal) {
            // empty catch block
        }
        Class<?> clazz = this.getComponent().getClass();
        while (!clazz.equals(AbstractDateField.class)) {
            clazz = clazz.getSuperclass();
        }
        try {
            Field rpcField = clazz.getDeclaredField("rpc");
            rpcField.setAccessible(true);
            AbstractDateFieldServerRpc rpc = (AbstractDateFieldServerRpc)rpcField.get(dateField);
            rpc.update(value, resolutions);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Failed to invoke AbstractDateField's rpc.update reflectively", e);
        }
    }

    @Override
    protected AbstractDateField<T, R> getComponent() {
        return (AbstractDateField)super.getComponent();
    }
}

