/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.mocks;

import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedHttpSession;
import com.vaadin.server.WrappedSession;
import com.vaadin.testbench.uiunittest.mocks.MockHttpSession;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpSession;

public class MockVaadinSession
extends VaadinSession {
    private static final ThreadLocal<MockVaadinSession> referenceKeeper = new ThreadLocal();
    private WrappedSession wrappedSession;
    private MockHttpSession httpSession;
    private int closeCount;
    private ReentrantLock lock = new ReentrantLock();

    public MockVaadinSession(VaadinService service, MockHttpSession httpSession) {
        super(service);
        this.wrappedSession = new WrappedHttpSession((HttpSession)httpSession);
        this.httpSession = httpSession;
    }

    public WrappedSession getSession() {
        return this.wrappedSession;
    }

    public MockHttpSession getHttpSession() {
        return this.httpSession;
    }

    public void close() {
        super.close();
        ++this.closeCount;
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public Lock getLockInstance() {
        return this.lock;
    }

    public void lock() {
        super.lock();
        referenceKeeper.set(this);
    }

    public void unlock() {
        super.unlock();
        referenceKeeper.remove();
    }
}

