/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest;

import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Utils {
    private Utils() {
    }

    public static <T> Set<T> setOfItems(T ... items) {
        HashSet<T> itemSet = new HashSet<T>();
        itemSet.addAll(Arrays.asList(items));
        return itemSet;
    }

    public static <T> List<T> listOfItems(T ... items) {
        ArrayList<T> itemList = new ArrayList<T>();
        itemList.addAll(Arrays.asList(items));
        return itemList;
    }

    public static void printComponentTree() {
        System.out.println("Component tree:");
        Utils.printComponentTree((HasComponents)UI.getCurrent());
        UI.getCurrent().getWindows().forEach(window -> {
            System.out.println("Window: " + window.getClass() + (window.getId() != null ? " id='" + window.getId() + "'" : "") + (window.getCaption() != null ? " caption='" + window.getCaption() + "'" : "") + (window.getStyleName() != null ? " stylename='" + window.getStyleName() + "'" : "") + (window.isVisible() ? " visible" : " invisible") + (window.isEnabled() ? " enabled" : " disabled"));
            Utils.printComponentTree((HasComponents)window);
        });
        List<Notification> notifications = UI.getCurrent().getExtensions().stream().filter(ext -> ext.getClass().equals(Notification.class)).map(ext -> (Notification)ext).collect(Collectors.toList());
        if (!notifications.isEmpty()) {
            System.out.println("Notifications:");
            notifications.forEach(notification -> System.out.println("  " + notification.getClass() + (notification.getCaption() != null ? " caption='" + notification.getCaption() + "'" : "") + (notification.getDescription() != null ? " description='" + notification.getDescription() + "'" : "")));
        }
    }

    private static void printComponentTree(HasComponents container) {
        for (Component component : container) {
            StringBuilder builder = new StringBuilder();
            for (HasComponents parent = component.getParent(); parent != null; parent = parent.getParent()) {
                builder.append("  ");
            }
            System.out.println(builder.toString() + component.getClass() + (component.getId() != null ? " id='" + component.getId() + "'" : "") + (component.getCaption() != null ? " caption='" + component.getCaption() + "'" : "") + (component.getStyleName() != null ? " stylename='" + component.getStyleName() + "'" : "") + (component.isVisible() ? " visible" : " invisible") + (component.isEnabled() ? " enabled" : " disabled"));
            if (!(component instanceof HasComponents)) continue;
            Utils.printComponentTree((HasComponents)component);
        }
    }
}

