/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.uiunittest.mocks;

import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;

import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRegistration.Dynamic;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

/**
 * Mock servlet context for tests.
 *
 * @author Vaadin Ltd
 */
@SuppressWarnings("serial")
public class MockServletContext implements ServletContext, Serializable {

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getContext(java.lang.String)
     */
    @Override
    public ServletContext getContext(String uripath) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getMajorVersion()
     */
    @Override
    public int getMajorVersion() {
        return 4;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getMinorVersion()
     */
    @Override
    public int getMinorVersion() {
        return 0;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getMimeType(java.lang.String)
     */
    @Override
    public String getMimeType(String file) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getResourcePaths(java.lang.String)
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public Set getResourcePaths(String path) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getResource(java.lang.String)
     */
    @Override
    public URL getResource(String path) throws MalformedURLException {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getResourceAsStream(java.lang.String)
     */
    @Override
    public InputStream getResourceAsStream(String path) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getRequestDispatcher(java.lang.String)
     */
    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getNamedDispatcher(java.lang.String)
     */
    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getServlet(java.lang.String)
     */
    @Override
    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getServlets()
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public Enumeration getServlets() {
        return Collections.enumeration(Collections.emptySet());
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getServletNames()
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public Enumeration getServletNames() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#log(java.lang.String)
     */
    @Override
    public void log(String msg) {
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#log(java.lang.Exception,
     * java.lang.String)
     */
    @Override
    public void log(Exception exception, String msg) {
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#log(java.lang.String,
     * java.lang.Throwable)
     */
    @Override
    public void log(String message, Throwable throwable) {
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getRealPath(java.lang.String)
     */
    @Override
    public String getRealPath(String path) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getServerInfo()
     */
    @Override
    public String getServerInfo() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getInitParameter(java.lang.String)
     */
    @Override
    public String getInitParameter(String name) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getInitParameterNames()
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public Enumeration getInitParameterNames() {
        return Collections.enumeration(Collections.emptyList());
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getAttribute(java.lang.String)
     */
    @Override
    public Object getAttribute(String name) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getAttributeNames()
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public Enumeration getAttributeNames() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#setAttribute(java.lang.String,
     * java.lang.Object)
     */
    @Override
    public void setAttribute(String name, Object object) {
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#removeAttribute(java.lang.String)
     */
    @Override
    public void removeAttribute(String name) {
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getServletContextName()
     */
    @Override
    public String getServletContextName() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getContextPath()
     */
    @Override
    public String getContextPath() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getEffectiveMajorVersion()
     */
    @Override
    public int getEffectiveMajorVersion() {
        return 3;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getEffectiveMinorVersion()
     */
    @Override
    public int getEffectiveMinorVersion() {
        return 0;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#setInitParameter(java.lang.String,
     * java.lang.String)
     */
    @Override
    public boolean setInitParameter(String name, String value) {
        return false;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#addServlet(java.lang.String,
     * java.lang.String)
     */
    @Override
    public Dynamic addServlet(String servletName, String className) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#addServlet(java.lang.String,
     * javax.servlet.Servlet)
     */
    @Override
    public Dynamic addServlet(String servletName, Servlet servlet) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#addServlet(java.lang.String,
     * java.lang.Class)
     */
    @Override
    public Dynamic addServlet(String servletName,
            Class<? extends Servlet> servletClass) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#createServlet(java.lang.Class)
     */
    @Override
    public <T extends Servlet> T createServlet(Class<T> clazz)
            throws ServletException {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * javax.servlet.ServletContext#getServletRegistration(java.lang.String)
     */
    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getServletRegistrations()
     */
    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#addFilter(java.lang.String,
     * java.lang.String)
     */
    @Override
    public javax.servlet.FilterRegistration.Dynamic addFilter(String filterName,
            String className) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#addFilter(java.lang.String,
     * javax.servlet.Filter)
     */
    @Override
    public javax.servlet.FilterRegistration.Dynamic addFilter(String filterName,
            Filter filter) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#addFilter(java.lang.String,
     * java.lang.Class)
     */
    @Override
    public javax.servlet.FilterRegistration.Dynamic addFilter(String filterName,
            Class<? extends Filter> filterClass) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#createFilter(java.lang.Class)
     */
    @Override
    public <T extends Filter> T createFilter(Class<T> clazz)
            throws ServletException {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getFilterRegistration(java.lang.String)
     */
    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getFilterRegistrations()
     */
    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getSessionCookieConfig()
     */
    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#setSessionTrackingModes(java.util.Set)
     */
    @Override
    public void setSessionTrackingModes(
            Set<SessionTrackingMode> sessionTrackingModes) {
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getDefaultSessionTrackingModes()
     */
    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getEffectiveSessionTrackingModes()
     */
    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#addListener(java.lang.String)
     */
    @Override
    public void addListener(String className) {
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#addListener(java.util.EventListener)
     */
    @Override
    public <T extends EventListener> void addListener(T t) {
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#addListener(java.lang.Class)
     */
    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#createListener(java.lang.Class)
     */
    @Override
    public <T extends EventListener> T createListener(Class<T> clazz)
            throws ServletException {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getJspConfigDescriptor()
     */
    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#getClassLoader()
     */
    @Override
    public ClassLoader getClassLoader() {
        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.ServletContext#declareRoles(java.lang.String[])
     */
    @Override
    public void declareRoles(String... roleNames) {
    }

    @Override
    public Dynamic addJspFile(String servletName, String jspFile) {
        return null;
    }

    @Override
    public String getVirtualServerName() {
        return "";
    }

    @Override
    public int getSessionTimeout() {
        return 30;
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
    }

    @Override
    public String getRequestCharacterEncoding() {
        return "UTF8";
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) {
    }

    @Override
    public String getResponseCharacterEncoding() {
        return "UTF8";
    }

    @Override
    public void setResponseCharacterEncoding(String encoding) {
    }

}