/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.testers;

import com.vaadin.shared.ui.combobox.ComboBoxServerRpc;
import com.vaadin.testbench.uiunittest.testers.AbstractSingleSelectTester;
import com.vaadin.ui.ComboBox;
import java.lang.reflect.Field;
import java.util.List;

public class ComboBoxTester<T>
extends AbstractSingleSelectTester<T> {
    public ComboBoxTester(ComboBox<T> field) {
        super(field);
    }

    public void setInput(String value) {
        ComboBox<T> comboBox = this.getComponent();
        assert (this.isInteractable()) : "Cannot set input to readonly, disabled or hidden ComboBox";
        assert (comboBox.isTextInputAllowed()) : "ComboBox has filter field disabled";
        comboBox.focus();
        Class<?> clazz = this.getComponent().getClass();
        while (!clazz.equals(ComboBox.class)) {
            clazz = clazz.getSuperclass();
        }
        try {
            Field rpcField = clazz.getDeclaredField("rpc");
            rpcField.setAccessible(true);
            ComboBoxServerRpc rpc = (ComboBoxServerRpc)rpcField.get(comboBox);
            rpc.setFilter(value);
            List items = comboBox.getDataCommunicator().fetchItemsWithRange(0, 2);
            if (items.size() == 1) {
                this.setValue(items.get(0));
            } else if (items.isEmpty() && comboBox.getNewItemProvider() != null) {
                rpc.createNewItem(value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected ComboBox<T> getComponent() {
        return (ComboBox)super.getComponent();
    }
}

