/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest.testers;

import com.vaadin.testbench.uiunittest.testers.Tester;
import com.vaadin.ui.AbstractMultiSelect;
import com.vaadin.ui.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AbstractMultiSelectTester<T>
extends Tester<AbstractMultiSelect<T>> {
    public AbstractMultiSelectTester(AbstractMultiSelect<T> field) {
        super(field);
    }

    public void clickItem(T item) {
        Set value = ((AbstractMultiSelect)this.getComponent()).getValue().stream().map(Objects::requireNonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        if (value.contains(item)) {
            value.remove(item);
            this.setValue(value);
        } else {
            value.add(item);
            this.setValue(value);
        }
    }

    protected void setValue(Set<T> value) {
        assert (this.isInteractable()) : "Can't set value to readonly, hidden or disabled field";
        AbstractMultiSelect field = (AbstractMultiSelect)this.getComponent();
        if (field instanceof Component.Focusable) {
            this.focus();
        }
        Set copy = value.stream().map(Objects::requireNonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        Class<?> clazz = field.getClass();
        while (!clazz.equals(AbstractMultiSelect.class)) {
            clazz = clazz.getSuperclass();
        }
        try {
            Method updateSelectionMethod = clazz.getDeclaredMethod("updateSelection", Set.class, Set.class, Boolean.TYPE);
            updateSelectionMethod.setAccessible(true);
            updateSelectionMethod.invoke((Object)field, copy, new LinkedHashSet(field.getSelectedItems()), true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Failed to invoke AbstractMultiSelect.updateSelection reflectively", e);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Override
    public boolean isInteractable() {
        return super.isInteractable() && !((AbstractMultiSelect)this.getComponent()).isReadOnly();
    }
}

