/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.uiunittest;

import com.vaadin.annotations.Push;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.VaadinServletResponse;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.testbench.uiunittest.AbstractUIUnitTest;
import com.vaadin.testbench.uiunittest.mocks.MockHttpSession;
import com.vaadin.testbench.uiunittest.mocks.MockServletContext;
import com.vaadin.testbench.uiunittest.mocks.MockServletRequest;
import com.vaadin.testbench.uiunittest.mocks.MockServletResponse;
import com.vaadin.testbench.uiunittest.mocks.MockUI;
import com.vaadin.testbench.uiunittest.mocks.MockVaadinService;
import com.vaadin.testbench.uiunittest.mocks.MockVaadinSession;
import com.vaadin.ui.UI;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class UIUnitTest
extends AbstractUIUnitTest {
    private static final String UI_CAN_T_BE_NULL = "UI can't be null";
    private VaadinServletRequest vaadinRequest;
    private VaadinServletResponse vaadinResponse;
    public static final AtomicInteger mockId = new AtomicInteger(1);
    private MockHttpSession session;

    @Override
    public UI mockVaadin() throws ServiceException {
        MockVaadinSession vaadinSession = this.getVaadinSession();
        MockUI ui = new MockUI(vaadinSession);
        this.setUiToSession(vaadinSession, ui);
        MockVaadinService service = (MockVaadinService)vaadinSession.getService();
        this.vaadinRequest = this.getVaadinRequest();
        MockServletResponse response = new MockServletResponse();
        service.setCurrentInstances((VaadinRequest)this.vaadinRequest, (VaadinResponse)new VaadinServletResponse((HttpServletResponse)response, (VaadinServletService)service));
        ui.getPage().init((VaadinRequest)this.vaadinRequest);
        return ui;
    }

    private void setUiToSession(MockVaadinSession vaadinSession, UI ui) {
        UI.setCurrent((UI)ui);
        Class<?> clazz = ui.getClass();
        while (!clazz.equals(UI.class)) {
            clazz = clazz.getSuperclass();
        }
        try {
            Field uiIdField = clazz.getDeclaredField("uiId");
            uiIdField.setAccessible(true);
            uiIdField.set(ui, mockId.getAndIncrement());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Failed to set uiId field", e);
        }
        vaadinSession.addUI(ui);
    }

    @Override
    public void mockVaadin(UI ui) throws ServiceException {
        assert (ui != null) : "UI can't be null";
        MockVaadinSession vaadinSession = this.getVaadinSession();
        ui.setSession((VaadinSession)vaadinSession);
        this.setUiToSession(vaadinSession, ui);
        MockVaadinService service = (MockVaadinService)vaadinSession.getService();
        this.vaadinRequest = this.getVaadinRequest();
        MockServletResponse response = new MockServletResponse();
        this.vaadinResponse = new VaadinServletResponse((HttpServletResponse)response, (VaadinServletService)service);
        service.setCurrentInstances((VaadinRequest)this.vaadinRequest, (VaadinResponse)this.vaadinResponse);
        if (ui.getClass().isAnnotationPresent(Push.class)) {
            Push push = ui.getClass().getAnnotation(Push.class);
            ui.getPushConfiguration().setPushMode(push.value());
            ui.getPushConfiguration().setTransport(push.transport());
        }
        ui.getPage().init((VaadinRequest)this.vaadinRequest);
        Class<?> clazz = ui.getClass();
        try {
            Method initMethod = clazz.getDeclaredMethod("init", VaadinRequest.class);
            initMethod.setAccessible(true);
            initMethod.invoke((Object)ui, this.vaadinRequest);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void tearDown() {
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        UI ui = UI.getCurrent();
        ui.detach();
        ui.close();
        vaadinSession.close();
        VaadinService.getCurrent().setCurrentInstances(null, null);
        VaadinService.setCurrent(null);
        VaadinSession.setCurrent(null);
        UI.setCurrent(null);
        this.session = null;
    }

    protected MockVaadinService getService() throws ServiceException {
        if (VaadinService.getCurrent() == null) {
            MockVaadinService service = new MockVaadinService();
            VaadinService.setCurrent((VaadinService)service);
            return service;
        }
        return (MockVaadinService)VaadinService.getCurrent();
    }

    protected MockHttpSession getSession() {
        if (this.session == null) {
            this.session = new MockHttpSession(new MockServletContext());
        }
        return this.session;
    }

    protected MockVaadinSession getVaadinSession() throws ServiceException {
        if (VaadinSession.getCurrent() == null) {
            MockVaadinSession vaadinSession = new MockVaadinSession((VaadinService)this.getService(), this.getSession());
            vaadinSession.lock();
            VaadinSession.setCurrent((VaadinSession)vaadinSession);
            return vaadinSession;
        }
        return (MockVaadinSession)VaadinSession.getCurrent();
    }

    protected VaadinServletRequest getVaadinRequest() throws ServiceException {
        MockServletRequest request = new MockServletRequest(this.getSession());
        this.vaadinRequest = new VaadinServletRequest((HttpServletRequest)request, (VaadinServletService)this.getVaadinSession().getService());
        return this.vaadinRequest;
    }
}

