/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory;

import com.vaadin.componentfactory.EnhancedDateRangePicker;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import java.io.Serializable;

final class EnhancedDateRangePickerValidationUtil {
    private EnhancedDateRangePickerValidationUtil() {
    }

    static void disableClientValidation(EnhancedDateRangePicker component) {
        if (!component.getElement().getNode().isAttached()) {
            throw new IllegalStateException(String.format("Component %s is not attached. Client side validation can only be disabled for a component when it has been attached to the UI and because it should be called again once the component is removed/added, you should call this method from the onAttach() method of the component.", ((Object)((Object)component)).toString()));
        }
        StateNode componentNode = component.getElement().getNode();
        componentNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(componentNode, (SerializableConsumer & Serializable)executionContext -> EnhancedDateRangePickerValidationUtil.overrideClientValidation(component)));
    }

    private static void overrideClientValidation(EnhancedDateRangePicker component) {
        StringBuilder expression = new StringBuilder("this.validate = function () {return this.checkValidity();};");
        if (component.isInvalid()) {
            expression.append("this.invalid = true;");
        }
        component.getElement().executeJs(expression.toString(), new Object[0]);
    }
}

