/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory;

import com.vaadin.componentfactory.DateRange;
import com.vaadin.componentfactory.EnhancedDateRangePickerPrefixUtil;
import com.vaadin.componentfactory.EnhancedDateRangePickerValidationUtil;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jsoup.internal.StringUtil;
import tools.jackson.databind.ObjectMapper;

@JavaScript.Container(value={@JavaScript(value="./date-fns-limited.min.js"), @JavaScript(value="./enhancedDateRangePickerConnector.js")})
@Tag(value="vcf-date-range-picker")
@NpmPackage(value="@vaadin-component-factory/vcf-date-range-picker", version="6.0.0")
@JsModule(value="@vaadin-component-factory/vcf-date-range-picker/vcf-date-range-picker.js")
public class EnhancedDateRangePicker
extends AbstractSinglePropertyField<EnhancedDateRangePicker, DateRange>
implements HasSize,
HasValidation,
HasComponents,
HasClearButton,
HasLabel {
    private static final String PROP_AUTO_OPEN_DISABLED = "autoOpenDisabled";
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final String PRESET_TODAY = "todayButton";
    public static final String PRESET_YESTERDAY = "yesterdayButton";
    public static final String PRESET_THIS_WEEK = "thisWeekButton";
    public static final String PRESET_LAST_WEEK = "lastWeekButton";
    public static final String PRESET_THIS_MONTH = "thisMonthButton";
    public static final String PRESET_LAST_MONTH = "lastMonthButton";
    public static final String PRESET_THIS_YEAR = "thisYearButton";
    public static final String PRESET_LAST_YEAR = "lastYearButton";
    public static final String PRESET_CANCEL_BUTTON = "cancelButton";
    private DatePickerI18n i18n;
    private static final SerializableFunction<String, DateRange> PARSER = (SerializableFunction & Serializable)s -> {
        DateRange result = null;
        if (s != null && !s.isEmpty() && s.contains(";")) {
            String startDateString = s.split(";", -1)[0];
            String endDateString = s.split(";", -1)[1];
            LocalDate startDate = StringUtil.isBlank((String)startDateString) ? null : LocalDate.parse(startDateString, dateTimeFormatter);
            LocalDate endDate = StringUtil.isBlank((String)endDateString) ? null : LocalDate.parse(endDateString, dateTimeFormatter);
            result = new DateRange(startDate, endDate);
        }
        return result;
    };
    private static final SerializableFunction<DateRange, String> FORMATTER = (SerializableFunction & Serializable)d -> {
        String result = "";
        if (d != null) {
            result = String.format("%s;%s", d.getStartDate() == null ? "" : dateTimeFormatter.format(d.getStartDate()), d.getEndDate() == null ? "" : dateTimeFormatter.format(d.getEndDate()));
        }
        return result;
    };
    private static final SerializableFunction<String, LocalDate> DATE_PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : LocalDate.parse(s);
    private static final SerializableFunction<LocalDate, String> DATE_FORMATTER = (SerializableFunction & Serializable)d -> d == null ? "" : d.toString();
    private Locale locale;
    private String languageTag;
    private LocalDate max;
    private LocalDate min;
    private boolean required;
    private String formattingPattern;
    private String[] parserPatterns;

    public EnhancedDateRangePicker() {
        this(new DateRange(null, null));
    }

    public EnhancedDateRangePicker(DateRange initialDate) {
        super("value", (Object)initialDate, String.class, PARSER, FORMATTER);
        this.setPattern("yyyy-MM-dd");
        this.setParsers("yyyy-MM-dd");
        if (this.getElement().getProperty("value") == null) {
            this.setPresentationValue(initialDate);
        }
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public EnhancedDateRangePicker(String label) {
        this();
        this.setLabel(label);
    }

    public EnhancedDateRangePicker(String label, DateRange initialDate) {
        this(initialDate);
        this.setLabel(label);
    }

    public EnhancedDateRangePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<EnhancedDateRangePicker, DateRange>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public EnhancedDateRangePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<EnhancedDateRangePicker, DateRange>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public EnhancedDateRangePicker(DateRange initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<EnhancedDateRangePicker, DateRange>> listener) {
        this(initialDate);
        this.addValueChangeListener(listener);
    }

    public EnhancedDateRangePicker(String label, DateRange initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<EnhancedDateRangePicker, DateRange>> listener) {
        this(initialDate);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public EnhancedDateRangePicker(DateRange initialDate, Locale locale) {
        this(initialDate);
        this.setLocale(locale);
    }

    public EnhancedDateRangePicker(DateRange initialDate, String formattingPattern) {
        this(initialDate);
        this.setPattern(formattingPattern);
    }

    public EnhancedDateRangePicker(DateRange initialDate, String formattingPattern, String ... parserPatterns) {
        this(initialDate);
        this.setPattern(formattingPattern);
        this.setParsers(parserPatterns);
    }

    @Deprecated
    public void disableClientValidation() {
        EnhancedDateRangePickerValidationUtil.disableClientValidation(this);
    }

    public void setMin(LocalDate min) {
        String minAsString = (String)DATE_FORMATTER.apply((Object)min);
        this.getElement().setProperty("min", minAsString == null ? "" : minAsString);
        this.min = min;
    }

    public LocalDate getMin() {
        return (LocalDate)DATE_PARSER.apply((Object)this.getElement().getProperty("min"));
    }

    public void setMax(LocalDate max) {
        String maxAsString = (String)DATE_FORMATTER.apply((Object)max);
        this.getElement().setProperty("max", maxAsString == null ? "" : maxAsString);
        this.max = max;
    }

    public LocalDate getMax() {
        return (LocalDate)DATE_PARSER.apply((Object)this.getElement().getProperty("max"));
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.languageTag = !locale.toLanguageTag().contains("lvariant") ? locale.toLanguageTag() : (locale.getCountry().isEmpty() ? locale.getLanguage() : locale.getLanguage() + "-" + locale.getCountry());
        this.getUI().ifPresent(ui -> this.setLocaleWithJS());
    }

    private void setLocaleWithJS() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setLocale", new Object[]{this.languageTag}));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setParsers(String ... parserPatterns) {
        this.parserPatterns = parserPatterns;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setParsers", (Serializable[])parserPatterns));
    }

    public String[] getParsers() {
        return this.parserPatterns;
    }

    public void setPattern(String formattingPattern) {
        this.formattingPattern = formattingPattern;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setPattern", new Object[]{formattingPattern}));
    }

    public void setClassNameForDates(String className, LocalDate ... dates) {
        Object datesString = Arrays.asList(dates).stream().map(adate -> "'" + adate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "'").collect(Collectors.joining(","));
        datesString = "[" + (String)datesString + "]";
        this.getElement().executeJs("this.setClassNameForDates($0," + (String)datesString + ")", new Object[]{className});
    }

    public String getPattern() {
        return this.formattingPattern;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        if (this.locale == null) {
            this.getUI().ifPresent(ui -> this.setLocale(ui.getLocale()));
        } else if (this.languageTag != null) {
            this.setLocaleWithJS();
        }
        if (this.i18n != null) {
            this.setI18nWithJS();
        }
        if (this.formattingPattern != null) {
            this.setPattern(this.formattingPattern);
        }
        EnhancedDateRangePickerValidationUtil.disableClientValidation(this);
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.enhancedDateRangePickerConnector.initLazy($0)", new Object[]{this.getElement()}));
    }

    public DatePickerI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.getUI().ifPresent(ui -> this.setI18nWithJS());
    }

    private void setI18nWithJS() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            ObjectMapper mapper = new ObjectMapper();
            Map i18nMap = (Map)mapper.convertValue((Object)this.i18n, Map.class);
            i18nMap.forEach((key, value) -> this.getElement().executeJs("this.set('i18n." + key + "', $0)", new Object[]{value}));
        });
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage == null ? "" : errorMessage);
    }

    public String getErrorMessage() {
        return this.getElement().getProperty("errorMessage");
    }

    public void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    public boolean isInvalid() {
        return this.getElement().getProperty("invalid", false);
    }

    private boolean isInvalid(DateRange value) {
        boolean isRequiredButEmpty = this.required && Objects.equals(this.getEmptyValue(), value);
        boolean isGreaterThanMax = value != null && value.getStartDate() != null && this.max != null && value.getStartDate().isAfter(this.max);
        boolean isSmallerThenMin = value != null && value.getStartDate() != null && this.min != null && value.getStartDate().isBefore(this.min);
        boolean startDateInvalid = isRequiredButEmpty || isGreaterThanMax || isSmallerThenMin;
        isRequiredButEmpty = this.required && Objects.equals(this.getEmptyValue(), value);
        isGreaterThanMax = value != null && value.getEndDate() != null && this.max != null && value.getEndDate().isAfter(this.max);
        isSmallerThenMin = value != null && value.getEndDate() != null && this.min != null && value.getEndDate().isBefore(this.min);
        boolean endDateInvalid = isRequiredButEmpty || isGreaterThanMax || isSmallerThenMin;
        boolean endDateBeforeStartDate = value != null && value.getStartDate() != null && value.getEndDate() != null && value.getEndDate().isBefore(value.getStartDate());
        return startDateInvalid || endDateInvalid || endDateBeforeStartDate;
    }

    public void setSidePanelVisible(boolean sidePanelVisible) {
        this.getElement().setProperty("hideSidePanel", !sidePanelVisible);
    }

    public boolean isTextFieldsVisible() {
        return !this.getElement().getProperty("hideTextFields", false);
    }

    public void setTextFieldsVisible(boolean textFieldsVisible) {
        this.getElement().setProperty("hideTextFields", !textFieldsVisible);
    }

    public boolean isSidePanelVisible() {
        return !this.getElement().getProperty("hideSidePanel", false);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setPlaceholder(String placeholder) {
        this.getElement().setProperty("placeholder", placeholder == null ? "" : placeholder);
    }

    protected void setEndPlaceholder(String endPlaceholder) {
        this.getElement().setProperty("endPlaceholder", endPlaceholder == null ? "" : endPlaceholder);
    }

    public String getPlaceholder() {
        return this.getElement().getProperty("placeholder");
    }

    protected String getEndPlaceholder() {
        return this.getElement().getProperty("endPlaceholder");
    }

    public void setInitialPosition(LocalDate initialPosition) {
        String initialPositionString = (String)DATE_FORMATTER.apply((Object)initialPosition);
        this.getElement().setProperty("initialPosition", initialPositionString == null ? "" : initialPositionString);
    }

    public LocalDate getInitialPosition() {
        return (LocalDate)DATE_PARSER.apply((Object)this.getElement().getProperty("initialPosition"));
    }

    public void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
        this.required = required;
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
        this.required = required;
    }

    public boolean isRequired() {
        return this.getElement().getProperty("required", false);
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.getElement().setProperty("showWeekNumbers", weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.getElement().getProperty("showWeekNumbers", false);
    }

    void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    public void open() {
        this.setOpened(true);
    }

    public void openOnPosition(int x, int y) {
        this.getElement().executeJs("this.openOnPosition($0,$1)", new Object[]{x, y});
    }

    protected void close() {
        this.setOpened(false);
    }

    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty(PROP_AUTO_OPEN_DISABLED, !autoOpen);
    }

    public boolean isAutoOpen() {
        return !this.getElement().getProperty(PROP_AUTO_OPEN_DISABLED, false);
    }

    public void setName(String name) {
        this.getElement().setProperty("name", name == null ? "" : name);
    }

    protected void validate() {
        this.setInvalid(this.isInvalid((DateRange)this.getValue()));
    }

    public String getName() {
        return this.getElement().getProperty("name");
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    public Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent> listener) {
        return this.addListener(InvalidChangeEvent.class, listener);
    }

    public void setPrefixComponent(Component component) {
        EnhancedDateRangePickerPrefixUtil.setPrefixComponent((Component)this, component);
    }

    public Component getPrefixComponent() {
        return EnhancedDateRangePickerPrefixUtil.getPrefixComponent((Component)this);
    }

    public void removeAll() {
        this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
    }

    public void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + String.valueOf(component) + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    public void add(Component ... components) {
        super.add(components);
        for (Component component : components) {
            component.getElement().setAttribute("slot", "presets");
        }
    }

    public void removePresetByIds(String ... ids) {
        for (String id : ids) {
            this.getElement().executeJs("this.removePreselectionById($0)", new Object[]{id});
        }
    }

    public void setValue(DateRange value) {
        if (value == null) {
            this.getElement().executeJs("this.value = 'null;null';", new Object[0]);
        }
        super.setValue((Object)value);
    }

    public DateRange getEmptyValue() {
        return null;
    }

    public static class DatePickerI18n
    implements Serializable {
        private List<String> monthNames;
        private List<String> weekdays;
        private List<String> weekdaysShort;
        private int firstDayOfWeek;
        private String week;
        private String calendar;
        private String clear;
        private String today;
        private String cancel;
        private String yesterday;
        private String thisWeek;
        private String lastWeek;
        private String thisMonth;
        private String lastMonth;
        private String thisYear;
        private String lastYear;

        public List<String> getMonthNames() {
            return this.monthNames;
        }

        public String getLastYear() {
            return this.lastYear;
        }

        public DatePickerI18n setLastYear(String lastYear) {
            this.lastYear = lastYear;
            return this;
        }

        public String getThisYear() {
            return this.thisYear;
        }

        public DatePickerI18n setThisYear(String thisYear) {
            this.thisYear = thisYear;
            return this;
        }

        public String getLastMonth() {
            return this.lastMonth;
        }

        public DatePickerI18n setLastMonth(String lastMonth) {
            this.lastMonth = lastMonth;
            return this;
        }

        public String getThisMonth() {
            return this.thisMonth;
        }

        public DatePickerI18n setThisMonth(String thisMonth) {
            this.thisMonth = thisMonth;
            return this;
        }

        public String getLastWeek() {
            return this.lastWeek;
        }

        public DatePickerI18n setLastWeek(String lastWeek) {
            this.lastWeek = lastWeek;
            return this;
        }

        public String getThisWeek() {
            return this.thisWeek;
        }

        public DatePickerI18n setThisWeek(String thisWeek) {
            this.thisWeek = thisWeek;
            return this;
        }

        public String getYesterday() {
            return this.yesterday;
        }

        public DatePickerI18n setYesterday(String yesterday) {
            this.yesterday = yesterday;
            return this;
        }

        public DatePickerI18n setMonthNames(List<String> monthNames) {
            this.monthNames = monthNames;
            return this;
        }

        public List<String> getWeekdays() {
            return this.weekdays;
        }

        public DatePickerI18n setWeekdays(List<String> weekdays) {
            this.weekdays = weekdays;
            return this;
        }

        public List<String> getWeekdaysShort() {
            return this.weekdaysShort;
        }

        public DatePickerI18n setWeekdaysShort(List<String> weekdaysShort) {
            this.weekdaysShort = weekdaysShort;
            return this;
        }

        public int getFirstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        public DatePickerI18n setFirstDayOfWeek(int firstDayOfWeek) {
            this.firstDayOfWeek = firstDayOfWeek;
            return this;
        }

        public String getWeek() {
            return this.week;
        }

        public DatePickerI18n setWeek(String week) {
            this.week = week;
            return this;
        }

        public String getCalendar() {
            return this.calendar;
        }

        public DatePickerI18n setCalendar(String calendar) {
            this.calendar = calendar;
            return this;
        }

        public String getClear() {
            return this.clear;
        }

        public DatePickerI18n setClear(String clear) {
            this.clear = clear;
            return this;
        }

        public String getToday() {
            return this.today;
        }

        public DatePickerI18n setToday(String today) {
            this.today = today;
            return this;
        }

        public String getCancel() {
            return this.cancel;
        }

        public DatePickerI18n setCancel(String cancel) {
            this.cancel = cancel;
            return this;
        }
    }

    public static class OpenedChangeEvent
    extends ComponentEvent<EnhancedDateRangePicker> {
        private final boolean opened;

        public OpenedChangeEvent(EnhancedDateRangePicker source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }

    public static class InvalidChangeEvent
    extends ComponentEvent<EnhancedDateRangePicker> {
        private final boolean invalid;

        public InvalidChangeEvent(EnhancedDateRangePicker source, boolean fromClient) {
            super((Component)source, fromClient);
            this.invalid = source.isInvalid();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }
}

