/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.selectiongrid;

import com.vaadin.componentfactory.selectiongrid.SelectionGridVariant;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionModel;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="vaadin-selection-grid")
@CssImport(value="./styles/grid.css", themeFor="vaadin-selection-grid")
@JsModule.Container(value={@JsModule(value="./src/vcf-selection-grid.js"), @JsModule(value="./src/selection-grid.js")})
public class SelectionTreeGrid<T>
extends TreeGrid<T> {
    private boolean multiSelectionColumnVisible = false;
    private boolean persistentCheckboxSelection = true;
    private T rangeStartItem;

    public SelectionTreeGrid() {
    }

    public SelectionTreeGrid(Class<T> beanType) {
        super(beanType);
    }

    public SelectionTreeGrid(HierarchicalDataProvider<T, ?> dataProvider) {
        super(dataProvider);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getSelectionModel() instanceof SelectionModel.Multi) {
            this.setMultiSelectionColumnVisible(this.multiSelectionColumnVisible);
        }
    }

    public void focusOnCell(T item) {
        this.focusOnCell(item, null);
    }

    public void focusOnCell(T item, Grid.Column<T> column) {
        int colIndex = column != null ? this.getColumns().indexOf(column) : 0;
        this.getElement().callJsFunction("focusOnCellAfterScroll", new Object[]{colIndex});
        this.scrollToItem(item);
    }

    @ClientCallable
    private void selectionTreeGridToggleItem(String itemKey, boolean selected, ObjectNode options) {
        if (this.getSelectionMode() != Grid.SelectionMode.MULTI) {
            return;
        }
        Object item = this.getDataCommunicator().getKeyMapper().get(itemKey);
        if (item == null) {
            throw new IllegalArgumentException("Item with key %s not found".formatted(itemKey));
        }
        if (selected) {
            boolean deselectOthers = options.get("deselectOthers").asBoolean(false);
            if (deselectOthers) {
                this.asMultiSelect().setValue(Set.of(item));
            } else {
                this.select(item);
            }
        } else {
            this.deselect(item);
        }
        this.rangeStartItem = item;
    }

    @ClientCallable
    private void selectionTreeGridSelectRange(String endItemKey, ObjectNode options) {
        if (this.getSelectionMode() != Grid.SelectionMode.MULTI) {
            return;
        }
        Object rangeEndItem = this.getDataCommunicator().getKeyMapper().get(endItemKey);
        if (rangeEndItem == null) {
            throw new IllegalArgumentException("Item with key %s not found".formatted(endItemKey));
        }
        List<Object> range = this.fetchRange(this.rangeStartItem, rangeEndItem);
        boolean deselectOthers = options.get("deselectOthers").asBoolean(false);
        if (deselectOthers) {
            this.asMultiSelect().setValue(new HashSet<Object>(range));
        } else {
            this.asMultiSelect().select(range);
        }
    }

    private List<T> fetchRange(T startItem, T endItem) {
        List<Object> items = this.fetchHierarchyRecursively(null);
        int startIndex = items.indexOf(startItem);
        int endIndex = items.indexOf(endItem);
        return items.subList(Math.min(startIndex, endIndex), Math.max(startIndex, endIndex) + 1);
    }

    protected void setSelectionModel(GridSelectionModel<T> model, Grid.SelectionMode selectionMode) {
        if (selectionMode == Grid.SelectionMode.MULTI) {
            this.setMultiSelectionColumnVisible(this.multiSelectionColumnVisible);
        }
        super.setSelectionModel(model, selectionMode);
    }

    protected void hideMultiSelectionColumn() {
        this.setMultiSelectionColumnVisible(false);
    }

    public Grid.Column<T> addHierarchyColumn(ValueProvider<T, ?> valueProvider) {
        Grid.Column column = this.addColumn((Renderer)LitRenderer.of((String)"<vaadin-grid-tree-toggle @click=${onClick} .leaf=${!item.children} .expanded=${model.expanded} .level=${model.level}></vaadin-grid-tree-toggle>${item.name}").withProperty("children", (ValueProvider & Serializable)item -> this.getDataCommunicator().hasChildren(item)).withProperty("name", (ValueProvider & Serializable)value -> String.valueOf(valueProvider.apply(value))).withFunction("onClick", (SerializableConsumer & Serializable)item -> {
            if (this.getDataCommunicator().hasChildren(item)) {
                if (this.isExpanded(item)) {
                    this.collapse(List.of(item), true);
                } else {
                    this.expand(List.of(item), true);
                }
            }
        }));
        SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(a, b) -> SelectionTreeGrid.compareMaybeComparables((Object)valueProvider.apply(a), (Object)valueProvider.apply(b));
        column.setComparator((Comparator)comparator);
        return column;
    }

    public void addThemeVariants(SelectionGridVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(SelectionGridVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(SelectionGridVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(SelectionGridVariant::getVariantName).collect(Collectors.toList()));
    }

    public boolean isMultiSelectionColumnVisible() {
        return this.multiSelectionColumnVisible;
    }

    public void setMultiSelectionColumnVisible(boolean multiSelectionColumnVisible) {
        if (this.getSelectionModel() instanceof SelectionModel.Multi) {
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.getElement().executeJs("if (this.querySelector('vaadin-grid-flow-selection-column')) { this.querySelector('vaadin-grid-flow-selection-column').hidden = $0 }", new Object[]{!multiSelectionColumnVisible});
                this.recalculateColumnWidths();
            }));
        }
        this.multiSelectionColumnVisible = multiSelectionColumnVisible;
    }

    public boolean isPersistentCheckboxSelection() {
        return this.persistentCheckboxSelection;
    }

    public void setPersistentCheckboxSelection(boolean persistentCheckboxSelection) {
        this.getElement().executeJs("this.classicCheckboxSelection = $0", new Object[]{!persistentCheckboxSelection});
        this.persistentCheckboxSelection = persistentCheckboxSelection;
    }

    private List<T> fetchHierarchyRecursively(T parent) {
        HierarchicalDataCommunicator dataCommunicator = this.getDataCommunicator();
        HierarchicalDataProvider dataProvider = dataCommunicator.getDataProvider();
        HierarchicalQuery query = dataCommunicator.buildQuery(parent, 0, Integer.MAX_VALUE);
        ArrayList result = new ArrayList();
        dataProvider.fetchChildren(query).forEach(child -> {
            result.add(child);
            if (dataProvider.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.NESTED) && dataCommunicator.isExpanded(child)) {
                result.addAll(this.fetchHierarchyRecursively(child));
            }
        });
        return result;
    }
}

