/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.selectiongrid;

import com.vaadin.componentfactory.selectiongrid.SelectionGridVariant;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.selection.SelectionModel;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-selection-grid")
@CssImport(value="./styles/grid.css", themeFor="vaadin-selection-grid")
@JsModule.Container(value={@JsModule(value="./src/vcf-selection-grid.js"), @JsModule(value="./src/selection-grid.js")})
public class SelectionGrid<T>
extends Grid<T> {
    private Integer selectRangeOnlyFromIndex = null;
    private Set<T> selectRangeOnlySelection = new HashSet<T>();
    private boolean multiSelectionColumnVisible = false;
    private boolean persistentCheckboxSelection = true;

    public SelectionGrid() {
    }

    public SelectionGrid(int pageSize) {
        super(pageSize);
    }

    public SelectionGrid(Class<T> beanType, boolean autoCreateColumns) {
        super(beanType, autoCreateColumns);
    }

    public SelectionGrid(Class<T> beanType) {
        super(beanType);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getSelectionModel() instanceof SelectionModel.Multi) {
            this.setMultiSelectionColumnVisible(this.multiSelectionColumnVisible);
        }
    }

    public void scrollToIndex(int rowIndex) {
        super.scrollToIndex(rowIndex);
    }

    public void focusOnCell(T item) {
        this.focusOnCell(item, null);
    }

    public void focusOnCell(T item, Grid.Column<T> column) {
        int index = this.getIndexForItem(item);
        if (index > 0) {
            int colIndex = column != null ? this.getColumns().indexOf(column) : 0;
            this.getElement().callJsFunction("focusOnCellAfterScroll", new Object[]{colIndex});
            this.scrollToIndex(index);
        }
    }

    private int getIndexForItem(T item) {
        return this.getItemsInOrder().indexOf(item);
    }

    private List<T> getItemsInOrder() {
        DataCommunicator dataCommunicator = super.getDataCommunicator();
        try {
            Method fetchFromProvider = DataCommunicator.class.getDeclaredMethod("fetchFromProvider", Integer.TYPE, Integer.TYPE);
            Method getDataProviderSize = DataCommunicator.class.getDeclaredMethod("getDataProviderSize", new Class[0]);
            fetchFromProvider.setAccessible(true);
            getDataProviderSize.setAccessible(true);
            int size = (Integer)getDataProviderSize.invoke((Object)dataCommunicator, new Object[0]);
            return ((Stream)fetchFromProvider.invoke((Object)dataCommunicator, 0, size)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            return new ArrayList();
        }
    }

    private String getColumnInternalId(Grid.Column<T> column) {
        try {
            Method getInternalId = Grid.Column.class.getDeclaredMethod("getInternalId", new Class[0]);
            getInternalId.setAccessible(true);
            return (String)getInternalId.invoke(column, new Object[0]);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            throw new IllegalArgumentException("getInternalId");
        }
    }

    @ClientCallable
    private void selectRange(int fromIndex, int toIndex) {
        GridSelectionModel model = this.getSelectionModel();
        if (model instanceof GridMultiSelectionModel) {
            this.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
                Set<T> newSelectedItems = this.obtainNewSelectedItems(fromIndex, toIndex);
                this.asMultiSelect().select(newSelectedItems);
            }));
        }
    }

    private Set<T> obtainNewSelectedItems(int fromIndex, int toIndex) {
        int pageSize;
        DataCommunicator dataCommunicator = super.getDataCommunicator();
        HashSet<Object> newSelectedItems = new HashSet<Object>();
        int from = Math.min(fromIndex, toIndex);
        int to = Math.max(fromIndex, toIndex) + 1;
        if (to - from < (pageSize = dataCommunicator.getPageSize()) * 2 - 3) {
            for (int i = from; i < to; ++i) {
                newSelectedItems.add(dataCommunicator.getItem(i));
            }
        } else {
            try {
                Method fetchFromProvider = DataCommunicator.class.getDeclaredMethod("fetchFromProvider", Integer.TYPE, Integer.TYPE);
                fetchFromProvider.setAccessible(true);
                newSelectedItems.addAll(((Stream)fetchFromProvider.invoke((Object)dataCommunicator, from, to - from + 1)).collect(Collectors.toList()));
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        return newSelectedItems;
    }

    @ClientCallable
    private void selectRangeOnly(int fromIndex, int toIndex) {
        int start = fromIndex < toIndex ? fromIndex : toIndex;
        int end = fromIndex < toIndex ? toIndex : fromIndex;
        GridSelectionModel model = this.getSelectionModel();
        if (model instanceof GridMultiSelectionModel) {
            HashSet<T> newSelectedItems = new HashSet<T>();
            int calculatedFromIndex = start;
            if (!this.selectRangeOnlySelection.isEmpty()) {
                int firstKey = this.selectRangeOnlyFromIndex;
                int lastKey = firstKey + this.selectRangeOnlySelection.size() - 1;
                if (start == firstKey && end > lastKey) {
                    calculatedFromIndex = lastKey;
                    newSelectedItems.addAll(this.selectRangeOnlySelection);
                }
            }
            int calculatedFromIndexFinal = calculatedFromIndex;
            this.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
                newSelectedItems.addAll(this.obtainNewSelectedItems(calculatedFromIndexFinal, end));
                HashSet oldSelectedItems = new HashSet(this.getSelectedItems());
                oldSelectedItems.removeAll(newSelectedItems);
                this.asMultiSelect().updateSelection(newSelectedItems, oldSelectedItems);
            }));
            this.selectRangeOnlySelection = new HashSet<T>(this.getSelectedItems());
            this.selectRangeOnlyFromIndex = fromIndex;
        }
    }

    @ClientCallable
    private void selectRangeOnlyOnClick(int fromIndex, int toIndex) {
        this.selectRangeOnlySelection.clear();
        this.selectRangeOnlyFromIndex = null;
        this.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> this.selectRangeOnly(fromIndex, toIndex)));
    }

    private Optional<Stream<T>> fetchFromProvider(int offset, int limit) {
        DataCommunicator dataCommunicator = super.getDataCommunicator();
        int padding = 0;
        int originalLimit = limit;
        if (dataCommunicator.isPagingEnabled()) {
            int end = offset + limit;
            while (true) {
                int updatedOffset;
                if ((updatedOffset = offset - (padding = offset % limit)) + limit >= end && updatedOffset + limit <= dataCommunicator.getItemCount()) {
                    offset = updatedOffset;
                    break;
                }
                ++limit;
            }
        }
        try {
            Method fetchFromProvider = DataCommunicator.class.getDeclaredMethod("fetchFromProvider", Integer.TYPE, Integer.TYPE);
            fetchFromProvider.setAccessible(true);
            Stream stream = (Stream)fetchFromProvider.invoke((Object)dataCommunicator, offset, limit);
            return Optional.of(stream.skip(padding).limit(originalLimit));
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return Optional.empty();
        }
    }

    protected void setSelectionModel(GridSelectionModel<T> model, Grid.SelectionMode selectionMode) {
        if (selectionMode == Grid.SelectionMode.MULTI && !this.multiSelectionColumnVisible) {
            this.hideMultiSelectionColumn();
        }
        super.setSelectionModel(model, selectionMode);
    }

    protected void hideMultiSelectionColumn() {
        this.setMultiSelectionColumnVisible(false);
    }

    public void addThemeVariants(SelectionGridVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(SelectionGridVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(SelectionGridVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(SelectionGridVariant::getVariantName).collect(Collectors.toList()));
    }

    public boolean isMultiSelectionColumnVisible() {
        return this.multiSelectionColumnVisible;
    }

    public void setMultiSelectionColumnVisible(boolean multiSelectionColumnVisible) {
        if (this.getSelectionModel() instanceof SelectionModel.Multi) {
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.getElement().executeJs("if (this.querySelector('vaadin-grid-flow-selection-column')) { this.querySelector('vaadin-grid-flow-selection-column').hidden = $0 }", new Object[]{!multiSelectionColumnVisible});
                this.recalculateColumnWidths();
            }));
        }
        this.multiSelectionColumnVisible = multiSelectionColumnVisible;
    }

    public boolean isPersistentCheckboxSelection() {
        return this.persistentCheckboxSelection;
    }

    public void setPersistentCheckboxSelection(boolean persistentCheckboxSelection) {
        this.getElement().executeJs("this.classicCheckboxSelection = $0", new Object[]{!persistentCheckboxSelection});
        this.persistentCheckboxSelection = persistentCheckboxSelection;
    }
}

