/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import java.io.Serializable;
import java.util.Objects;

@Tag(value="vcf-popup")
@NpmPackage(value="@vaadin-component-factory/vcf-popup", version="1.2.8")
@JsModule.Container(value={@JsModule(value="./flow-component-renderer.js"), @JsModule(value="@vaadin-component-factory/vcf-popup/src/vcf-popup.js")})
public class Popup
extends PolymerTemplate<PopupModel> {
    private Element template = new Element("template");
    private Element container = new Element("div");

    public Popup() {
        this.getElement().appendVirtualChild(new Element[]{this.container});
        this.setOpened(false);
    }

    public Registration addPopupOpenChangedEventListener(ComponentEventListener<PopupOpenChangedEvent> listener) {
        return this.addListener(PopupOpenChangedEvent.class, listener);
    }

    public void show() {
        this.getElement().callJsFunction("show", new Serializable[0]);
    }

    public void hide() {
        this.getElement().callJsFunction("hide", new Serializable[0]);
    }

    public void setOpened(boolean opened) {
        ((PopupModel)this.getModel()).setOpened(opened);
        if (this.template.getProperty("innerHTML", false)) {
            if (opened) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    public boolean isOpened() {
        return ((PopupModel)this.getModel()).isOpened();
    }

    public void setFor(String id) {
        ((PopupModel)this.getModel()).setFor(id);
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.getElement().appendChild(new Element[]{this.template});
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.attachComponentRenderer()));
        String id = ((PopupModel)this.getModel()).getFor();
        if (this.template.getProperty("innerHTML", false)) {
            if (id == null) {
                this.getElement().callJsFunction("disconnectedCallback", new Serializable[0]);
            } else {
                this.getElement().callJsFunction("connectedCallback", new Serializable[0]);
            }
        }
    }

    public String getFor() {
        return ((PopupModel)this.getModel()).getFor();
    }

    public void setCloseOnClick(boolean close) {
        ((PopupModel)this.getModel()).setCloseOnClick(close);
    }

    public boolean isCloseOnClick() {
        return ((PopupModel)this.getModel()).isCloseOnClick();
    }

    public void add(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to add cannot be null");
            this.container.appendChild(new Element[]{component.getElement()});
        }
    }

    public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to remove cannot be null");
            if (!this.container.equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            this.container.removeChild(new Element[]{component.getElement()});
        }
    }

    public void removeAll() {
        this.container.removeAllChildren();
    }

    public void addComponentAtIndex(int index, Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a component with a negative index");
        }
        this.container.insertChild(index, new Element[]{component.getElement()});
    }

    private void attachComponentRenderer() {
        String appId = UI.getCurrent().getInternals().getAppId();
        int nodeId = this.container.getNode().getId();
        String renderer = String.format("<flow-component-renderer appid=\"%s\" nodeid=\"%s\"></flow-component-renderer>", appId, nodeId);
        this.template.setProperty("innerHTML", renderer);
        if (this.isOpened()) {
            this.show();
        }
    }

    public boolean isModeless() {
        return ((PopupModel)this.getModel()).isModeless();
    }

    public void setModeless(boolean modeless) {
        ((PopupModel)this.getModel()).setModeless(modeless);
    }

    @DomEvent(value="popup-open-changed")
    public static class PopupOpenChangedEvent
    extends ComponentEvent<Popup> {
        private boolean opened;

        public PopupOpenChangedEvent(Popup source, boolean fromClient, @EventData(value="event.detail.opened") boolean opened) {
            super((Component)source, fromClient);
            this.opened = opened;
        }

        public boolean isOpened() {
            return this.opened;
        }
    }

    public static interface PopupModel
    extends TemplateModel {
        public void setOpened(boolean var1);

        public boolean isOpened();

        public void setFor(String var1);

        public String getFor();

        public void setCloseOnClick(boolean var1);

        public boolean isCloseOnClick();

        public boolean isModeless();

        public void setModeless(boolean var1);
    }
}

