/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.lookupfield;

import com.vaadin.componentfactory.lookupfield.AbstractLookupField;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Set;

public class CustomFilterMultiSelectLookupField<T, FilterType>
extends AbstractLookupField<T, Set<T>, MultiSelectComboBox<T>, CustomFilterMultiSelectLookupField<T, FilterType>, FilterType> {
    private static final String SELECTED_SLOT_NAME = "selected";
    private Div selected;
    private Registration selectedListener;

    public CustomFilterMultiSelectLookupField(SerializableFunction<String, FilterType> filterConverter, SerializableFunction<FilterType, String> invertedFilterConverter) {
        this(new Grid(), new MultiSelectComboBox(), filterConverter, invertedFilterConverter);
    }

    public CustomFilterMultiSelectLookupField(Class<T> beanType, SerializableFunction<String, FilterType> filterConverter, SerializableFunction<FilterType, String> invertedFilterConverter) {
        this(new Grid(beanType), new MultiSelectComboBox(), filterConverter, invertedFilterConverter);
    }

    public CustomFilterMultiSelectLookupField(Grid<T> grid, MultiSelectComboBox<T> comboBox, SerializableFunction<String, FilterType> filterConverter, SerializableFunction<FilterType, String> invertedFilterConverter) {
        super(filterConverter, invertedFilterConverter);
        this.setGrid(grid);
        this.setComboBox(comboBox);
    }

    @Override
    public void setGrid(Grid<T> grid) {
        super.setGrid(grid);
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.getElement().setProperty("multiSelect", true);
    }

    public void setValue(Set<T> value) {
        ((MultiSelectComboBox)this.comboBox).setValue(value);
    }

    public Set<T> getValue() {
        return ((MultiSelectComboBox)this.comboBox).getValue();
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<CustomFilterMultiSelectLookupField<T, FilterType>, Set<T>>> listener) {
        return ((MultiSelectComboBox)this.comboBox).addValueChangeListener(listener);
    }

    @Override
    public void setComboBox(MultiSelectComboBox<T> comboBox) {
        Objects.requireNonNull(comboBox, "ComboBox cannot be null");
        if (this.comboBox != null && ((MultiSelectComboBox)this.comboBox).getElement().getParent() == this.getElement()) {
            ((MultiSelectComboBox)this.comboBox).getElement().removeFromParent();
        }
        comboBox.setClearButtonVisible(true);
        comboBox.setAllowCustomValue(true);
        comboBox.addCustomValueSetListener((ComponentEventListener & Serializable)e -> this.getElement().setProperty("_filterdata", e.getDetail()));
        comboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.getElement().setProperty("_filterdata", ""));
        this.comboBox = comboBox;
        comboBox.getElement().setAttribute("slot", "field");
        if (comboBox.getElement().getParent() == null) {
            this.getElement().appendChild(new Element[]{comboBox.getElement()});
        }
    }

    @Override
    public MultiSelectComboBox<T> getComboBox() {
        return (MultiSelectComboBox)this.comboBox;
    }

    @Override
    public void setDataProvider(ListDataProvider<T> listDataProvider) {
        ComboBox.ItemFilter & Serializable defaultItemFilter = (ComboBox.ItemFilter & Serializable)(item, filterText) -> ((MultiSelectComboBox)this.comboBox).getItemLabelGenerator().apply(item).toLowerCase(this.getLocale()).contains(filterText.toLowerCase(this.getLocale()));
        this.setDataProvider(defaultItemFilter, listDataProvider);
    }

    @Override
    public void setDataProvider(ComboBox.ItemFilter<T> itemFilter, ListDataProvider<T> listDataProvider) {
        Objects.requireNonNull(listDataProvider, "List data provider cannot be null");
        this.setDataProvider(listDataProvider, (SerializableFunction & Serializable)filterText -> (SerializablePredicate & Serializable)item -> itemFilter.test(item, (String)this.invertedFilterConverter.apply(filterText)));
    }

    @Override
    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        ((MultiSelectComboBox)this.comboBox).setItemLabelGenerator(itemLabelGenerator);
    }

    @Override
    public void setLabel(String label) {
        ((MultiSelectComboBox)this.comboBox).setLabel(label);
    }

    @Override
    @ClientCallable
    protected void copyFieldValueFromGrid() {
        Set selectedItems = this.getGrid().getSelectedItems();
        ((MultiSelectComboBox)this.comboBox).setValue(selectedItems);
        this.footerCloseAction();
    }

    @Override
    @ClientCallable
    protected void copyFieldValueToGrid() {
        this.getGrid().deselectAll();
        for (Object value : ((MultiSelectComboBox)this.comboBox).getValue()) {
            this.getGrid().select(value);
        }
    }

    public void showSelectedItems(boolean showSelectedItems) {
        if (this.selected != null && this.selected.getElement().getParent() == this.getElement()) {
            this.selected.getElement().removeFromParent();
        }
        if (showSelectedItems) {
            this.selected = new Div();
            this.selected.addClassName("selected-text");
            if (this.selectedListener != null) {
                this.selectedListener.remove();
            }
            this.selectedListener = this.getGrid().addSelectionListener((SelectionListener & Serializable)item -> this.updateMessage(item.getAllSelectedItems().size()));
            this.updateMessage(this.getGrid().getSelectedItems().size());
            this.selected.getElement().setAttribute("slot", SELECTED_SLOT_NAME);
            if (this.selected.getElement().getParent() == null) {
                this.getElement().appendChild(new Element[]{this.selected.getElement()});
            }
        } else {
            this.selected = null;
        }
    }

    private void updateMessage(int nbItems) {
        String message;
        String string = message = this.getI18n() != null && this.getI18n().getSelectedText() != null ? this.getI18n().getSelectedText() : "{0} item(s) selected";
        if (this.selected != null) {
            this.selected.setText(MessageFormat.format(message, nbItems));
        }
    }
}

