/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.lookupfield;

import com.vaadin.componentfactory.lookupfield.LookupFieldFilter;
import com.vaadin.componentfactory.lookupfield.LookupFieldVariant;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.HasFilterableDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tools.jackson.databind.ObjectMapper;

@Uses.Container(value={@Uses(value=Icon.class), @Uses(value=TextField.class), @Uses(value=Button.class)})
@Tag(value="vcf-lookup-field")
@JsModule(value="@vaadin-component-factory/vcf-lookup-field")
@NpmPackage(value="@vaadin-component-factory/vcf-lookup-field", version="6.0.3")
@StyleSheet(value="lookup-field.css")
public abstract class AbstractLookupField<T, SelectT, ComboboxT extends HasEnabled & HasValidation & HasValue<?, SelectT>, ComponentT extends AbstractLookupField<T, SelectT, ComboboxT, ComponentT, FilterType>, FilterType>
extends Div
implements HasFilterableDataProvider<T, FilterType>,
HasValueAndElement<AbstractField.ComponentValueChangeEvent<ComponentT, SelectT>, SelectT>,
HasValidation,
HasSize,
HasTheme {
    protected static final String FIELD_SLOT_NAME = "field";
    private static final String GRID_SLOT_NAME = "grid";
    private static final String FILTER_SLOT_NAME = "filter";
    private static final String HEADER_SLOT_NAME = "dialog-header";
    private static final String FOOTER_SLOT_NAME = "dialog-footer";
    protected static final String SLOT_KEY = "slot";
    private LookupFieldI18n i18n;
    private Grid<T> grid;
    protected ComboboxT comboBox;
    private ConfigurableFilterDataProvider<T, Void, FilterType> gridDataProvider;
    private LookupFieldFilter<FilterType> filter;
    private Runnable notificationWhenEmptySelection;
    protected final SerializableFunction<String, FilterType> filterConverter;
    protected final SerializableFunction<FilterType, String> invertedFilterConverter;
    private Registration filterRegistration;

    public AbstractLookupField(SerializableFunction<String, FilterType> filterConverter, SerializableFunction<FilterType, String> invertedFilterConverter) {
        this.filterConverter = filterConverter;
        this.invertedFilterConverter = invertedFilterConverter;
    }

    public void setGrid(Grid<T> grid) {
        Objects.requireNonNull(grid, "Grid cannot be null");
        if (this.grid != null && this.grid.getElement().getParent() == this.getElement()) {
            this.grid.getElement().removeFromParent();
        }
        this.grid = grid;
        this.grid.addItemClickListener((ComponentEventListener & Serializable)e -> {
            if (grid.getSelectionModel() instanceof GridMultiSelectionModel) {
                if (!grid.getSelectedItems().contains(e.getItem())) {
                    this.grid.deselectAll();
                    this.grid.select(e.getItem());
                } else {
                    this.grid.deselectAll();
                }
            }
        });
        grid.getElement().setAttribute(SLOT_KEY, GRID_SLOT_NAME);
        if (grid.getElement().getParent() == null) {
            this.getElement().appendChild(new Element[]{grid.getElement()});
        }
    }

    public abstract void setComboBox(ComboboxT var1);

    public abstract ComboboxT getComboBox();

    public void setItems(Collection<T> items) {
        this.setDataProvider(DataProvider.ofCollection(items));
    }

    public void setItems(ComboBox.ItemFilter<T> itemFilter, Collection<T> items) {
        ListDataProvider listDataProvider = DataProvider.ofCollection(items);
        this.setDataProvider(itemFilter, listDataProvider);
    }

    public abstract void setDataProvider(ListDataProvider<T> var1);

    public abstract void setDataProvider(ComboBox.ItemFilter<T> var1, ListDataProvider<T> var2);

    public <C> void setDataProvider(DataProvider<T, C> dataProvider, SerializableFunction<FilterType, C> filterConverter) {
        Objects.requireNonNull(dataProvider, "data provider cannot be null");
        DataProvider dataProviderFilteredByString = dataProvider.withConvertedFilter((SerializableFunction & Serializable)str -> filterConverter.apply(this.filterConverter.apply(str)));
        if (this.comboBox instanceof MultiSelectComboBox) {
            ((MultiSelectComboBox)this.comboBox).setItems(dataProviderFilteredByString);
        } else if (this.comboBox instanceof ComboBox) {
            ((ComboBox)this.comboBox).setItems(dataProviderFilteredByString);
        } else {
            throw new RuntimeException("Invalid object passed to the LookupField -> Must be either ComboBox or MultiSelectComboBox");
        }
        this.gridDataProvider = dataProvider.withConvertedFilter(filterConverter).withConfigurableFilter();
        this.grid.setDataProvider(this.gridDataProvider);
    }

    public Grid<T> getGrid() {
        return this.grid;
    }

    protected abstract void copyFieldValueFromGrid();

    protected abstract void copyFieldValueToGrid();

    @ClientCallable
    private void filterGrid(String filter) {
        if (filter != null && this.filter == null) {
            this.filterServerGrid(this.filterConverter.apply((Object)filter));
        }
    }

    public abstract void setItemLabelGenerator(ItemLabelGenerator<T> var1);

    public void setGridWidth(String width) {
        this.grid.setWidth(width);
        this.grid.setMaxWidth("100%");
    }

    public void setThemeVariants(LookupFieldVariant variants) {
        this.getElement().getThemeList().clear();
        this.addThemeVariants(variants);
    }

    public void addThemeVariants(LookupFieldVariant ... variants) {
        this.getElement().getThemeList().addAll((Collection)Stream.of(variants).map(LookupFieldVariant::getVariantName).collect(Collectors.toList()));
    }

    public void setHeader(String header) {
        this.getElement().setAttribute("header", header);
    }

    public abstract void setLabel(String var1);

    public void setModal(boolean modal) {
        this.getElement().setProperty("modeless", !modal);
    }

    public boolean isModal() {
        return !this.getElement().getProperty("modeless", false);
    }

    public void setDraggable(boolean draggable) {
        this.getElement().setProperty("draggable", draggable);
    }

    public boolean isDraggable() {
        return this.getElement().getProperty("draggable", false);
    }

    public void setResizable(boolean resizable) {
        this.getElement().setProperty("resizable", resizable);
    }

    public boolean isResizable() {
        return this.getElement().getProperty("resizable", false);
    }

    public void setSelectionDisabledIfEmpty(boolean defaultselectdisabled) {
        this.getElement().setProperty("defaultselectdisabled", defaultselectdisabled);
    }

    public boolean getSelectionDisabledIfEmpty() {
        return this.getElement().getProperty("defaultselectdisabled", true);
    }

    public LookupFieldI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(LookupFieldI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.setI18nWithJS();
    }

    private void setI18nWithJS() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            ObjectMapper mapper = new ObjectMapper();
            Map i18nMap = (Map)mapper.convertValue((Object)this.i18n, Map.class);
            i18nMap.forEach((key, value) -> this.getElement().executeJs("this.set('i18n." + key + "', $0)", new Object[]{value}));
        });
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public boolean isInvalid() {
        return ((HasValidation)this.comboBox).isInvalid();
    }

    public void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
        ((HasValidation)this.comboBox).setInvalid(invalid);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        ((HasValue)this.comboBox).setReadOnly(readOnly);
    }

    public void setEnabled(boolean enabled) {
        this.comboBox.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setErrorMessage(String errorMessage) {
        ((HasValidation)this.comboBox).setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return ((HasValidation)this.comboBox).getErrorMessage();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        ((HasValue)this.comboBox).setRequiredIndicatorVisible(requiredIndicatorVisible);
    }

    public void setHeaderComponent(Component header) {
        Objects.requireNonNull(header, "Header cannot be null");
        SlotUtils.clearSlot((HasElement)this, (String)HEADER_SLOT_NAME);
        header.getElement().setAttribute(SLOT_KEY, HEADER_SLOT_NAME);
        if (header.getElement().getParent() == null) {
            this.getElement().appendChild(new Element[]{header.getElement()});
        }
    }

    public void setFilter(LookupFieldFilter<FilterType> filter) {
        Objects.requireNonNull(filter, "Filter cannot be null");
        Objects.requireNonNull(filter.getComponent(), "Filter component cannot be null");
        if (this.filter != null && this.filter.getComponent() != null && this.filter.getComponent().getElement().getParent() == this.getElement()) {
            this.filter.getComponent().getElement().removeFromParent();
        }
        this.filter = filter;
        filter.getComponent().getElement().setAttribute(SLOT_KEY, FILTER_SLOT_NAME);
        filter.setFilterAction(value -> ComponentUtil.fireEvent((Component)this, new FilterEvent<Object>(this, false, value)));
        if (this.filterRegistration != null) {
            this.filterRegistration.remove();
        }
        this.filterRegistration = this.addFilterListener((ComponentEventListener & Serializable)e -> this.filterServerGrid(e.getFilterValue()));
        if (filter.getComponent().getElement().getParent() == null) {
            this.getElement().appendChild(new Element[]{filter.getComponent().getElement()});
        }
    }

    private void filterServerGrid(FilterType filter) {
        this.gridDataProvider.setFilter(filter);
    }

    public void setFooterComponent(Component footer) {
        Objects.requireNonNull(footer, "Footer cannot be null");
        SlotUtils.clearSlot((HasElement)this, (String)FOOTER_SLOT_NAME);
        footer.getElement().setAttribute(SLOT_KEY, FOOTER_SLOT_NAME);
        if (footer.getElement().getParent() == null) {
            this.getElement().appendChild(new Element[]{footer.getElement()});
        }
    }

    public void footerSelectAction() {
        this.copyFieldValueFromGrid();
        this.footerCloseAction();
    }

    public void footerCloseAction() {
        this.getElement().executeJs("$0.__close()", new Object[]{this.getElement()});
    }

    @ClientCallable
    private void openErrorNotification() {
        this.getNotificationWhenEmptySelection().run();
    }

    private Runnable getNotificationWhenEmptySelection() {
        if (this.notificationWhenEmptySelection == null) {
            return () -> {
                String emptySelection = this.getI18n() == null ? "Please select an item." : this.getI18n().getEmptyselection();
                new Notification(emptySelection, 2000, Notification.Position.TOP_CENTER).open();
            };
        }
        return this.notificationWhenEmptySelection;
    }

    public void addEmptySelectionListener(Runnable notificationWhenEmptySelection) {
        this.notificationWhenEmptySelection = notificationWhenEmptySelection;
    }

    public Registration addFilterListener(ComponentEventListener<FilterEvent<FilterType>> listener) {
        return this.addListener(FilterEvent.class, listener);
    }

    public Registration addCreateItemListener(ComponentEventListener<CreateItemEvent> listener) {
        this.setCreateVisible(true);
        return this.addListener(CreateItemEvent.class, listener);
    }

    public void setCreateVisible(boolean createVisible) {
        this.getElement().setProperty("createhidden", !createVisible);
    }

    public void open() {
        this.getComboBox().getElement().executeJs("setTimeout(() => $0.open(), 0)", new Object[0]);
    }

    public static class LookupFieldI18n
    implements Serializable {
        private String select;
        private String cancel;
        private String searcharialabel;
        private String headerprefix;
        private String headerpostfix;
        private String search;
        private String emptyselection;
        private String create;
        private String selectedText;

        public String getSearch() {
            return this.search;
        }

        public LookupFieldI18n setSearch(String search) {
            this.search = search;
            return this;
        }

        public String getSelect() {
            return this.select;
        }

        public LookupFieldI18n setSelect(String select) {
            this.select = select;
            return this;
        }

        public String getCancel() {
            return this.cancel;
        }

        public LookupFieldI18n setCancel(String cancel) {
            this.cancel = cancel;
            return this;
        }

        public String getSearcharialabel() {
            return this.searcharialabel;
        }

        public LookupFieldI18n setSearcharialabel(String searcharialabel) {
            this.searcharialabel = searcharialabel;
            return this;
        }

        public String getHeaderprefix() {
            return this.headerprefix;
        }

        public LookupFieldI18n setHeaderprefix(String headerprefix) {
            this.headerprefix = headerprefix;
            return this;
        }

        public String getHeaderpostfix() {
            return this.headerpostfix;
        }

        public LookupFieldI18n setHeaderpostfix(String headerpostfix) {
            this.headerpostfix = headerpostfix;
            return this;
        }

        public String getEmptyselection() {
            return this.emptyselection;
        }

        public LookupFieldI18n setEmptyselection(String emptyselection) {
            this.emptyselection = emptyselection;
            return this;
        }

        public String getCreate() {
            return this.create;
        }

        public LookupFieldI18n setCreate(String create) {
            this.create = create;
            return this;
        }

        public String getSelectedText() {
            return this.selectedText;
        }

        public LookupFieldI18n setSelectedText(String selectedText) {
            this.selectedText = selectedText;
            return this;
        }
    }

    @DomEvent(value="vcf-lookup-field-filter-event")
    public static class FilterEvent<FILTERTYPE>
    extends ComponentEvent<AbstractLookupField> {
        private final FILTERTYPE filterValue;

        public FilterEvent(AbstractLookupField source, boolean fromClient, @EventData(value="event.detail.value") FILTERTYPE filterValue) {
            super((Component)source, fromClient);
            this.filterValue = filterValue;
        }

        public FILTERTYPE getFilterValue() {
            return this.filterValue;
        }
    }

    @DomEvent(value="vcf-lookup-field-create-item-event")
    public static class CreateItemEvent
    extends ComponentEvent<AbstractLookupField> {
        public CreateItemEvent(AbstractLookupField source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

