/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.lookupfield;

import com.vaadin.componentfactory.lookupfield.AbstractLookupField;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

public class CustomFilterLookupField<T, FilterType>
extends AbstractLookupField<T, T, ComboBox<T>, CustomFilterLookupField<T, FilterType>, FilterType>
implements HasHelper {
    public CustomFilterLookupField(SerializableFunction<String, FilterType> filterConverter, SerializableFunction<FilterType, String> invertedFilterConverter) {
        this(new Grid(), new ComboBox(), filterConverter, invertedFilterConverter);
    }

    public CustomFilterLookupField(Class<T> beanType, SerializableFunction<String, FilterType> filterConverter, SerializableFunction<FilterType, String> invertedFilterConverter) {
        this(new Grid(beanType), new ComboBox(), filterConverter, invertedFilterConverter);
    }

    public CustomFilterLookupField(Grid<T> grid, ComboBox<T> comboBox, SerializableFunction<String, FilterType> filterConverter, SerializableFunction<FilterType, String> invertedFilterConverter) {
        super(filterConverter, invertedFilterConverter);
        this.setGrid(grid);
        this.setComboBox(comboBox);
    }

    public void setValue(T value) {
        ((ComboBox)this.comboBox).setValue(value);
    }

    public T getValue() {
        return (T)((ComboBox)this.comboBox).getValue();
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<CustomFilterLookupField<T, FilterType>, T>> listener) {
        return ((ComboBox)this.comboBox).addValueChangeListener(listener);
    }

    @Override
    public void setComboBox(ComboBox<T> comboBox) {
        Objects.requireNonNull(comboBox, "ComboBox cannot be null");
        if (this.comboBox != null && ((ComboBox)this.comboBox).getElement().getParent() == this.getElement()) {
            ((ComboBox)this.comboBox).getElement().removeFromParent();
        }
        comboBox.setClearButtonVisible(true);
        comboBox.setAllowCustomValue(true);
        comboBox.addCustomValueSetListener((ComponentEventListener & Serializable)e -> this.getElement().setProperty("_filterdata", e.getDetail()));
        comboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            String value = e.getValue() == null ? "" : comboBox.getItemLabelGenerator().apply(e.getValue());
            this.getElement().setProperty("_filterdata", value);
        });
        this.comboBox = comboBox;
        comboBox.getElement().setAttribute("slot", "field");
        if (comboBox.getElement().getParent() == null) {
            this.getElement().appendChild(new Element[]{comboBox.getElement()});
        }
    }

    @Override
    public ComboBox<T> getComboBox() {
        return (ComboBox)this.comboBox;
    }

    @Override
    public void setDataProvider(ListDataProvider<T> listDataProvider) {
        ComboBox.ItemFilter & Serializable defaultItemFilter = (ComboBox.ItemFilter & Serializable)(item, filterText) -> ((ComboBox)this.comboBox).getItemLabelGenerator().apply(item).toLowerCase(this.getLocale()).contains(filterText.toLowerCase(this.getLocale()));
        this.setDataProvider(defaultItemFilter, listDataProvider);
    }

    @Override
    public void setDataProvider(ComboBox.ItemFilter<T> itemFilter, ListDataProvider<T> listDataProvider) {
        Objects.requireNonNull(listDataProvider, "List data provider cannot be null");
        this.setDataProvider(listDataProvider, (SerializableFunction & Serializable)filterText -> (SerializablePredicate & Serializable)item -> itemFilter.test(item, (String)this.invertedFilterConverter.apply(filterText)));
    }

    @Override
    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        ((ComboBox)this.comboBox).setItemLabelGenerator(itemLabelGenerator);
    }

    @Override
    public void setLabel(String label) {
        ((ComboBox)this.comboBox).setLabel(label);
    }

    public String getHelperText() {
        return ((ComboBox)this.comboBox).getHelperText();
    }

    public void setHelperText(String helperText) {
        ((ComboBox)this.comboBox).setHelperText(helperText);
    }

    public void setHelperComponent(Component component) {
        ((ComboBox)this.comboBox).setHelperComponent(component);
    }

    public Component getHelperComponent() {
        return ((ComboBox)this.comboBox).getHelperComponent();
    }

    @Override
    @ClientCallable
    protected void copyFieldValueFromGrid() {
        boolean hasNoSelectionMessage;
        Set selectedItems = this.getGrid().getSelectedItems();
        if (!selectedItems.isEmpty()) {
            this.getGrid().getSelectedItems().stream().findFirst().ifPresent(arg_0 -> ((ComboBox)((ComboBox)this.comboBox)).setValue(arg_0));
            this.getElement().callJsFunction("__close", new Object[0]);
            return;
        }
        String noSelectionNotificationMessage = null;
        if (this.getI18n() != null) {
            noSelectionNotificationMessage = this.getI18n().getEmptyselection();
        }
        boolean bl = hasNoSelectionMessage = noSelectionNotificationMessage != null && !noSelectionNotificationMessage.isEmpty();
        if (hasNoSelectionMessage) {
            this.showNoSelectionNotification(noSelectionNotificationMessage);
        } else {
            this.getElement().callJsFunction("__close", new Object[0]);
        }
    }

    protected void showNoSelectionNotification(String noSelectionNotificationMessage) {
        Notification.show((String)noSelectionNotificationMessage);
    }

    @Override
    @ClientCallable
    protected void copyFieldValueToGrid() {
        this.getGrid().select(((ComboBox)this.comboBox).getValue());
    }
}

