/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.explorer;

import com.vaadin.componentfactory.explorer.ExplorerTreeGrid;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.List;

public class ExplorerTreeHierarchyColumnComponentRenderer<COMPONENT extends Component, SOURCE>
extends ComponentRenderer<COMPONENT, SOURCE> {
    public ExplorerTreeHierarchyColumnComponentRenderer(ValueProvider<SOURCE, COMPONENT> componentProvider, ExplorerTreeGrid<SOURCE> grid) {
        super(componentProvider);
        this.withFunction("onClick", (SerializableConsumer & Serializable)item -> {
            if (grid.isExpanded(item)) {
                grid.collapse(List.of(item), true);
                this.refreshGrid(grid);
            } else {
                grid.expand(List.of(item), true);
                this.refreshGrid(grid);
            }
        });
        this.withProperty("children", (ValueProvider & Serializable)item -> grid.getDataCommunicator().hasChildren(item));
    }

    private void refreshGrid(ExplorerTreeGrid<SOURCE> grid) {
        grid.getElement().executeJs("setTimeout(() => $0.clearCache(), 100)", new Object[]{grid.getElement()});
    }

    protected String getTemplateExpression() {
        String clickListener = "e => requestAnimationFrame(() => { e.defaultPrevented && onClick(e) })";
        return "<explorer-tree-grid-toggle @click=${" + clickListener + "} class=${item.cssClassName} .leaf=${!item.children} .last=${model.last} .first=${model.first} .parentlines=${model.parentlines} .expanded=${model.expanded} .level=${model.level}>" + super.getTemplateExpression() + "</explorer-tree-grid-toggle>";
    }
}

