/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.explorer;

import com.vaadin.componentfactory.explorer.ExplorerTreeHierarchyColumnComponentRenderer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.grid.AbstractGridMultiSelectionModel;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

@Uses(value=Icon.class)
@JsModule.Container(value={@JsModule(value="./src/explorer-tree-toggle.js"), @JsModule(value="./src/explorer-grid-connector.js")})
public class ExplorerTreeGrid<T>
extends TreeGrid<T> {
    public ExplorerTreeGrid() {
    }

    public ExplorerTreeGrid(Class<T> beanType) {
        super(beanType);
    }

    public ExplorerTreeGrid(HierarchicalDataProvider<T, ?> dataProvider) {
        super(dataProvider);
    }

    protected void initConnector() {
        super.initConnector();
        ((UI)this.getUI().orElseThrow(() -> new IllegalStateException("Connector can only be initialized for an attached Grid"))).getPage().executeJs("window.Vaadin.Flow.explorerGridConnector.initLazy($0)", new Object[]{this.getElement()});
    }

    public Grid.Column<T> addHierarchyColumn(ValueProvider<T, ?> labelProvider) {
        return this.addHierarchyColumn(labelProvider, (ValueProvider & Serializable)object -> "");
    }

    public Grid.Column<T> addHierarchyColumn(ValueProvider<T, ?> labelProvider, ValueProvider<T, ?> iconProvider) {
        Grid.Column column = this.addColumn((Renderer)LitRenderer.of((String)"<explorer-tree-grid-toggle @click=${onClick} .leaf=${item.leaf} .expanded=${model.expanded} .last=${model.last} .first=${model.first} .parentlines=${model.parentlines} .level=${model.level} icon=${item.icon}>${item.name}</explorer-tree-grid-toggle>").withProperty("leaf", (ValueProvider & Serializable)item -> !this.getDataCommunicator().hasChildren(item)).withProperty("icon", iconProvider).withProperty("name", labelProvider).withFunction("onClick", (SerializableConsumer & Serializable)item -> {
            if (this.getDataCommunicator().hasChildren(item)) {
                if (this.isExpanded(item)) {
                    this.collapse(List.of(item), true);
                    this.refreshGrid();
                } else {
                    this.expand(List.of(item), true);
                    this.refreshGrid();
                }
            }
        }));
        SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(a, b) -> ExplorerTreeGrid.compareMaybeComparables((Object)labelProvider.apply(a), (Object)labelProvider.apply(b));
        column.setComparator((Comparator)comparator);
        return column;
    }

    private void refreshGrid() {
        this.getElement().executeJs("setTimeout(() => $0.clearCache(), 100)", new Object[]{this.getElement()});
    }

    protected void collapse(Collection<T> items, boolean userOriginated) {
        super.collapse(items, userOriginated);
    }

    protected void expand(Collection<T> items, boolean userOriginated) {
        super.expand(items, userOriginated);
    }

    public <V extends Component> Grid.Column<T> addComponentHierarchyColumn(ValueProvider<T, V> componentProvider) {
        return this.addColumn((Renderer)new ExplorerTreeHierarchyColumnComponentRenderer<V, T>(componentProvider, this).withProperty("leaf", (ValueProvider & Serializable)item -> !this.getDataCommunicator().hasChildren(item)));
    }

    public GridSelectionModel<T> setHierarchicalSelectionMode(Grid.SelectionMode selectionMode) {
        if (Grid.SelectionMode.MULTI == selectionMode) {
            AbstractGridMultiSelectionModel model = new AbstractGridMultiSelectionModel<T>((Grid)this){

                protected void fireSelectionEvent(SelectionEvent<Grid<T>, T> event) {
                    ((ExplorerTreeGrid)this.getGrid()).fireEvent((ComponentEvent)event);
                }

                public void selectFromClient(T item) {
                    this.updateSelection(new HashSet(ExplorerTreeGrid.this.getChildrenRecursively(Collections.singletonList(item), 99)), Collections.emptySet());
                }

                public void deselectFromClient(T item) {
                    this.updateSelection(Collections.emptySet(), new HashSet(ExplorerTreeGrid.this.getChildrenRecursively(Collections.singletonList(item), 99)));
                }
            };
            this.setSelectionModel((GridSelectionModel)model, selectionMode);
            return model;
        }
        return super.setSelectionMode(selectionMode);
    }

    protected Collection<T> getChildrenRecursively(Collection<T> items, int depth) {
        ArrayList itemsWithChildren = new ArrayList();
        if (depth < 0) {
            return itemsWithChildren;
        }
        items.stream().forEach(item -> {
            itemsWithChildren.add(item);
            if (this.getDataCommunicator().hasChildren(item)) {
                itemsWithChildren.addAll(this.getChildrenRecursively(this.getDataProvider().fetchChildren(new HierarchicalQuery(null, item)).toList(), depth - 1));
            }
        });
        return itemsWithChildren;
    }
}

