/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.toolbar;

import com.vaadin.componentfactory.SlotUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public class ToolbarSwitch
extends Button {
    private boolean active;

    public ToolbarSwitch() {
        this.init();
    }

    public ToolbarSwitch(String text) {
        super(text);
        this.init();
    }

    public ToolbarSwitch(Component icon) {
        super(icon);
        this.init();
    }

    public ToolbarSwitch(VaadinIcon icon) {
        super((Component)icon.create());
        this.init();
    }

    public ToolbarSwitch(VaadinIcon icon, VaadinIcon suffixIcon) {
        this((Component)icon.create(), (Component)suffixIcon.create());
    }

    public ToolbarSwitch(Component icon, Component suffixIcon) {
        super(icon);
        this.init();
        SlotUtil.addSuffixIcon((Button)this, suffixIcon);
    }

    public ToolbarSwitch(String text, Component icon) {
        super(text, icon);
        this.init();
    }

    private void init() {
        this.addClickListener((ComponentEventListener & Serializable)event -> this.updateActivate(!this.active, event.isFromClient()));
    }

    public boolean toggle() {
        this.setActive(!this.active);
        return this.active;
    }

    public void setActive(boolean active) {
        this.updateActivate(active, false);
    }

    private void updateActivate(boolean active, boolean fromClient) {
        if (this.active != active) {
            this.active = active;
            if (active) {
                this.getElement().setAttribute("on", "on");
            } else {
                this.getElement().removeAttribute("on");
            }
            this.fireEvent(new ActiveChangedEvent(this, fromClient));
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public Registration addActiveChangedListener(ComponentEventListener<ActiveChangedEvent> listener) {
        return this.addListener(ActiveChangedEvent.class, listener);
    }

    public static class ActiveChangedEvent
    extends ComponentEvent<ToolbarSwitch> {
        public ActiveChangedEvent(ToolbarSwitch source, boolean fromClient) {
            super((Component)source, fromClient);
        }

        public boolean isActive() {
            return ((ToolbarSwitch)this.getSource()).isActive();
        }
    }
}

