/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.toolbar;

import com.vaadin.componentfactory.toolbar.ToolbarSwitch;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.popover.Popover;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public class ToolbarPopover
extends Popover {
    private Registration focusOnOpenTargetRegistration;

    public static ToolbarPopover vertical(ToolbarSwitch toolbarSwitch, Component ... components) {
        ToolbarPopover popup = new ToolbarPopover(toolbarSwitch);
        popup.add(new Component[]{new VerticalLayout(components)});
        return popup;
    }

    public static ToolbarPopover horizontal(ToolbarSwitch toolbarSwitch, Component ... components) {
        return ToolbarPopover.horizontal(toolbarSwitch, FlexComponent.Alignment.CENTER, components);
    }

    public static ToolbarPopover horizontal(ToolbarSwitch toolbarSwitch, FlexComponent.Alignment alignment, Component ... components) {
        ToolbarPopover popup = new ToolbarPopover(toolbarSwitch);
        HorizontalLayout layout = new HorizontalLayout(components);
        layout.setPadding(true);
        layout.setAlignItems(alignment);
        popup.add(new Component[]{layout});
        return popup;
    }

    public ToolbarPopover(ToolbarSwitch referencedSwitch) {
        this.setTarget((Component)referencedSwitch);
        this.setAutofocus(true);
        this.getElement().setProperty("restoreFocusOnClose", true);
        this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> referencedSwitch.setActive(event.isOpened()));
        referencedSwitch.addAttachListener((ComponentEventListener & Serializable)event -> ((Component)event.getSource().getParent().orElseThrow(IllegalStateException::new)).getElement().appendChild(new Element[]{this.getElement()}));
        referencedSwitch.addDetachListener((ComponentEventListener & Serializable)event -> this.getElement().removeFromParent());
    }

    public void setFocusOnOpenTarget(Component focusOnOpenTarget) {
        if (this.focusOnOpenTargetRegistration != null) {
            this.focusOnOpenTargetRegistration.remove();
        }
        this.focusOnOpenTargetRegistration = this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
            if (event.isOpened()) {
                focusOnOpenTarget.getElement().callJsFunction("focus", new Serializable[0]);
            }
        });
    }
}

