/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.toolbar;

import com.vaadin.componentfactory.toolbar.ToolbarSwitch;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.dialog.DialogVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public class ToolbarDialog
extends Dialog {
    private final ToolbarSwitch toolbarSwitch;
    private Registration focusOnOpenTargetRegistration;
    private boolean openAtSwitch;
    private boolean ignoreNextEvent;

    public ToolbarDialog(ToolbarSwitch toolbarSwitch) {
        this(toolbarSwitch, false);
    }

    public ToolbarDialog(ToolbarSwitch toolbarSwitch, boolean openAtSwitch) {
        this.toolbarSwitch = toolbarSwitch;
        this.openAtSwitch = openAtSwitch;
        toolbarSwitch.addActiveChangedListener((ComponentEventListener<ToolbarSwitch.ActiveChangedEvent>)(ComponentEventListener & Serializable)event -> {
            if (!this.ignoreNextEvent) {
                this.ignoreNextEvent = true;
                this.setOpened(event.isActive());
                this.ignoreNextEvent = false;
            }
        });
        if (toolbarSwitch.isActive()) {
            this.setOpened(true);
        }
        this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
            if (!this.ignoreNextEvent) {
                this.ignoreNextEvent = true;
                toolbarSwitch.setActive(event.isOpened());
                this.ignoreNextEvent = false;
            }
            if (!event.isOpened()) {
                toolbarSwitch.focus();
            }
        });
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(true);
        this.setModal(false);
        this.setResizable(true);
        this.setDraggable(true);
        this.addThemeVariants((ThemeVariant[])new DialogVariant[]{DialogVariant.LUMO_NO_PADDING});
        this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
            if (this.openAtSwitch && event.isOpened()) {
                this.getElement().executeJs("const {left, top, width, height} = $0.getBoundingClientRect();\nthis.$.overlay.$.overlay.style.position = 'absolute';\nthis.$.overlay.$.overlay.style.left = left + 'px';\nthis.$.overlay.$.overlay.style.top = top + height + 'px';", new Serializable[]{this.getToolbarSwitch()});
            }
        });
    }

    public static ToolbarDialog vertical(ToolbarSwitch toolbarSwitch, Component ... components) {
        ToolbarDialog dialog = new ToolbarDialog(toolbarSwitch);
        dialog.add(new Component[]{new VerticalLayout(components)});
        return dialog;
    }

    public static ToolbarDialog horizontal(ToolbarSwitch toolbarSwitch, Component ... components) {
        return ToolbarDialog.horizontal(toolbarSwitch, FlexComponent.Alignment.CENTER, components);
    }

    public static ToolbarDialog horizontal(ToolbarSwitch toolbarSwitch, FlexComponent.Alignment alignment, Component ... components) {
        ToolbarDialog dialog = new ToolbarDialog(toolbarSwitch);
        HorizontalLayout layout = new HorizontalLayout(components);
        layout.setPadding(true);
        layout.setAlignItems(alignment);
        dialog.add(new Component[]{layout});
        return dialog;
    }

    public void setFocusOnOpenTarget(Component focusOnOpenTarget) {
        if (this.focusOnOpenTargetRegistration != null) {
            this.focusOnOpenTargetRegistration.remove();
        }
        this.focusOnOpenTargetRegistration = this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
            if (event.isOpened()) {
                focusOnOpenTarget.getElement().callJsFunction("focus", new Serializable[0]);
            }
        });
    }

    public ToolbarSwitch getToolbarSwitch() {
        return this.toolbarSwitch;
    }

    public ToolbarDialog openAtSwitch() {
        this.openAtSwitch = true;
        return this;
    }
}

