/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory;

import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;

public class TabConverter {
    private static final String ZERO_WIDTH_SPACE = "\ufeff";

    public static String convertIfNeeded(String deltaJson) {
        if (deltaJson == null || deltaJson.isBlank()) {
            return deltaJson;
        }
        if (deltaJson.contains("\"tabs-cont\"") || deltaJson.contains("\"pre-tab\"") || deltaJson.contains("\"line-part\"") || deltaJson.contains("\"tab\"") && deltaJson.contains("\"tab\":\"")) {
            String trimmed = deltaJson.trim();
            if (trimmed.startsWith("[")) {
                String wrapped = "{\"ops\":" + trimmed + "}";
                String converted = TabConverter.convertToNewFormat(wrapped);
                JsonObject obj = Json.parse((String)converted);
                return obj.getArray("ops").toJson();
            }
            return TabConverter.convertToNewFormat(deltaJson);
        }
        return deltaJson;
    }

    public static String convertToNewFormat(String oldDeltaJson) {
        if (oldDeltaJson == null || oldDeltaJson.isBlank()) {
            return oldDeltaJson;
        }
        JsonObject oldDelta = Json.parse((String)oldDeltaJson);
        JsonArray oldOps = oldDelta.getArray("ops");
        if (oldOps == null) {
            return oldDeltaJson;
        }
        JsonArray newOps = Json.createArray();
        for (int i = 0; i < oldOps.length(); ++i) {
            JsonObject op = oldOps.getObject(i);
            TabConverter.convertOp(op, newOps);
        }
        JsonObject newDelta = Json.createObject();
        newDelta.put("ops", (JsonValue)newOps);
        return newDelta.toJson();
    }

    private static void convertOp(JsonObject op, JsonArray newOps) {
        JsonObject attributes;
        JsonValue insertValue = op.get("insert");
        JsonObject jsonObject = attributes = op.hasKey("attributes") ? op.getObject("attributes") : null;
        if (attributes != null && attributes.hasKey("tab")) {
            String tabValue = attributes.getString("tab");
            int tabCount = TabConverter.parseTabLevel(tabValue);
            for (int t = 0; t < tabCount; ++t) {
                JsonObject tabEmbed = Json.createObject();
                tabEmbed.put("tab", true);
                JsonObject tabOp = Json.createObject();
                tabOp.put("insert", (JsonValue)tabEmbed);
                newOps.set(newOps.length(), (JsonValue)tabOp);
            }
            return;
        }
        if (attributes != null && attributes.hasKey("pre-tab")) {
            JsonObject tabEmbed = Json.createObject();
            tabEmbed.put("tab", true);
            JsonObject tabOp = Json.createObject();
            tabOp.put("insert", (JsonValue)tabEmbed);
            newOps.set(newOps.length(), (JsonValue)tabOp);
            return;
        }
        if (attributes != null && attributes.hasKey("line-part")) {
            String text;
            String string = text = insertValue.getType() == JsonType.STRING ? insertValue.asString() : null;
            if (ZERO_WIDTH_SPACE.equals(text)) {
                return;
            }
            JsonObject newOp = Json.createObject();
            newOp.put("insert", text);
            JsonObject remainingAttributes = TabConverter.removeAttribute(attributes, "line-part");
            if (remainingAttributes != null && remainingAttributes.keys().length > 0) {
                newOp.put("attributes", (JsonValue)remainingAttributes);
            }
            newOps.set(newOps.length(), (JsonValue)newOp);
            return;
        }
        if (attributes != null && attributes.hasKey("tabs-cont")) {
            JsonObject newOp = Json.createObject();
            newOp.put("insert", "\n");
            JsonObject remainingAttributes = TabConverter.removeAttribute(attributes, "tabs-cont");
            if (remainingAttributes != null && remainingAttributes.keys().length > 0) {
                newOp.put("attributes", (JsonValue)remainingAttributes);
            }
            newOps.set(newOps.length(), (JsonValue)newOp);
            return;
        }
        newOps.set(newOps.length(), (JsonValue)TabConverter.copyJsonObject(op));
    }

    private static int parseTabLevel(String tabValue) {
        if ("true".equals(tabValue)) {
            return 1;
        }
        try {
            return Integer.parseInt(tabValue);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private static JsonObject removeAttribute(JsonObject attributes, String attributeToRemove) {
        JsonObject result = Json.createObject();
        for (String key : attributes.keys()) {
            if (key.equals(attributeToRemove)) continue;
            result.put(key, TabConverter.copyJsonValue(attributes.get(key)));
        }
        return result;
    }

    private static JsonObject copyJsonObject(JsonObject original) {
        JsonObject copy = Json.createObject();
        for (String key : original.keys()) {
            copy.put(key, TabConverter.copyJsonValue(original.get(key)));
        }
        return copy;
    }

    private static JsonValue copyJsonValue(JsonValue value) {
        if (value == null) {
            return Json.createNull();
        }
        switch (value.getType()) {
            case STRING: {
                return Json.create((String)value.asString());
            }
            case NUMBER: {
                return Json.create((double)value.asNumber());
            }
            case BOOLEAN: {
                return Json.create((boolean)value.asBoolean());
            }
            case OBJECT: {
                return TabConverter.copyJsonObject((JsonObject)value);
            }
            case ARRAY: {
                JsonArray arrayCopy = Json.createArray();
                JsonArray original = (JsonArray)value;
                for (int i = 0; i < original.length(); ++i) {
                    arrayCopy.set(i, TabConverter.copyJsonValue(original.get(i)));
                }
                return arrayCopy;
            }
        }
        return Json.createNull();
    }
}

